/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.LicenseRemoteDao;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.gar.common.GarLoadedReport;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressCity;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressHouse;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressStreet;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressType;
import ru.bitel.bgbilling.plugins.gar.common.model.GarLoadedHistoryEntry;
import ru.bitel.bgbilling.plugins.gar.common.service.GarService;
import ru.bitel.bgbilling.plugins.gar.server.bean.GarAddressDao;
import ru.bitel.bgbilling.plugins.gar.server.service.GarLoader;
import ru.bitel.bgbilling.plugins.gar.server.service.GarServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.gar.common.service.GarService")
public class GarServiceImpl
extends AbstractService
implements GarService {
    private GarServer garServer;

    @PostConstruct
    public void setUp() {
        this.garServer = new GarServer();
    }

    public List<IdTitle> regionList() throws BGException, BGMessageException {
        ArrayList<IdTitle> regionList = new ArrayList<IdTitle>();
        JSONArray regions = new JSONArray(this.garServer.getRegionList());
        for (int i = 0; i < regions.length(); ++i) {
            JSONObject region = regions.getJSONObject(i);
            regionList.add(new IdTitle(region.getInt("regionId"), region.getString("regionTitle")));
        }
        return regionList;
    }

    public List<IdTitle> searchCitiesByContainsName(int regionId, String searchValue) throws BGException, BGMessageException {
        ArrayList<IdTitle> cities = new ArrayList<IdTitle>();
        JSONArray citiesArray = new JSONArray(this.garServer.searchCitiesByContainsName(regionId, searchValue));
        for (int i = 0; i < citiesArray.length(); ++i) {
            JSONObject cityJson = citiesArray.optJSONObject(i);
            int cityId = cityJson.optInt("cityId");
            String cityTitle = cityJson.optString("cityPrefix") + "." + cityJson.optString("cityName");
            cities.add(new IdTitle(cityId, cityTitle));
        }
        return cities;
    }

    public GarAddressCity getGarCityInfoByCityId(long cityId) throws BGException, BGMessageException {
        return this.cityFromJson(new JSONObject(this.garServer.getGarCityInfoByCityId(cityId)));
    }

    private GarAddressCity cityFromJson(JSONObject json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        GarAddressCity garAddressCity = new GarAddressCity();
        garAddressCity.setId(json.optInt("cityId"));
        garAddressCity.setTitle(json.optString("cityName"));
        garAddressCity.setCladrCode(json.optString("cladrCode"));
        garAddressCity.setGarObjectId(json.optLong("garObjectId"));
        garAddressCity.setTypeName(json.optString("cityPrefix"));
        garAddressCity.setFullName(json.optString("fullAddress"));
        return garAddressCity;
    }

    public List<GarAddressStreet> getStreetsByCityId(long cityId) throws BGException, BGMessageException {
        ArrayList<GarAddressStreet> streets = new ArrayList<GarAddressStreet>();
        JSONArray streetsJson = new JSONObject(this.garServer.getStreetsByCityId(cityId)).optJSONArray("streets");
        for (int i = 0; i < streetsJson.length(); ++i) {
            JSONObject streetJson = streetsJson.optJSONObject(i);
            GarAddressStreet street = new GarAddressStreet();
            street.setId(streetJson.optInt("streetId"));
            street.setTitle(streetJson.optString("streetName"));
            street.setTypeName(streetJson.optString("streetPrefix"));
            ArrayList<GarAddressHouse> houseList = new ArrayList<GarAddressHouse>();
            JSONArray houses = streetJson.optJSONArray("houses");
            for (int j = 0; j < houses.length(); ++j) {
                JSONObject house = houses.optJSONObject(j);
                GarAddressHouse garAddressHouse = new GarAddressHouse(house.optInt("garObjectId"), house.optString("houseNumber"), house.optLong("streetId"), house.optString("postIndex"), house.optString("cadastralNumber"));
                houseList.add(garAddressHouse);
            }
            street.setHouses(houseList);
            streets.add(street);
        }
        return streets;
    }

    public boolean checkLoadedRegion(int regionId) throws BGException, BGMessageException {
        JSONObject response = new JSONObject(this.garServer.checkLoadedRegion(regionId));
        return !response.optBoolean("result");
    }

    public void updateUserAuthData(String login, String pswd) throws BGException, BGMessageException {
        if (Utils.isBlankString((String)login) || Utils.isBlankString((String)pswd)) {
            throw new BGException("\u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c");
        }
        Setup setup = Setup.getSetup();
        setup.set("license.contract.title", login);
        setup.set("license.contract.password", pswd);
        ServerContext serverContext = (ServerContext)ServerContext.get();
        LicenseRemoteDao licenseRemoteDao = new LicenseRemoteDao(serverContext.getConnection());
        List licenseData = licenseRemoteDao.list();
        if (Utils.isEmptyCollection((Collection)licenseData)) {
            throw new BGException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439.");
        }
        this.garServer.updateUserAuthData(login, pswd);
    }

    public JSONObject getUserAuthData() throws BGException, BGMessageException {
        Setup setup = Setup.getSetup();
        JSONObject data = new JSONObject();
        data.put("license.contract.title", (Object)setup.get("license.contract.title", ""));
        data.put("license.contract.password", (Object)setup.get("license.contract.password", ""));
        return data;
    }

    public GarLoadedReport loadDataInDB(int countryId, GarAddressCity city, List<GarAddressStreet> streets) throws BGException, BGMessageException {
        if (city == null || Utils.isEmptyCollection(streets)) {
            throw new BGException("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f");
        }
        if (countryId <= 0) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0430 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u0440\u0435\u0441\u043e\u0432");
        }
        GarAddressDao garAddressDao = new GarAddressDao(this.getConnection());
        GarLoader garLoader = new GarLoader(1, (ServerContext)ServerContext.get());
        GarLoadedReport report = new GarLoadedReport();
        String cityName = city.getTypeName() + ". " + city.getTitle();
        int newCityId = garLoader.saveCityInDBIfNotExists(cityName);
        if (newCityId > 0) {
            report.setCreateNewCity(true);
            report.setNewCityId(newCityId);
            report.setNewCityName(cityName);
            garAddressDao.update(new GarLoadedHistoryEntry(city.getGarObjectId(), GarAddressType.CITY, newCityId, cityName));
        } else {
            City oldCity = garLoader.findCityByTitle(cityName);
            newCityId = oldCity.getId();
        }
        if (newCityId <= 0) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0443\u043b\u0438\u0446 \u043a \u043d\u0430\u0441\u0435\u043b\u0451\u043d\u043d\u043e\u043c\u0443 \u043f\u0443\u043d\u043a\u0442\u0443. \u0423\u043b\u0438\u0446\u044b \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b.");
        }
        ArrayList<GarAddressStreet> loadedStreets = new ArrayList<GarAddressStreet>();
        for (GarAddressStreet street : streets) {
            int newStreetId = garLoader.saveStreetInDBIfNotExists(newCityId, street.getTitle());
            if (newStreetId <= 0) continue;
            loadedStreets.add(street);
            garLoader.saveHousesByStreet(newStreetId, street);
            garAddressDao.update(new GarLoadedHistoryEntry(street.getGarObjectId(), GarAddressType.STREET, newStreetId, street.getTitle()));
        }
        report.setNewStreets(loadedStreets);
        return report;
    }

    public List<IdTitle> getCountries() throws BGException, BGMessageException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        AddressService addressService = (AddressService)this.context.getService(AddressService.class, 0);
        for (Country country : addressService.searchCountryList(null, null, null).getList()) {
            result.add(new IdTitle(country.getId(), country.getTitle()));
        }
        return result;
    }

    public String loadRegion(int regionId) throws BGException, BGMessageException {
        return this.garServer.startLoadRegion(regionId);
    }

    public SearchResult<GarLoadedHistoryEntry> getLoadedHistory(Page page, Date dateFrom, Date dateTo) throws BGException {
        SearchResult result = new SearchResult();
        result.setPage(page);
        GarAddressDao garAddressDao = new GarAddressDao(this.getConnection());
        garAddressDao.searchEntries(dateFrom, dateTo, (SearchResult<GarLoadedHistoryEntry>)result);
        return result;
    }
}

