/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.gar.common.model.GarAddressType;
import ru.bitel.bgbilling.plugins.gar.common.model.GarLoadedHistoryEntry;
import ru.bitel.bgbilling.plugins.gar.common.service.GarService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.SearchResult;

public class GarStatisticPanel
extends BGUPanel {
    private GarService garService;
    private BGUTable table;
    private GarStatisticTableModel tableModel;
    private final BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private final JLabel recordCountLabel = new JLabel();
    private final BGControlPanelPages page = new BGControlPanelPages();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445");
        this.tableModel = new GarStatisticTableModel((ClientContext)this.getContext());
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        JButton search = new JButton("\u0418\u0441\u043a\u0430\u0442\u044c");
        search.addActionListener(e -> this.performAction("refresh"));
        this.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(search, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.getFilterPanel(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addPropertyChangeListener(evt -> {
            if (this.tableModel.getRowCount() > 0) {
                this.performAction("refresh");
            }
        });
        JPanel filterPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 0, 0.0, 1.0, 13, 2, new Insets(0, 5, 0, 0), 0, 0);
        filterPanel.add((Component)this.recordCountLabel, constraints);
        filterPanel.add((Component)this.page, constraints);
        return filterPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SearchResult result = GarStatisticPanel.this.getGarService().getLoadedHistory(GarStatisticPanel.this.page.getPage(), GarStatisticPanel.this.periodPanel.getDateFrom(), GarStatisticPanel.this.periodPanel.getDateTo());
                GarStatisticPanel.this.tableModel.setData(result.getList());
                GarStatisticPanel.this.page.setPage(result.getPage());
                GarStatisticPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + result.getPage().getRecordCount());
            }
        };
    }

    private GarService getGarService() {
        if (this.garService == null) {
            this.garService = (GarService)((ClientContext)this.getContext()).getPort(GarService.class, 0);
        }
        return this.garService;
    }

    private static final class GarStatisticTableModel
    extends BGTableModel<GarLoadedHistoryEntry> {
        private Directory<UserInfo> userDirectory;

        public GarStatisticTableModel(ClientContext clientContext) throws BGException {
            super("");
            this.userDirectory = clientContext.getDirectory(UserInfo.class, 0);
        }

        protected void initColumns() {
            this.addColumn("ID \u0432 \u0413\u0410\u0420", -1, 200, 200, "garObjectId", true);
            this.addColumn("ID \u0432 \u0411\u0414", -1, 200, 200, "bgObjectId", true);
            this.addColumn("\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430", -1, 200, 200, "garAddressType", true);
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, 300, -1, "garObjectTitle", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438", Column.DateTime.class, -1, 200, 200, "loadedTime", true);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 120, 150, 200, "userId", true);
        }

        public Object getValueAt(GarLoadedHistoryEntry val, int column) throws BGException {
            switch (column) {
                case 3: {
                    if (val.getGarAddressType() == null) {
                        return "<\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>";
                    }
                    return val.getGarAddressType().equals((Object)GarAddressType.CITY) ? "\u041d\u0430\u0441.\u043f\u0443\u043d\u043a\u0442" : "\u0423\u043b\u0438\u0446\u0430";
                }
                case 6: {
                    UserInfo user = (UserInfo)this.userDirectory.get(val.getUserId());
                    return user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
            }
            return super.getValueAt((Object)val, column);
        }
    }
}

