/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import bitel.billing.module.common.BGComboBoxFixed;
import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeGroup;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class AddContactDialog
extends BGDialog {
    private BGButtonPanelOkCancel bGControlPanel_05 = new BGButtonPanelOkCancel();
    private BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.im");
    private BGTextField jidField = new BGTextField();
    private BGTextField nameField = new BGTextField();
    private BGComboBoxFixed groupCB = new BGComboBoxFixed();

    public AddContactDialog(Iterable<RosterTreeNodeGroup> groups) {
        try {
            this.jbInit();
            this.fillGroupList(groups);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(this.plugin.getResourceString("addContact_DialogCaption"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                AddContactDialog.this.jidField.requestFocusInWindow();
            }
        });
        this.bGControlPanel_05.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddContactDialog.this.bGControlPanel_05_actionPerformed(actionEvent);
            }
        });
        JPanel filterPanel1 = new JPanel(new GridBagLayout());
        filterPanel1.add((Component)new JLabel(this.plugin.getResourceString("jid_LabelTitle")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.jidField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.jidField.setColumns(25);
        filterPanel1.add((Component)new JLabel(this.plugin.getResourceString("name_LabelTitle")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.nameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.nameField.setColumns(25);
        filterPanel1.add((Component)new JLabel(this.plugin.getResourceString("groups_LabelTitle")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)this.groupCB, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.groupCB.setEditable(true);
        this.getContentPane().add((Component)filterPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.bGControlPanel_05, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getRootPane().setDefaultButton(this.bGControlPanel_05.getButtonOk());
    }

    private void fillGroupList(Iterable<RosterTreeNodeGroup> groups) {
        this.groupCB.addItem(null, "<General>");
        for (RosterTreeNodeGroup groupNode : groups) {
            if (IMConstants.isReservedGroupName((String)groupNode.getName())) continue;
            this.groupCB.addItem((Object)groupNode.getName(), groupNode.getName());
        }
    }

    private void bGControlPanel_05_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (BGButtonPanelOkCancel.OK.equals((Object)actionCommand)) {
            if (!this.getJid().isEmpty() && !IMConstants.isReservedGroupName((String)this.getGroup())) {
                this.setVisible(false);
                this.dispose();
                this.result = "ok";
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
                super.setVisible(true);
            }
        } else if (BGButtonPanelOkCancel.CANCEL.equals((Object)actionCommand)) {
            this.setVisible(false);
            this.dispose();
            this.result = "cancel";
        }
    }

    public String getJid() {
        return this.jidField.getText().trim();
    }

    public String getName() {
        String n = this.nameField.getText().trim();
        return !n.isEmpty() ? n : null;
    }

    public String getGroup() {
        String gn = null;
        try {
            Object selectedItem = this.groupCB.getSelectedItem();
            if (selectedItem instanceof ComboBoxItem) {
                String scsi = (String)((ComboBoxItem)selectedItem).getObject();
                gn = scsi != null ? scsi.trim() : null;
            } else if (selectedItem instanceof String) {
                gn = (String)selectedItem;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return gn;
    }
}

