/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.server.action;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.bgbilling.plugins.im.common.IMMessage;
import ru.bitel.bgbilling.plugins.im.common.IMMessageList;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.bgbilling.plugins.im.server.bean.MessageManager;
import ru.bitel.bgbilling.server.util.ServerUtils;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    private static final String SESSION_IM_CONNECTION_ATTR = "IM.XMPP.Connections";
    private static final String SESSION_IM_USERMESSAGELIST_ATTR = "IM.XMPP.UserMessagelistMap";
    protected static final String CONFIG_LOGIN_PARAM = "plugin.im.login";
    protected static final String CONFIG_PASSWORD_PARAM = "plugin.im.password";
    protected static final String CONFIG_RESOURCE_PARAM = "plugin.im.resource";
    private static final Map<String, Integer> jid2userMap = new HashMap<String, Integer>();
    private String accServ = null;
    private String accLogi = null;
    private String accPass = null;
    private String accReso = null;
    protected BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.im");
    private static final String SESSION_IM_ROSTERLISTENER_ATTR = "IM.XMPP.RosterListenerMap";

    protected boolean isAccountInputed() {
        this.accPass = null;
        this.accLogi = null;
        this.accServ = null;
        String lo = this.getUserConfig().get(CONFIG_LOGIN_PARAM, null);
        this.accPass = this.getUserConfig().get(CONFIG_PASSWORD_PARAM, null);
        if (lo == null || this.accPass == null) {
            return false;
        }
        int pi = lo.indexOf("@");
        if (pi == -1) {
            return false;
        }
        this.accServ = lo.substring(pi + 1);
        this.accLogi = lo.substring(0, pi);
        this.accReso = this.getUserConfig().get(CONFIG_RESOURCE_PARAM, "BGBilling");
        return true;
    }

    protected XMPPConnection getXMPPConnection() {
        HashMap userConnections = (HashMap)this.setup.getObject(SESSION_IM_CONNECTION_ATTR);
        if (userConnections == null) {
            userConnections = new HashMap();
            this.setup.putObject(SESSION_IM_CONNECTION_ATTR, userConnections);
        }
        XMPPConnection connection = (XMPPConnection)userConnections.get(this.userId);
        return connection;
    }

    private void _waitLoadRoster(XMPPConnection connection) {
        Roster roster = connection.getRoster();
        String me = connection.getUser();
        while (roster.getPresenceResource(me).getType() == Presence.Type.unavailable) {
        }
    }

    private void sendStatus(XMPPConnection connection, IMConstants.STATUS status) {
        Presence pres = connection.getRoster().getPresenceResource(connection.getUser());
        switch (status) {
            case ONLINE: {
                pres.setType(Presence.Type.available);
                pres.setMode(null);
                break;
            }
            case AWAY: {
                pres.setType(Presence.Type.available);
                pres.setMode(Presence.Mode.away);
                break;
            }
            case DND: {
                pres.setType(Presence.Type.available);
                pres.setMode(Presence.Mode.dnd);
            }
        }
        connection.sendPacket((Packet)pres);
    }

    protected void connect(IMConstants.STATUS status) throws Exception {
        XMPPConnection connection;
        HashMap<Integer, XMPPConnection> userConnections = (HashMap<Integer, XMPPConnection>)this.setup.getObject(SESSION_IM_CONNECTION_ATTR);
        if (userConnections == null) {
            userConnections = new HashMap<Integer, XMPPConnection>();
            this.setup.putObject(SESSION_IM_CONNECTION_ATTR, userConnections);
        }
        if ((connection = (XMPPConnection)userConnections.get(this.userId)) == null) {
            if (status == IMConstants.STATUS.OFFLINE) {
                return;
            }
            if (!this.isAccountInputed()) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d IM-\u0430\u043a\u043a\u0430\u0443\u043d\u0442: \u043b\u043e\u0433\u0438\u043d, \u043f\u0430\u0440\u043e\u043b\u044c");
            }
            try {
                connection = new XMPPConnection(this.accServ);
                connection.connect();
                connection.login(this.accLogi, this.accPass, this.accReso);
            }
            catch (Exception e) {
                if (connection != null) {
                    connection.disconnect();
                }
                throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u0430: " + e.getMessage());
            }
            userConnections.put(this.userId, connection);
            jid2userMap.put(this.accLogi + "@" + this.accServ, this.userId);
            connection.getChatManager().addChatListener(new ChatManagerListener(){

                public void chatCreated(Chat chat, boolean createdLocally) {
                    chat.addMessageListener(new MessageListener(){

                        public void processMessage(Chat chat, Message message) {
                            ActionBase.this.putMessage(message, true);
                        }
                    });
                }
            });
            this._waitLoadRoster(connection);
            this.sendStatus(connection, status);
            connection.getRoster().addRosterListener(new RosterListener(){

                public void entriesAdded(Collection<String> addresses) {
                    List<RosterListenerItem> rosterListenerItemList = ActionBase.this.getRosterListenerItemList();
                    for (String entrie : addresses) {
                        log.debug("RosterListener::entriesAdded:" + entrie);
                        rosterListenerItemList.add(new RosterListenerItem(IMConstants.RosterListenerMode.CHANGE, entrie));
                    }
                }

                public void entriesDeleted(Collection<String> addresses) {
                    List<RosterListenerItem> rosterListenerItemList = ActionBase.this.getRosterListenerItemList();
                    for (String entrie : addresses) {
                        log.debug("RosterListener::entriesDeleted:" + entrie);
                        rosterListenerItemList.add(new RosterListenerItem(IMConstants.RosterListenerMode.DELETE, entrie));
                    }
                }

                public void entriesUpdated(Collection<String> addresses) {
                    List<RosterListenerItem> rosterListenerItemList = ActionBase.this.getRosterListenerItemList();
                    for (String entrie : addresses) {
                        log.debug("RosterListener::entriesUpdated:" + entrie);
                        rosterListenerItemList.add(new RosterListenerItem(IMConstants.RosterListenerMode.CHANGE, entrie));
                    }
                }

                public void presenceChanged(Presence presence) {
                    log.debug("RosterListener::presenceChanged:" + presence.getFrom());
                    List<RosterListenerItem> rosterListenerItemList = ActionBase.this.getRosterListenerItemList();
                    rosterListenerItemList.add(new RosterListenerItem(IMConstants.RosterListenerMode.CHANGE, IMUtils.getPureJID((String)presence.getFrom())));
                }
            });
        } else if (status == IMConstants.STATUS.OFFLINE) {
            connection.disconnect();
            userConnections.put(this.userId, null);
        } else {
            this.sendStatus(connection, status);
        }
    }

    protected void putMessage(Message message, boolean incoming) {
        long sentTime = 0L;
        String messageBody = message.getBody();
        DelayInformation inf = (DelayInformation)message.getExtension("x", "jabber:x:delay");
        if (inf != null) {
            sentTime = inf.getStamp().getTime();
            messageBody = "(Offline) " + messageBody;
        } else {
            sentTime = System.currentTimeMillis();
        }
        this.putMessage(message.getFrom(), message.getTo(), messageBody, incoming, sentTime);
    }

    protected void putMessage(String from, String to, String messageBody, boolean incoming, long sentTime) {
        Connection con1 = this.setup.getDBConnectionFromPool();
        if (incoming) {
            log.debug("putMessage(in):" + to + "<=" + from + ":" + messageBody);
        } else {
            log.debug("putMessage(out):" + from + "=>" + to + ":" + messageBody);
        }
        MessageManager messageManager = new MessageManager(con1, this.plugin);
        IMMessage message = new IMMessage();
        message.setTime(sentTime);
        message.setFrom(IMUtils.getPureJID((String)from));
        message.setTo(IMUtils.getPureJID((String)to));
        message.setText(messageBody);
        message.setUserId(this.userId.intValue());
        message.setIncoming(incoming);
        messageManager.addMessage(message);
        ServerUtils.closeConnection((Connection)con1);
        Integer uid = null;
        uid = incoming ? jid2userMap.get(message.getTo()) : jid2userMap.get(message.getFrom());
        IMMessageList imMessageList = this.getUserMessageList(uid);
        message.setFrom(from);
        message.setTo(to);
        imMessageList.addMessage(message);
    }

    protected IMMessageList getUserMessageList(Integer uId) {
        IMMessageList messages;
        HashMap<Integer, IMMessageList> userMessages = (HashMap<Integer, IMMessageList>)this.setup.getObject(SESSION_IM_USERMESSAGELIST_ATTR);
        if (userMessages == null) {
            userMessages = new HashMap<Integer, IMMessageList>();
            this.setup.putObject(SESSION_IM_USERMESSAGELIST_ATTR, userMessages);
        }
        if ((messages = (IMMessageList)userMessages.get(uId)) == null) {
            messages = new IMMessageList();
            userMessages.put(uId, messages);
        }
        return messages;
    }

    protected int makeEntryXml(RosterEntry entry, Element elgroup, Roster roster) {
        int availableContactCount = 0;
        Iterator presences = roster.getPresences(entry.getUser());
        while (presences.hasNext()) {
            Presence presence = (Presence)presences.next();
            Element elentry = this.createElement(elgroup, "entry");
            if (entry.getName() != null) {
                elentry.setAttribute("name", entry.getName());
            }
            elentry.setAttribute("subscr", String.valueOf(entry.getType()) + (String)(entry.getStatus() != null ? "," + String.valueOf(entry.getStatus()) : ""));
            this.makePresenceXml(presence, elentry);
            if (!presence.isAvailable()) continue;
            ++availableContactCount;
        }
        return availableContactCount;
    }

    protected void makePresenceXml(Presence presence, Element elentry) {
        elentry.setAttribute("from", presence.getFrom());
        if (presence.isAvailable()) {
            elentry.setAttribute("priority", String.valueOf(presence.getPriority()));
        }
        if (presence.getStatus() != null) {
            elentry.setAttribute("statusmessage", presence.getStatus());
        }
        IMConstants.STATUS status = null;
        if (!presence.isAvailable()) {
            status = IMConstants.STATUS.OFFLINE;
        } else if (!presence.isAway()) {
            status = IMConstants.STATUS.ONLINE;
        } else {
            status = IMConstants.STATUS.AWAY;
            if (presence.getMode() != null && presence.getMode() == Presence.Mode.dnd) {
                status = IMConstants.STATUS.DND;
            }
        }
        elentry.setAttribute("status", status.toString());
    }

    protected List<RosterListenerItem> getRosterListenerItemList() {
        ArrayList rosterListenerItemList;
        HashMap userRosterListenerItemMap = (HashMap)this.setup.getObject(SESSION_IM_ROSTERLISTENER_ATTR);
        if (userRosterListenerItemMap == null) {
            userRosterListenerItemMap = new HashMap();
            this.setup.putObject(SESSION_IM_ROSTERLISTENER_ATTR, userRosterListenerItemMap);
        }
        if ((rosterListenerItemList = (ArrayList)userRosterListenerItemMap.get(this.userId)) == null) {
            rosterListenerItemList = new ArrayList();
            userRosterListenerItemMap.put(this.userId, rosterListenerItemList);
        }
        return rosterListenerItemList;
    }

    protected void processCheckStatus(XMPPConnection connection) {
        IMMessageList messageList = this.getUserMessageList(this.userId).cloneListAndClear();
        if (messageList.getList().size() > 0) {
            Element elementMessageList = this.createElement(this.rootNode, "messageList");
            messageList.setXml(elementMessageList);
        }
        List<RosterListenerItem> rosterListenerItemListOrig = this.getRosterListenerItemList();
        ArrayList<RosterListenerItem> rosterListenerItemListCopy = new ArrayList<RosterListenerItem>();
        rosterListenerItemListCopy.addAll(rosterListenerItemListOrig);
        rosterListenerItemListOrig.clear();
        ArrayList<RosterListenerItem> rlnew = new ArrayList<RosterListenerItem>();
        for (RosterListenerItem item : rosterListenerItemListCopy) {
            int io = rlnew.indexOf(item);
            if (io == -1) {
                rlnew.add(item);
                continue;
            }
            RosterListenerItem oo = (RosterListenerItem)rlnew.get(io);
            if (oo.getMode() == IMConstants.RosterListenerMode.DELETE && item.getMode() == IMConstants.RosterListenerMode.CHANGE) {
                oo.setMode(IMConstants.RosterListenerMode.CHANGE);
            }
            if (oo.getMode() != IMConstants.RosterListenerMode.CHANGE || item.getMode() != IMConstants.RosterListenerMode.DELETE) continue;
            oo.setMode(IMConstants.RosterListenerMode.DELETE);
        }
        for (RosterListenerItem item : rlnew) {
            Element elRosterChanges = this.createElement(this.rootNode, "rosterChanges");
            elRosterChanges.setAttribute("mode", item.getMode().toString());
            elRosterChanges.setAttribute("user", item.getJid());
            if (item.getMode() != IMConstants.RosterListenerMode.CHANGE) continue;
            Roster roster = connection.getRoster();
            RosterEntry entry = roster.getEntry(item.getJid());
            this.makeEntryXml(entry, elRosterChanges, roster);
        }
    }

    protected class RosterListenerItem {
        private IMConstants.RosterListenerMode mode;
        private String jid;

        public RosterListenerItem(IMConstants.RosterListenerMode mode, String jid) {
            this.mode = mode;
            this.jid = jid;
        }

        public IMConstants.RosterListenerMode getMode() {
            return this.mode;
        }

        public void setMode(IMConstants.RosterListenerMode mode) {
            this.mode = mode;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public boolean equals(Object obj) {
            return this.jid.equals(((RosterListenerItem)obj).getJid());
        }

        public String toString() {
            return super.toString() + "@" + this.jid + "@" + this.mode;
        }
    }
}

