/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.im.common.IMMessage;
import ru.bitel.bgbilling.plugins.im.common.IMMessageList;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Page;

public class MessageManager {
    protected Connection con;

    public MessageManager(Connection con, BGPluginServer plugin) {
        this.con = con;
    }

    public IMMessageList getMessageList(int userId, String jidfrom, String jidto, Long datefrom, Long dateto, Page page) {
        IMMessageList result = new IMMessageList();
        try {
            int index = 1;
            Object query = "SELECT message.* FROM im_message AS message WHERE user_id=? AND ((message.to=? AND message.from=? AND message.incoming=1) OR (message.from=? AND message.to=? AND message.incoming=0))";
            if (datefrom != null) {
                query = (String)query + " AND message.`time`>=?";
            }
            if (dateto != null) {
                query = (String)query + " AND message.`time`<=?";
            }
            query = (String)query + " ORDER BY message.`time` DESC LIMIT ";
            query = (String)query + page.getPageFirstRecordNumber();
            query = (String)query + ", ";
            query = (String)query + page.getPageSize();
            PreparedStatement ps = this.con.prepareStatement(((String)query).toString());
            ps.setInt(index++, userId);
            ps.setString(index++, jidto);
            ps.setString(index++, jidfrom);
            ps.setString(index++, jidto);
            ps.setString(index++, jidfrom);
            if (datefrom != null) {
                ps.setLong(index++, datefrom);
            }
            if (dateto != null) {
                ps.setLong(index++, dateto);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                IMMessage message = new IMMessage();
                this.loadMessageFromRS(message, rs, "message.");
                result.getList().add(message);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public int getMessageCount(int userId, String jidfrom, String jidto, Long datefrom, Long dateto) {
        int result = -1;
        try {
            ResultSet rs;
            int index = 1;
            Object query = "SELECT count(*) FROM im_message AS message WHERE user_id=? AND ((message.to=? AND message.from=? AND message.incoming=1) OR (message.from=? AND message.to=? AND message.incoming=0))";
            if (datefrom != null) {
                query = (String)query + " AND message.`time`>=?";
            }
            if (dateto != null) {
                query = (String)query + " AND message.`time`<=?";
            }
            PreparedStatement ps = this.con.prepareStatement(((String)query).toString());
            ps.setInt(index++, userId);
            ps.setString(index++, jidto);
            ps.setString(index++, jidfrom);
            ps.setString(index++, jidto);
            ps.setString(index++, jidfrom);
            if (datefrom != null) {
                ps.setLong(index++, datefrom);
            }
            if (dateto != null) {
                ps.setLong(index++, dateto);
            }
            if ((rs = ps.executeQuery()).next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void loadMessageFromRS(IMMessage message, ResultSet rs, String tableMessage) throws SQLException {
        message.setId(rs.getInt(tableMessage + "id"));
        message.setUserId(rs.getInt(tableMessage + "user_id"));
        message.setTime(rs.getLong(tableMessage + "time"));
        message.setFrom(rs.getString(tableMessage + "from"));
        message.setTo(rs.getString(tableMessage + "to"));
        message.setText(rs.getString(tableMessage + "text"));
        message.setIncoming(rs.getBoolean(tableMessage + "incoming"));
    }

    public void addMessage(IMMessage message) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO im_message SET `time`=?, `from`=?, `to`=?, `text`=?, `user_id`=?, `incoming`=?";
            ps = this.con.prepareStatement(query, 1);
            ps.setLong(1, message.getTime());
            ps.setString(2, message.getFrom());
            ps.setString(3, message.getTo());
            ps.setString(4, message.getText());
            ps.setInt(5, message.getUserId());
            ps.setBoolean(6, message.isIncoming());
            ps.executeUpdate();
            message.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

