/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import java.awt.Color;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SQLTextPane
extends JTextPane {
    StyledDocument doc;

    public SQLTextPane() {
        this.setContentType("text/plain");
        this.setDocument(new SQLStyledDoc());
        this.setMargin(new Insets(3, 3, 3, 3));
    }

    public void append(String str) {
        this.setText(super.getText() + str);
    }

    @Override
    public String getText() {
        return super.getText().replaceAll("\r", "");
    }

    public static class SQLStyledDoc
    extends DefaultStyledDocument {
        public SQLStyledDoc() {
            Style style = this.addStyle("comment", null);
            StyleConstants.setForeground(style, new Color(168, 168, 168));
            StyleConstants.setItalic(style, true);
            StyleConstants.setBold(style, true);
            style = this.addStyle("attr", style);
            StyleConstants.setForeground(style, Color.blue);
            StyleConstants.setBold(style, true);
            style = this.addStyle("normal", null);
            StyleConstants.setForeground(style, Color.black);
            style = this.addStyle("varValue", null);
            StyleConstants.setForeground(style, new Color(32768));
            StyleConstants.setBold(style, true);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offset, str, a);
            this.updateView(offset, str.length());
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            this.updateView(offs, 0);
        }

        private void updateView(int offset, int len) {
            try {
                int textLength = this.getLength();
                String text = this.getText(0, textLength);
                int end = offset + len;
                if (offset > 0) {
                    --offset;
                }
                while (offset > 0 && text.charAt(offset) != '\n') {
                    --offset;
                }
                if (offset > 0) {
                    ++offset;
                }
                while (end < textLength && text.charAt(end) != '\n') {
                    ++end;
                }
                text = text.substring(offset, end);
                int pos = 0;
                StringTokenizer st = new StringTokenizer(text, "\n", true);
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    this.setCharacterAttributes(offset + pos, line.length(), this.getStyle("normal"), true);
                    if (line.startsWith("#")) {
                        this.setCharacterAttributes(offset + pos, line.length(), this.getStyle("comment"), true);
                    } else {
                        this.setCharacterAttributes(offset + pos, line.length(), this.getStyle("attr"), true);
                    }
                    pos += line.length();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

