/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.task;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.logging.BGNestedContext;

public class DBAAddTask
extends TaskBase {
    private static final Logger logger = LogManager.getLogger();

    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        BGNestedContext.push((String)"dba");
        try (Connection con = this.setup.getDBConnectionFromPool();){
            HashMap<String, Integer> autoValue = new HashMap<String, Integer>();
            JSONArray autoConfig = new JSONArray(ServerUtils.getSetupValue((Connection)con, (String)("dba.auto.archive.config." + this.moduleId), (String)"[]"));
            int len = autoConfig.length();
            for (int index = 0; index < len; ++index) {
                JSONObject json = autoConfig.getJSONObject(index);
                autoValue.put(json.getString("tableNameMask"), json.getInt("autoValue"));
                if (!logger.isDebugEnabled()) continue;
                logger.debug("tableNameMask={}; autoValue={}", (Object)json.getString("tableNameMask"), (Object)json.getInt("autoValue"));
            }
            LocalDate now = LocalDate.now();
            int month = 12 * now.getYear() + now.getMonthValue();
            if (logger.isDebugEnabled()) {
                logger.debug("now={}; month={}", (Object)now, (Object)month);
            }
            DateTimeFormatter dateTimeFormatter = TimeUtils.getDateTimeFormatter((String)"yyyyMMdd");
            String queryInsert = "INSERT INTO dba_table_task_" + this.moduleId + " SET table_name=?";
            try (Statement st = con.createStatement();
                 ResultSet rs = st.executeQuery("SHOW TABLES");
                 PreparedStatement psInsert = con.prepareStatement(queryInsert);){
                while (rs.next()) {
                    LocalDate date;
                    int monthDelta;
                    String name;
                    String tableName = rs.getString(1);
                    if (logger.isDebugEnabled()) {
                        logger.debug("tableName={}", (Object)tableName);
                    }
                    if (tableName.matches(".*_\\d{6}$")) {
                        name = tableName.substring(0, tableName.length() - 7);
                        monthDelta = autoValue.getOrDefault(name, 0);
                        if (logger.isDebugEnabled()) {
                            logger.debug("name={}; monthDelta={}", (Object)name, (Object)monthDelta);
                        }
                        if (monthDelta == 0) continue;
                        String yyyymm = tableName.substring(tableName.length() - 6);
                        date = LocalDate.parse(yyyymm + "01", dateTimeFormatter);
                        if (logger.isDebugEnabled()) {
                            logger.debug("yyyymm={}; date={}", (Object)yyyymm, (Object)date);
                        }
                        if (month - 12 * date.getYear() - date.getMonthValue() < monthDelta) continue;
                        logger.debug("Add table={}", (Object)tableName);
                        psInsert.setString(1, tableName);
                        psInsert.executeUpdate();
                        continue;
                    }
                    if (!tableName.matches(".*_\\d{8}$")) continue;
                    name = tableName.substring(0, tableName.length() - 9);
                    monthDelta = autoValue.getOrDefault(name, 0);
                    if (logger.isDebugEnabled()) {
                        logger.debug("name={}; monthDelta={}", (Object)name, (Object)monthDelta);
                    }
                    if (monthDelta == 0) continue;
                    String yyyymmdd = tableName.substring(tableName.length() - 8);
                    date = LocalDate.parse(yyyymmdd, dateTimeFormatter);
                    if (logger.isDebugEnabled()) {
                        logger.debug("yyyymmdd={}; date={}", (Object)yyyymmdd, (Object)date);
                    }
                    if (month - 12 * date.getYear() - date.getMonthValue() < monthDelta) continue;
                    logger.debug("Add table={}", (Object)tableName);
                    psInsert.setString(1, tableName);
                    psInsert.executeUpdate();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            BGNestedContext.pop();
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c DBA. \u0417\u0430\u0434\u0430\u0447\u0430 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u043d\u0438\u0439 \u043d\u0430 \u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0442\u0430\u0431\u043b\u0438\u0446. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }
}

