/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionGetAllModuleActions
extends ActionBase {
    private static Element actionslElement;
    private static Date lastLoadedTime;

    @Override
    public void doAction() throws BGException {
        if (this.resentlyWasLoaded() && actionslElement != null) {
            this.rootNode.appendChild(this.rootNode.getOwnerDocument().importNode(actionslElement, true));
            return;
        }
        lastLoadedTime = new Date();
        try {
            this.fillXml("kernel", "0", "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
            for (BGModule bGModule : ModuleCache.getInstance().getModulesList()) {
                this.fillXml(bGModule.getName(), String.valueOf(bGModule.getId()), bGModule.getTitle());
            }
            for (Map.Entry entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
                this.fillXml((String)entry.getKey(), "p" + ((BGPluginServer)entry.getValue()).getPluginUID(), ((BGPluginServer)entry.getValue()).getName());
            }
        }
        catch (IOException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean resentlyWasLoaded() {
        if (lastLoadedTime == null) {
            return false;
        }
        long diff = new Date().getTime() - lastLoadedTime.getTime();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(diff);
        return seconds <= 60L;
    }

    private void fillXml(String name, String moduleId, String title) throws IOException {
        File file = new File("actions/" + name + ".xml");
        if (file.exists() && file.canRead()) {
            Element rootElement;
            Document document;
            InputStreamReader reader;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                reader = new InputStreamReader(fileInputStream);
                try {
                    document = XMLUtils.parseDocument((InputSource)new InputSource(reader));
                    rootElement = XMLUtils.selectElement((Node)document, (String)"//actions");
                    rootElement.setAttribute("id", moduleId);
                    rootElement.setAttribute("title", title);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            file = new File("actions/" + name + ".custom.xml");
            if (file.exists() && file.canRead()) {
                fileInputStream = new FileInputStream(file);
                try {
                    reader = new InputStreamReader(fileInputStream);
                    try {
                        document = XMLUtils.parseDocument((InputSource)new InputSource(reader));
                        Element element = XMLUtils.selectElement((Node)document, (String)"//actions");
                        this.importCustom(element, rootElement);
                    }
                    finally {
                        ((Reader)reader).close();
                    }
                }
                finally {
                    fileInputStream.close();
                }
            }
            this.rootNode.appendChild(this.rootNode.getOwnerDocument().importNode(rootElement, true));
            actionslElement = this.rootNode;
        }
    }

    private void importCustom(Element fromElement, Element toElement) {
        Element el;
        String id;
        Element customGroupElement = XMLUtils.selectElement((Node)toElement, (String)"group[@title=\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435]");
        if (customGroupElement == null) {
            customGroupElement = toElement.getOwnerDocument().createElement("group");
            customGroupElement.setAttribute("title", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435");
            toElement.appendChild(customGroupElement);
        }
        for (Element element : XMLUtils.selectElements((Node)fromElement, (String)"//service")) {
            id = element.getAttribute("id");
            if (!Utils.notBlankString((String)id)) continue;
            el = XMLUtils.selectElement((Node)toElement, (String)("//service[@id=" + id + "]"));
            if (el == null) {
                el = toElement.getOwnerDocument().createElement("service");
                el.setAttribute("id", id);
                customGroupElement.appendChild(el);
            }
            el.setAttribute("name", element.getAttribute("name"));
            el.setAttribute("operation", element.getAttribute("operation"));
            el.setAttribute("title", element.getAttribute("title"));
        }
        for (Element element : XMLUtils.selectElements((Node)fromElement, (String)"//action")) {
            id = element.getAttribute("id");
            if (!Utils.notBlankString((String)id)) continue;
            el = XMLUtils.selectElement((Node)toElement, (String)("//action[@id=" + id + "]"));
            if (el == null) {
                el = toElement.getOwnerDocument().createElement("action");
                el.setAttribute("id", id);
                customGroupElement.appendChild(el);
            }
            el.setAttribute("mask", element.getAttribute("mask"));
            el.setAttribute("title", element.getAttribute("title"));
        }
    }

    static {
        lastLoadedTime = null;
    }
}

