/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.MailMsg;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailContractCard2;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionContractCard2
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Object contract\u0421ardKey = this.getParameter("type", "");
        contract\u0421ardKey = ((String)contract\u0421ardKey).isEmpty() ? "" : "." + (String)contract\u0421ardKey;
        String file = this.setup.get("contractcard" + (String)contract\u0421ardKey).split(":")[0];
        Path xslPath = Paths.get("webroot", "xsl", file);
        if (!Files.exists(xslPath, new LinkOption[0])) {
            throw new BGMessageException("\u0424\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + xslPath.toString());
        }
        if (this.cid < 0 || Utils.isBlankString((String)file)) {
            throw new BGIllegalArgumentException();
        }
        String contentType = this.getParameter("contentType");
        try {
            Document doc = XMLUtils.newDocument();
            Element card = doc.createElement("card");
            Element user = this.createElement(card, "user");
            user.setAttribute("id", String.valueOf(this.userId));
            try {
                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                XMLStreamWriter xmlStreamWriter = factory.createXMLStreamWriter(new DOMResult(card));
                boolean withParams = this.setup.getBoolean("contractcard" + (String)contract\u0421ardKey + ".withParams", true);
                boolean addSub = this.setup.getBoolean("contractcard" + (String)contract\u0421ardKey + ".addSub", false);
                boolean addSuper = this.setup.getBoolean("contractcard" + (String)contract\u0421ardKey + ".addSuper", false);
                Set xmlContractConsist = Utils.toIntegerSet((String)this.setup.get("contractcard" + (String)contract\u0421ardKey + ".xmlContractConsist", null));
                Set xmlModulesConsist = Utils.toIntegerSet((String)this.setup.get("contractcard" + (String)contract\u0421ardKey + ".xmlModulesConsist", null));
                Set xmlPluginConsist = Utils.toIntegerSet((String)this.setup.get("contractcard" + (String)contract\u0421ardKey + ".xmlPluginConsist", null));
                if (this.setup.getBoolean("contractcard" + (String)contract\u0421ardKey + ".addCustomer", false)) {
                    xmlContractConsist.add(10);
                }
                new ContractUtils(this.con).addContractXML(this.cid, xmlStreamWriter, withParams, addSub, addSuper, xmlContractConsist, xmlModulesConsist, xmlPluginConsist);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            doc.appendChild(card);
            String maildest = this.getParameter("maildest");
            if (Utils.notBlankString((String)maildest)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
                XSLManager.getInstance().transform((Source)new DOMSource(doc), file, FOUtils.renderSAXResult((OutputStream)baos, (String)"application/pdf"));
                MailContractCard2 mailData = new MailContractCard2();
                mailData.setContractId(this.cid);
                mailData.setRecipients(maildest);
                mailData.setSubject("card.pdf");
                mailData.addPart("file", "attachment", "application/pdf", "card.pdf", baos.toByteArray());
                new MailMsg(this.setup).sendMessage(mailData);
            } else if (contentType != null && contentType.equals("application/pdf")) {
                XSLManager.getInstance().transform((Source)new DOMSource(doc), file, FOUtils.renderSAXResult((OutputStream)this.response.getOutputStream(), (String)"application/pdf"));
            } else {
                XSLManager.getInstance().transform((Source)new DOMSource(doc), file, this.rootNode);
            }
        }
        catch (BGException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

