/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class ActionCopyContractParameters
extends ActionBase {
    private static final String MODE_REPLACE = "replace";

    @Override
    public void doAction() throws SQLException, BGException {
        int fromContractId = Utils.parseInt((String)this.getParameter("fromContractId"), (int)-1);
        String mode = this.getParameter("mode", MODE_REPLACE);
        Set pids = Utils.toIntegerSet((String)this.getParameter("pids"));
        ContractDao contractDao = new ContractDao(this.con, 0);
        ContractParameterManager parameterManager = new ContractParameterManager(this.con);
        Map<Integer, EntityAttr> toParamMap = null;
        Map<Integer, ListParamValue> listParamMap = null;
        Map<Integer, ContractAddressParamValue> addressParamMap = null;
        Map<Integer, MultiListParamValues> multiListParamMap = null;
        if (!MODE_REPLACE.equals(mode)) {
            toParamMap = contractDao.getContractParameters(this.cid, pids);
            listParamMap = parameterManager.getListParamValueMap(this.cid, pids);
            addressParamMap = parameterManager.getAddressParamMap(this.cid, pids);
            multiListParamMap = parameterManager.getMultiListParamValueMap(this.cid, pids);
        }
        Map<Integer, EntityAttr> fromParamMap = contractDao.getContractParameters(fromContractId, pids);
        for (Map.Entry<Integer, EntityAttr> entry : fromParamMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrText) || !MODE_REPLACE.equals(mode) && toParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrText(this.cid, entry.getKey().intValue(), ((EntityAttrText)entry.getValue()).getValue()));
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getAddressParamMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && addressParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            parameterManager.updateAddressParam(this.cid, entry.getKey(), (ContractAddressParamValue)entry.getValue(), this.userId);
        }
        for (Map.Entry<Integer, Object> entry : fromParamMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrPhone) || !MODE_REPLACE.equals(mode) && toParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            EntityAttrPhone entityAttrPhone = new EntityAttrPhone(this.cid, entry.getKey().intValue());
            entityAttrPhone.setContactList(((EntityAttrPhone)entry.getValue()).getContactList());
            contractDao.updateContractParameter(this.cid, (EntityAttr)entityAttrPhone);
        }
        for (Map.Entry<Integer, Object> entry : fromParamMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrEmail) || !MODE_REPLACE.equals(mode) && toParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            EntityAttrEmail entityAttrEmail = new EntityAttrEmail(this.cid, entry.getKey().intValue());
            entityAttrEmail.setContactList(((EntityAttrEmail)entry.getValue()).getContactList());
            contractDao.updateContractParameter(this.cid, (EntityAttr)entityAttrEmail);
        }
        for (Map.Entry<Integer, Object> entry : fromParamMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrDate) || !MODE_REPLACE.equals(mode) && toParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrDate(this.cid, entry.getKey().intValue(), ((EntityAttrDate)entry.getValue()).getValue()));
        }
        for (Map.Entry<Integer, Object> entry : fromParamMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrBoolean) || !MODE_REPLACE.equals(mode) && toParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrBoolean(this.cid, entry.getKey().intValue(), ((EntityAttrBoolean)entry.getValue()).getValue()));
        }
        for (Map.Entry<Integer, Object> entry : fromParamMap.entrySet()) {
            if (!(entry.getValue() instanceof EntityAttrList) || !MODE_REPLACE.equals(mode) && toParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            EntityAttrList attrList = (EntityAttrList)entry.getValue();
            contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrList(this.cid, entry.getKey().intValue(), attrList.getValue(), attrList.getTitle()));
        }
        for (Map.Entry<Integer, Object> entry : parameterManager.getMultiListParamValueMap(fromContractId, pids).entrySet()) {
            if (!MODE_REPLACE.equals(mode) && multiListParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
            parameterManager.updateMultiListParameterAndItems(this.cid, entry.getKey(), (MultiListParamValues)entry.getValue(), this.userId);
        }
        new CommentPatternManager(this.con).updateContractComment(this.cid);
    }
}

