/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternManager;
import ru.bitel.common.Utils;

public class ActionGetPatternInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int patternId = this.getIntParameter("pid", -1);
        if (patternId < 0) {
            throw new BGIllegalArgumentException();
        }
        int onlyUsing = this.getIntParameter("onlyUsing", 0);
        Element patternEl = this.createElement(this.rootNode, "pattern");
        ContractPattern pattern = new ContractPatternManager(this.con).getPattern(patternId);
        if (this.getBooleanParameter("only_title_pattern", false)) {
            if (pattern != null) {
                patternEl.setAttribute("name_pattern", pattern.getNamePattern());
            }
            return;
        }
        if (pattern != null) {
            patternEl.setAttribute("title", pattern.getTitle());
            patternEl.setAttribute("limit", new DecimalFormat("####.##").format(pattern.getClosesumma()));
            patternEl.setAttribute("limitMode", pattern.getLimitMode());
            patternEl.setAttribute("tariff", Utils.toString(pattern.getTariffPlanList()));
            patternEl.setAttribute("groups", String.valueOf(pattern.getGroups()));
            patternEl.setAttribute("mode", String.valueOf(pattern.getMode()));
            patternEl.setAttribute("pgid", String.valueOf(pattern.getParamsGroupId()));
            patternEl.setAttribute("face", String.valueOf(pattern.getFc()));
            patternEl.setAttribute("dtl", String.valueOf(pattern.getDaysToLive()));
            patternEl.setAttribute("tariff_group", Utils.toString(pattern.getTariffGroupList()));
            patternEl.setAttribute("script", Utils.toString(pattern.getScriptList()));
            patternEl.setAttribute("name_pattern", pattern.getNamePattern());
            patternEl.setAttribute("title_pattern_id", String.valueOf(pattern.getPatternId()));
            patternEl.setAttribute("status", String.valueOf(pattern.getStatus()));
            patternEl.setAttribute("domainId", String.valueOf(pattern.getDomainId()));
            this.treeServices(this.mid, onlyUsing);
            if (pattern.getData() != null) {
                patternEl.appendChild(patternEl.getOwnerDocument().importNode(pattern.getData().getDocumentElement(), true));
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT service.mid, service.id FROM contract_pattern_services AS ps INNER JOIN service ON service.id = ps.sid WHERE ps.pid=" + pattern.getId());
            while (rs.next()) {
                Element services = this.createElement(patternEl, "services");
                services.setAttribute("mid", String.valueOf(rs.getInt(1)));
                Element addServices = this.createElement(services, "addServices");
                Element item = this.createElement(addServices, "item");
                item.setAttribute("sid", String.valueOf(rs.getInt(2)));
            }
        }
    }
}

