/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.admin.bean.ContractParameterGroupManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.PhoneUtils;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class ActionContractParameter
extends AbstractAction {
    private static final String PARAM_HIDDEN_VALUE = "< \u0421\u041a\u0420\u042b\u0422\u041e >";
    private int parameterId = 0;
    private Contract contract = null;
    private ContractParameterPrefDao prefDao = null;
    private ContractParameterManager contractParameterManager = null;

    public ActionContractParameter() {
        super("contract");
    }

    @Override
    public void execute() throws BGException {
        this.a();
        if (this.contract != null) {
            Set<Integer> ids = null;
            if (this.contract.getParamGroup() > 0) {
                ids = new ContractParameterGroupManager(this.con).getParameterSetInGroup(this.contract.getParamGroup());
            }
            List<ContractParameterPref> groupList = this.prefDao.getContractParameterPrefList(ids);
            ArrayList<ContractParameterPref> showList = new ArrayList<ContractParameterPref>();
            HashSet<Integer> paramIds = new HashSet<Integer>();
            for (ContractParameterPref contractParameterPref : groupList) {
                if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
                showList.add(contractParameterPref);
                paramIds.add(contractParameterPref.getId());
            }
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                HashMap<Integer, String> paramValue = this.contractParameterManager.getValuesForPids(paramIds, this.contractId);
                Map<Integer, EntityAttr> entityAttrMap = contractDao.getContractParameters(this.contractId, paramIds);
                for (Map.Entry<Integer, EntityAttr> entry : entityAttrMap.entrySet()) {
                    if (!(entry.getValue() instanceof EntityAttrEmail)) continue;
                    String emails = ((EntityAttrEmail)entry.getValue()).toString().trim();
                    emails = emails.replaceAll("\n", "; ");
                    emails = emails.replaceAll("<", "&lt;");
                    emails = emails.replaceAll(">", "&gt;");
                    paramValue.put(entry.getKey(), emails);
                }
                for (Map.Entry<Integer, EntityAttr> entry : entityAttrMap.entrySet()) {
                    Boolean flagParamValue;
                    if (!(entry.getValue() instanceof EntityAttrBoolean) || (flagParamValue = Boolean.valueOf(((EntityAttrBoolean)entry.getValue()).getValue())) == null) continue;
                    paramValue.put(entry.getKey(), flagParamValue != false ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
                }
                this.setResultParam("paramList", showList);
                this.setResultParam("paramValue", paramValue);
            }
        }
    }

    public void getParameterType3() throws BGException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null) {
            ArrayList<String[]> emails = new ArrayList<String[]>();
            try (ContractDao contractDao = new ContractDao(this.con, -1);){
                Optional<EntityAttrEmail> attrEmail = contractDao.getContractParameterEmail(this.contract.getId(), this.parameterId);
                if (attrEmail.isPresent()) {
                    for (EntityAttrEmail.EmailContact emailContact : attrEmail.get().getContactList()) {
                        if (emailContact.getAddress().trim().isEmpty()) continue;
                        String[] emailData = new String[]{emailContact.getAddress(), emailContact.getName().trim()};
                        if (!contractParameterPref.isRead()) {
                            emailData[0] = Utils.maskEmail((String)emailData[0]);
                            emailData[1] = PARAM_HIDDEN_VALUE;
                        }
                        emails.add(emailData);
                    }
                }
            }
            this.setResultParam("paramValue", emails);
            this.setResultParam("paramTitle", contractParameterPref.getTitle());
            this.setResultParam("paramRead", contractParameterPref.isRead());
            this.setResultParam("paramWrite", contractParameterPref.isWrite());
        }
    }

    public void updateParameterType3() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null && contractParameterPref.isWrite()) {
            ArrayList<String[]> updateEmails = new ArrayList<String[]>();
            String parameterValue = this.req.get("parameterValue");
            if (parameterValue != null) {
                for (String splits : parameterValue.split("\n")) {
                    updateEmails.add(splits.split("\t"));
                }
            }
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                EntityAttrEmail attrEmail = contractDao.getContractParameterEmail(this.contract.getId(), this.parameterId).orElse(new EntityAttrEmail(this.contract.getId(), this.parameterId));
                ArrayList<EntityAttrEmail.EmailContact> resultContacts = new ArrayList<EntityAttrEmail.EmailContact>();
                for (String[] emailData : updateEmails) {
                    if (emailData.length != 3) continue;
                    if ("-1".equals(emailData[0])) {
                        resultContacts.add(new EntityAttrEmail.EmailContact(emailData[1], emailData[2]));
                        continue;
                    }
                    int index = Utils.parseInt((String)emailData[0], (int)-1);
                    if (index < 0 && index >= attrEmail.getContactList().size()) continue;
                    EntityAttrEmail.EmailContact contact = (EntityAttrEmail.EmailContact)attrEmail.getContactList().get(index);
                    if (!contractParameterPref.isRead()) {
                        if (emailData[1].indexOf(42) > -1) {
                            emailData[1] = contact.getAddress();
                        }
                        if (PARAM_HIDDEN_VALUE.equals(emailData[2])) {
                            emailData[2] = contact.getName();
                        }
                    }
                    resultContacts.add(new EntityAttrEmail.EmailContact(emailData[1], emailData[2]));
                }
                attrEmail.setContactList(resultContacts);
                if (resultContacts.isEmpty()) {
                    contractDao.deleteContractParameter(this.contract.getId(), this.parameterId);
                    this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, null));
                } else {
                    contractDao.updateContractParameter(this.contract.getId(), (EntityAttr)attrEmail);
                    this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, attrEmail));
                }
                this.setResultParam("paramId", this.parameterId);
                this.setResultParam("paramType", contractParameterPref.getType().getId());
                this.setResultParam("paramValue", contractParameterPref.isRead() ? attrEmail.toString().replace("<", "&lt;").replace(">", "&gt;") : "");
            }
        }
    }

    public void getParameterType9() throws BGException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null) {
            this.setResultParam("paramTitle", contractParameterPref.getTitle());
            this.setResultParam("paramRead", contractParameterPref.isRead());
            this.setResultParam("paramWrite", contractParameterPref.isWrite());
            this.setResultParam("prefixs", this.setup.get("phones.formats", ""));
            ArrayList phones = new ArrayList();
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                Optional<EntityAttrPhone> attrPhone = contractDao.getContractParameterPhone(this.contract.getId(), this.parameterId);
                if (attrPhone.isPresent()) {
                    String formats = this.setup.get("phones.formats");
                    attrPhone.get().getContactList().forEach(a -> {
                        String[] phoneData = new String[2];
                        phoneData[0] = PhoneUtils.phoneToFormat((String)formats, (String)a.getPhoneUnformatted());
                        if (contractParameterPref.isRead()) {
                            phoneData[1] = a.getComment();
                        } else {
                            phoneData[0] = Utils.maskPhoneNumber((String)phoneData[0], (int)4, (int)2);
                            phoneData[1] = PARAM_HIDDEN_VALUE;
                        }
                        phones.add(phoneData);
                    });
                }
            }
            this.setResultParam("paramValue", phones);
        }
    }

    public void updateParameterType9() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null && contractParameterPref.isWrite()) {
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                ArrayList<String[]> updatePhones = new ArrayList<String[]>();
                String parameterValue = this.req.get("parameterValue");
                if (parameterValue != null) {
                    for (String splits : parameterValue.split("\n")) {
                        updatePhones.add(splits.split("\t"));
                    }
                }
                Optional<EntityAttrPhone> attrPhone = contractDao.getContractParameterPhone(this.contract.getId(), this.parameterId);
                List currentPhones = attrPhone.map(EntityAttrPhone::getContactList).orElse(new ArrayList());
                int phoneNumberLength = this.setup.getInt("phones.customLengthNumber", 11);
                ArrayList<EntityAttrPhone.PhoneContact> resultPhones = new ArrayList<EntityAttrPhone.PhoneContact>();
                block6: for (String[] phoneData : updatePhones) {
                    if (phoneData.length != 3) continue;
                    if ("-1".equals(phoneData[0])) {
                        String phoneNumber = phoneData[1].replaceAll("[^\\d]", "");
                        if (phoneNumber.length() != phoneNumberLength) continue;
                        resultPhones.add(new EntityAttrPhone.PhoneContact(phoneNumber, phoneData[2]));
                        continue;
                    }
                    for (int index = 0; index < currentPhones.size(); ++index) {
                        if (Utils.parseInt((String)phoneData[0], (int)-1) != index) continue;
                        String phoneNumber = phoneData[1].replaceAll("[^\\d]", "");
                        EntityAttrPhone.PhoneContact phoneContact = (EntityAttrPhone.PhoneContact)currentPhones.get(index);
                        if ((!contractParameterPref.isRead() && phoneData[1].indexOf(42) == -1 || contractParameterPref.isRead()) && phoneNumber.length() == phoneNumberLength) {
                            phoneContact.setPhone(phoneNumber);
                        }
                        if (!contractParameterPref.isRead() && !PARAM_HIDDEN_VALUE.equals(phoneData[2]) || contractParameterPref.isRead()) {
                            phoneContact.setComment(phoneData[2]);
                        }
                        resultPhones.add(phoneContact);
                        continue block6;
                    }
                }
                EntityAttrPhone phone = new EntityAttrPhone(this.contractId, this.parameterId);
                phone.setContactList(resultPhones);
                if (resultPhones.size() == 0) {
                    contractDao.deleteContractParameter(this.contract.getId(), this.parameterId);
                    this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, null));
                } else {
                    contractDao.updateContractParameter(this.contract.getId(), (EntityAttr)phone);
                    this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, phone));
                }
                this.setResultParam("paramId", this.parameterId);
                this.setResultParam("paramType", contractParameterPref.getType().getId());
                this.setResultParam("paramValue", contractParameterPref.isRead() ? phone.toString() : PARAM_HIDDEN_VALUE);
            }
        }
    }

    public void getParameterType11() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null) {
            this.setResultParam("paramTitle", contractParameterPref.getTitle());
            this.setResultParam("paramRead", contractParameterPref.isRead());
            this.setResultParam("paramWrite", contractParameterPref.isWrite());
            MultiListParamValues multiListParamValue = this.contractParameterManager.getMultiListParamValues(this.contract.getId(), this.parameterId);
            String paramValue = multiListParamValue.getIdValue();
            if (!Utils.isEmptyString((String)paramValue)) {
                paramValue = paramValue.replaceAll("-1;", "");
            }
            this.setResultParam("paramValue", contractParameterPref.isRead() && multiListParamValue != null ? paramValue : "-1");
            this.setResultParam("paramCustomValue", contractParameterPref.isRead() && multiListParamValue != null ? multiListParamValue.getCustomValue() : "");
            this.setResultParam("paramValues", this.contractParameterManager.getMultiListValues(this.parameterId));
        }
    }

    public void updateParameterType11() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null && contractParameterPref.isWrite()) {
            String idValue = this.req.get("parameterValue");
            if (!Utils.isEmptyString((String)idValue)) {
                idValue = idValue.replaceAll(",", ";");
            }
            String customValue = this.req.get("parameterCustomValue");
            MultiListParamValues multiListParamValues = new MultiListParamValues();
            if (!Utils.isEmptyString((String)idValue)) {
                multiListParamValues.parseValue(idValue);
            }
            if (!Utils.isEmptyString((String)customValue)) {
                multiListParamValues.parseCustomValue(customValue);
            }
            this.contractParameterManager.updateMultiListParameterAndItems(this.contract.getId(), this.parameterId, multiListParamValues, -1);
            this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, multiListParamValues));
            multiListParamValues = this.contractParameterManager.getMultiListParamValues(this.contract.getId(), this.parameterId);
            this.setResultParam("paramId", this.parameterId);
            String multiListValue = Utils.isEmptyString((String)multiListParamValues.toStringValue()) ? "" : multiListParamValues.toStringValue();
            this.setResultParam("paramValue", contractParameterPref.isRead() ? multiListValue : "");
            this.setResultParam("paramType", contractParameterPref.getType().getId());
        }
    }

    private void a() {
        if (this.context.getRequest().getParameter("ct") == null) {
            this.setResultParam("contentType", (Object)ActionResultContentType.jsp);
        }
        if (this.contractParameterManager == null) {
            this.contractParameterManager = new ContractParameterManager(this.con);
        }
        if (this.prefDao == null) {
            this.prefDao = new ContractParameterPrefDao(this.con);
        }
        this.parameterId = this.req.getInt("parameterId", 0);
        this.contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
    }
}

