/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.tariff.TariffTreeBuilder;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.Recyclable;

public class ContractManager
implements Recyclable,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    private Connection con;
    private PreparedStatement getByIdPS = null;
    private PreparedStatement getRealtimeTariffTreeSetPS = null;

    public ContractManager(Connection con) {
        this.con = con;
    }

    public List<Contract> getContracts(String idList) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            if (idList == null || idList.isEmpty()) {
                return result;
            }
            String query = "SELECT * FROM contract WHERE id IN ( " + idList + " )";
            try (PreparedStatement ps = this.con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getContractFromRS(rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Contract getContractById(int contractId) {
        Contract contract = null;
        try {
            PreparedStatement ps = this.getByIdPS;
            if (ps == null) {
                ps = this.getByIdPS = this.con.prepareStatement("SELECT * FROM contract WHERE id=?");
            }
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                contract = this.getContractFromRS(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return contract;
    }

    @Deprecated
    public Contract getContractByTitle(String title) {
        Contract result = null;
        try {
            String query = "SELECT * FROM contract WHERE title=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getContractFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Contract> getContractsByTitles(List<String> titles) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        if (titles != null && !titles.isEmpty()) {
            String query = "SELECT * FROM contract WHERE true " + " OR title=?".repeat(titles.size());
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int len = titles.size();
                for (int index = 1; index <= len; ++index) {
                    ps.setString(index, titles.get(index - 1));
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(this.getContractFromRS(rs));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private Contract getContractFromRS(ResultSet rs) throws SQLException {
        Contract contract = new Contract();
        contract.setId(rs.getInt("id"));
        contract.setTitle(rs.getString("title"));
        contract.setPswd(rs.getString("pswd"));
        contract.setComment(rs.getString("comment"));
        contract.setBalanceMode(rs.getInt("mode"));
        contract.setBalanceLimit(rs.getBigDecimal("closesumma"));
        contract.setGroups(rs.getLong("gr"));
        contract.setFc(rs.getInt("fc"));
        contract.setParamGroup(rs.getInt("pgid"));
        contract.setDateFrom(rs.getDate("date1"));
        contract.setDateTo(rs.getDate("date2"));
        contract.setDel(rs.getInt("del"));
        contract.setSuperId(rs.getInt("scid"));
        contract.setDependSubList(rs.getString("sub_list"));
        contract.setSubMode(rs.getInt("sub_mode"));
        contract.setStatus(rs.getInt("status"));
        contract.setTitlePatternId(rs.getInt("title_pattern_id"));
        contract.setStatusDate(TimeUtils.convertDateToCalendar((java.util.Date)rs.getDate("status_date")));
        contract.setDomainId(rs.getInt("domainId"));
        return contract;
    }

    public TariffTreeSet getRealtimeTariffTreeSet(int cid, java.util.Date date, String module, int mid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, date, module, mid, 0, 0, useChache);
    }

    @Deprecated
    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Calendar time, String module, int mid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, time.getTime(), module, mid, 0, 0, useChache);
    }

    @Deprecated
    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Calendar time, String module, int mid, int emid, int eid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, time.getTime(), module, mid, emid, eid, useChache);
    }

    public TariffTreeSet getRealtimeTariffTreeSet(int cid, java.util.Date time, String module, int mid, int emid, int eid, boolean useChache) {
        TariffTreeSet result = null;
        try {
            TariffTreeBuilder ttb = new TariffTreeBuilder(this.con);
            result = new TariffTreeSet(module, mid, ttb, cid, useChache);
            PreparedStatement ps = this.getRealtimeTariffTreeSetPS;
            if (ps == null) {
                String query = "SELECT tree_id, date1, date2, emid, eid, 1, pos FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) UNION SELECT tree_id, date1, date2, emid, eid, 0, pos FROM contract_tree_link WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND (date2 IS NULL OR date2>=?) ORDER BY 4 DESC, 5 DESC, 6 ASC, 7 ASC";
                ps = this.getRealtimeTariffTreeSetPS = this.con.prepareStatement(query);
            }
            Date dt = TimeUtils.convertDateToSqlDate((java.util.Date)time);
            ps.setInt(1, cid);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, dt);
            ps.setInt(5, cid);
            ps.setInt(6, emid);
            ps.setInt(7, eid);
            ps.setDate(8, dt);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int treeId = rs.getInt(1);
                Date dateFrom = rs.getDate(2);
                Date dateTo = rs.getDate(3);
                int _emid = rs.getInt(4);
                int _eid = rs.getInt(5);
                result.addTariffTree(treeId, _emid, _eid, dateFrom, dateTo);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public TariffTreeSet getTariffTreeSetForDay(int contractId, Calendar time, String module, int moduleId, boolean useChache) {
        LocalDate localDate = LocalDateTime.ofInstant(time.toInstant(), time.getTimeZone().toZoneId()).toLocalDate();
        return this.getTariffTreeSetForDay(contractId, localDate, module, moduleId, useChache);
    }

    public TariffTreeSet getTariffTreeSetForDay(int contractId, LocalDate time, String module, int moduleId, boolean useChache) {
        TariffTreeSet result = null;
        try {
            TariffTreeBuilder ttb = new TariffTreeBuilder(this.con);
            result = new TariffTreeSet(module, moduleId, ttb, contractId, useChache);
            Date day = TimeUtils.convertLocalDateToSqlDate((LocalDate)time);
            String query = "SELECT tree_id, date1, date2, emid, eid, 1, pos FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ( isNull(date1) OR date1='0000-00-00' OR date1<=? ) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) UNION SELECT tree_id, date1, date2, emid, eid, 0, pos FROM contract_tree_link WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY 4 DESC, 5 DESC, 6 ASC, 7 ASC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setDate(2, day);
            ps.setDate(3, day);
            ps.setInt(4, contractId);
            ps.setDate(5, day);
            ps.setDate(6, day);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int treeId = rs.getInt(1);
                Date dateFrom = rs.getDate(2);
                Date dateTo = rs.getDate(3);
                int emid = rs.getInt(4);
                int eid = rs.getInt(5);
                result.addTariffTree(treeId, emid, eid, dateFrom, dateTo);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Contract> getSubContracts(int contractId) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        String query = "SELECT * FROM contract WHERE scid=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getContractFromRS(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public boolean isSubContract(int cid, int subcid) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT * FROM contract WHERE id=? AND scid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, subcid);
            ps.setInt(2, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<Contract> getSubContracts(int cid, int subMode) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            String query = "SELECT * FROM contract WHERE scid=? AND sub_mode=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, subMode);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getContractFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public void updateLastTariffChange(int cid) {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET last_tariff_change=NOW() WHERE id=?");
            ps.setInt(1, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateContract(Contract contract) {
        if (contract != null) {
            try {
                int index = 1;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append("contract");
                query.append(" SET gr=?, title=?, title_pattern_id=?, pswd=?, date1=?, date2=?,");
                query.append(" mode=?, closesumma=?, pgid=?, fc=?, comment=?, del=?,");
                query.append(" scid=?, sub_list=?, sub_mode=?, status=?, status_date=?, domainId=? WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setLong(index++, contract.getGroups());
                ps.setString(index++, contract.getTitle());
                ps.setInt(index++, contract.getTitlePatternId());
                ps.setString(index++, contract.getPswd());
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)contract.getDateFrom()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)contract.getDateTo()));
                ps.setInt(index++, contract.getBalanceMode());
                ps.setBigDecimal(index++, contract.getBalanceLimit());
                ps.setInt(index++, contract.getParamGroup());
                ps.setInt(index++, contract.getFc());
                ps.setString(index++, contract.getComment());
                ps.setInt(index++, contract.getDel());
                ps.setInt(index++, contract.getSuperId());
                ps.setString(index++, contract.getDependSubList());
                ps.setInt(index++, contract.getSubMode());
                ps.setInt(index++, contract.getStatus());
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)contract.getStatusDate()));
                ps.setInt(index++, contract.getDomainId());
                ps.setInt(index++, contract.getId());
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addContractGroup(int cid, int groupId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET gr=gr|(1<<?) WHERE id=?");
            ps.setInt(1, groupId);
            ps.setInt(2, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException("error add contract group", (Throwable)ex);
        }
    }

    public void deleteContractGroup(int cid, long groupId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET gr=gr&~(1<<?) WHERE id=?");
            ps.setLong(1, groupId);
            ps.setInt(2, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException("error delete contract group", (Throwable)ex);
        }
    }

    public void recycle() {
        try {
            if (this.getByIdPS != null) {
                this.getByIdPS.close();
                this.getByIdPS = null;
            }
            if (this.getRealtimeTariffTreeSetPS != null) {
                this.getRealtimeTariffTreeSetPS.close();
                this.getRealtimeTariffTreeSetPS = null;
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<Integer, Integer> getContractParameterGroupCountMap() throws BGException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT pgid, COUNT(*) FROM contract GROUP BY pgid");
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getInt(2));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return map;
    }

    public boolean checkContractService(int contractId, int serviceId, java.util.Date date) throws BGException {
        boolean result = false;
        try {
            Date sqlDate = TimeUtils.convertDateToSqlDate((java.util.Date)date);
            String query = "SELECT count(*) FROM contract_service WHERE cid=? AND sid=? AND date1<=? AND ( isNull( date2 ) || date2 >=? )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, serviceId);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public void close() {
        this.recycle();
    }
}

