/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.util.Config;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusLogDao;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractSetStatusLogicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangingEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.worker.Recyclable;
import ru.bitel.common.worker.ThreadContext;

public class ContractStatusManager
implements Recyclable {
    private static final Logger logger = LogManager.getLogger();
    protected final Connection con;
    private final ServerContext context;
    private final EventProcessor ep;
    private ContractManager contractManager;
    private PreparedStatement getStatusListPS;
    private PreparedStatement getPeriodListPS;

    public ContractStatusManager(Connection con) {
        this.con = con;
        ThreadContext context = ThreadContext.get();
        this.context = context instanceof ServerContext ? (ServerContext)context : null;
        this.ep = EventProcessor.getInstance();
    }

    public List<ContractStatus> getStatusListAfterDate(int contractId, Calendar date) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
        String query = "SELECT * FROM contract_status WHERE cid=? AND date1>? ORDER BY date1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, contractId);
        ps.setDate(2, sqlDate);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getStatusFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    private void updateStatus(ContractStatus status, Integer userId) throws BGException {
        try {
            PreparedStatement ps;
            if (status.getId() <= 0) {
                String query = "INSERT INTO contract_status (date1, date2, status, comment, cid) VALUES (?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(5, status.getContractId());
            } else {
                String query = "UPDATE contract_status SET date1=?, date2=?, status=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, status.getId());
            }
            ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateTo()));
            ps.setInt(3, status.getStatus());
            ps.setString(4, status.getComment());
            ps.executeUpdate();
            if (status.getId() <= 0) {
                status.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
            if (this.context != null) {
                this.context.publishAfterCommit(new ContractStatusModifiedEvent(status.getContractId(), (int)userId, null, status));
            } else {
                this.ep.publish(new ContractStatusModifiedEvent(status.getContractId(), (int)userId, null, status));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setContractStatus(ContractStatus status) throws SQLException {
        String query = "UPDATE contract SET status=?, status_date=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, status.getStatus());
        ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)status.getDateFrom()));
        ps.setInt(3, status.getContractId());
        ps.executeUpdate();
        ps.close();
    }

    private void deleteStatus(int id) throws BGException {
        try {
            String query = "DELETE FROM contract_status WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            ContractStatus status = new ContractStatus();
            status.setId(id);
            if (this.context != null) {
                this.context.publishAfterCommit(new ContractStatusModifiedEvent(status.getContractId(), 0, status, null));
            } else {
                this.ep.publish(new ContractStatusModifiedEvent(status.getContractId(), 0, status, null));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void deleteStatus(ContractStatus status, int userId) throws BGException {
        try {
            String query = "DELETE FROM contract_status WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, status.getId());
            ps.executeUpdate();
            ps.close();
            if (this.context != null) {
                this.context.publishAfterCommit(new ContractStatusModifiedEvent(status.getContractId(), userId, status, null));
            } else {
                this.ep.publish(new ContractStatusModifiedEvent(status.getContractId(), userId, status, null));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private ContractStatus getStatusFromRs(ResultSet rs) throws SQLException {
        ContractStatus result = new ContractStatus();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setStatus(rs.getInt("status"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public void changeStatus(ContractStatus newStatus, Integer userId) throws BGException {
        this.changeStatus(newStatus, userId, true);
    }

    private ContractManager getContractManager() {
        if (this.contractManager == null) {
            this.contractManager = new ContractManager(this.con);
        }
        return this.contractManager;
    }

    public void changeStatus(ContractStatus newStatus, Integer userId, boolean processEvent) throws BGException {
        try {
            userId = userId != null ? userId : 0;
            boolean useEventSetStatusLogic = Setup.getSetup().getBoolean("use.event.set.status.logic", false);
            ContractStatus originalStatus = newStatus.clone();
            newStatus = newStatus.clone();
            Contract contract = this.getContractManager().getContractById(originalStatus.getContractId());
            if (contract == null) {
                return;
            }
            GregorianCalendar prevDay = new GregorianCalendar();
            prevDay.setTime(originalStatus.getDateFrom());
            ((Calendar)prevDay).add(5, -1);
            GregorianCalendar nextDay = null;
            if (originalStatus.getDateTo() != null) {
                nextDay = new GregorianCalendar();
                nextDay.setTime(originalStatus.getDateTo());
                ((Calendar)nextDay).add(6, 1);
            }
            ArrayList<ContractStatus> statusList = new ArrayList<ContractStatus>();
            try (ContractStatusDao contractStatusDao = new ContractStatusDao(this.con);){
                statusList.addAll(contractStatusDao.getStatusList(originalStatus.getContractId(), originalStatus.getDateFrom()).stream().map(a -> ContractStatusUtils.toContractStatusOld(a)).toList());
            }
            for (ContractStatus status : statusList) {
                if (!ContractStatusManager.isStatusPeriodValid(newStatus)) break;
                if (useEventSetStatusLogic) {
                    ContractSetStatusLogicEvent contractSetStatusLogicEvent = new ContractSetStatusLogicEvent((int)userId, status, newStatus, originalStatus);
                    contractSetStatusLogicEvent = EventProcessor.getInstance().request(contractSetStatusLogicEvent);
                    if (contractSetStatusLogicEvent.isProcessed()) continue;
                }
                if (newStatus.getDateFrom() != null && status.getDateTo() != null && !TimeUtils.dateBeforeOrEq((java.util.Date)newStatus.getDateFrom(), (java.util.Date)status.getDateTo()) || newStatus.getDateTo() != null && status.getDateFrom() != null && !TimeUtils.dateBeforeOrEq((java.util.Date)status.getDateFrom(), (java.util.Date)newStatus.getDateTo())) continue;
                if (TimeUtils.dateBeforeOrEq((java.util.Date)newStatus.getDateFrom(), (java.util.Date)status.getDateFrom()) && (newStatus.getDateTo() == null || status.getDateTo() != null && TimeUtils.dateBeforeOrEq((java.util.Date)status.getDateTo(), (java.util.Date)newStatus.getDateTo()))) {
                    this.deleteStatus(status, userId);
                    continue;
                }
                if (newStatus.getDateTo() != null && TimeUtils.periodInRange((java.util.Date)newStatus.getDateFrom(), (java.util.Date)newStatus.getDateTo(), (java.util.Date)status.getDateFrom(), (java.util.Date)status.getDateTo())) {
                    ContractStatus nextStatus = status.clone();
                    nextStatus.setDateFrom(nextDay.getTime());
                    if (ContractStatusManager.isStatusPeriodValid(nextStatus)) {
                        this.updateStatus(nextStatus, userId);
                    }
                    status.setDateTo(prevDay.getTime());
                    this.doByPeriod(status, userId);
                    continue;
                }
                if (newStatus.getDateTo() != null && TimeUtils.dateInRange((java.util.Date)status.getDateFrom(), (java.util.Date)newStatus.getDateFrom(), (java.util.Date)newStatus.getDateTo())) {
                    status.setDateFrom(nextDay.getTime());
                    this.doByPeriod(status, userId);
                    continue;
                }
                if (status.getDateTo() != null && !TimeUtils.dateInRange((java.util.Date)status.getDateTo(), (java.util.Date)newStatus.getDateFrom(), (java.util.Date)newStatus.getDateTo())) continue;
                status.setDateTo(prevDay.getTime());
                this.doByPeriod(status, userId);
            }
            ContractStatus statusEvent = new ContractStatus();
            statusEvent.setContractId(newStatus.getContractId());
            statusEvent.setDateFrom(newStatus.getDateFrom());
            statusEvent.setDateTo(newStatus.getDateTo());
            statusEvent.setStatus(newStatus.getStatus());
            statusEvent.setComment(newStatus.getComment());
            if (processEvent) {
                ContractStatusChangingEvent contractStatusChangingEvent = new ContractStatusChangingEvent((int)userId, statusEvent, originalStatus);
                contractStatusChangingEvent = EventProcessor.getInstance().request(contractStatusChangingEvent);
            }
            if (ContractStatusManager.isStatusPeriodValid(statusEvent)) {
                this.updateStatus(statusEvent, userId);
            }
            java.util.Date date = new java.util.Date();
            if (TimeUtils.dateBeforeOrEq((java.util.Date)statusEvent.getDateFrom(), (java.util.Date)date) && (statusEvent.getDateTo() == null || TimeUtils.dateBeforeOrEq((java.util.Date)date, (java.util.Date)statusEvent.getDateTo()))) {
                this.setContractStatus(statusEvent);
                if (processEvent) {
                    EventProcessor.getInstance().publishAfterCommit(new ContractStatusChangedEvent(statusEvent, userId));
                    EventProcessor.getInstance().publishAfterCommit(new ContractStatusChangedTopicEvent(statusEvent, userId));
                }
            }
            ContractStatusLog log = ContractStatusLog.builder().setDate(new java.util.Date()).setContractId(originalStatus.getContractId()).setComment(originalStatus.getComment()).setUserId(userId).setStatus(originalStatus.getStatus()).setDate1(originalStatus.getDateFrom()).setDate2(originalStatus.getDateTo()).build();
            if (originalStatus.getStatus() != statusEvent.getStatus() || statusEvent.getDateFrom() == null || originalStatus.getDateFrom().getTime() != statusEvent.getDateFrom().getTime() || originalStatus.getDateTo() == null && statusEvent.getDateTo() != null || originalStatus.getDateTo() != null && statusEvent.getDateTo() == null || originalStatus.getDateTo() != null && statusEvent.getDateTo() != null && originalStatus.getDateTo().getTime() != statusEvent.getDateTo().getTime()) {
                log.setComment(log.getComment() + "; \u0441\u0442\u0430\u0442\u0443\u0441 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f (\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u043a: " + TimeUtils.formatDate((java.util.Date)statusEvent.getDateFrom()) + "-" + TimeUtils.formatDate((java.util.Date)statusEvent.getDateTo()) + ":" + StatusCache.getInstance().getStatusTitle(statusEvent.getStatus()) + ")");
                if (!ContractStatusManager.isStatusPeriodValid(statusEvent)) {
                    log.setComment(log.getComment() + "(\u0442.\u0435. \u0432\u044b\u0440\u043e\u0434\u0438\u043b\u0441\u044f)");
                }
            }
            if (!originalStatus.getComment().equals(statusEvent.getComment())) {
                log.setComment(log.getComment() + "; \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f: \"" + statusEvent.getComment() + "\"");
            }
            this.saveLog(log);
            if (contract.isSuper()) {
                ContractStatusManagerConf conf = Setup.getSetup().getConfig(0, ContractStatusManagerConf.class);
                if (conf.dependSubContractStatusChange) {
                    Iterator<Object> iterator = Utils.toIntegerList((String)contract.getDependSubList()).iterator();
                    while (iterator.hasNext()) {
                        int subId = (Integer)iterator.next();
                        originalStatus.setContractId(subId);
                        this.changeStatus(originalStatus, userId, processEvent);
                    }
                }
                if (conf.independSubContractStatusChange) {
                    for (Contract contr : this.getContractManager().getSubContracts(contract.getId(), 1)) {
                        originalStatus.setContractId(contr.getId());
                        this.changeStatus(originalStatus, userId, processEvent);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public static boolean isStatusPeriodValid(ContractStatus status) {
        return status.getDateFrom() != null && (status.getDateTo() == null || TimeUtils.dateBeforeOrEq((java.util.Date)status.getDateFrom(), (java.util.Date)status.getDateTo()));
    }

    private void doByPeriod(ContractStatus status, Integer userId) throws BGException {
        if (ContractStatusManager.isStatusPeriodValid(status)) {
            this.updateStatus(status, userId);
        } else {
            this.deleteStatus(status, userId);
        }
    }

    private void saveLog(ContractStatusLog log) throws BGException {
        try (ContractStatusLogDao contractStatusLogDao = new ContractStatusLogDao(this.con);){
            contractStatusLogDao.update((Object)log);
        }
    }

    public List<ContractStatus> getStatusList(int cid, Set<Integer> statuses, java.util.Date startMonth, java.util.Date endMonth) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        if (this.getStatusListPS == null) {
            String query = "SELECT status.id, status.date1, status.date2 FROM contract_status AS status WHERE status.cid=? AND status.status IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) AND (? IS NULL OR status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) ORDER BY status.date1";
            this.getStatusListPS = this.con.prepareStatement(query);
        }
        if (statuses.size() > 20) {
            logger.error("Too many suspended statuses (contract.status.suspend.codes)!");
        }
        int i = 1;
        this.getStatusListPS.setInt(i++, cid);
        for (Integer status : statuses) {
            this.getStatusListPS.setInt(i++, status);
        }
        while (i < 22) {
            this.getStatusListPS.setNull(i, 4);
            ++i;
        }
        Date endMonthSql = TimeUtils.convertDateToSqlDate((java.util.Date)endMonth);
        this.getStatusListPS.setDate(i++, endMonthSql);
        this.getStatusListPS.setDate(i++, endMonthSql);
        this.getStatusListPS.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)startMonth));
        ResultSet rs = this.getStatusListPS.executeQuery();
        while (rs.next()) {
            Date date1 = rs.getDate(2);
            Date date2 = rs.getDate(3);
            ContractStatus status = new ContractStatus();
            status.setId(rs.getInt(1));
            status.setDateFrom(date1);
            status.setDateTo(date2);
            result.add(status);
        }
        rs.close();
        return result;
    }

    public List<Period> getPeriodList(int contractId, Set<Integer> statuses, java.util.Date startMonth, java.util.Date endMonth) throws SQLException {
        ArrayList<Period> result = new ArrayList<Period>();
        if (this.getPeriodListPS == null) {
            String query = "SELECT status.date1, status.date2 FROM contract_status AS status WHERE status.cid=? AND status.status IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) AND (? IS NULL OR status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) ORDER BY status.date1";
            this.getPeriodListPS = this.con.prepareStatement(query);
        }
        if (statuses.size() > 20) {
            logger.error("Too many suspended statuses (contract.status.suspend.codes)!");
        }
        int i = 1;
        this.getPeriodListPS.setInt(i++, contractId);
        for (Integer status : statuses) {
            this.getPeriodListPS.setInt(i++, status);
        }
        while (i < 22) {
            this.getPeriodListPS.setNull(i, 4);
            ++i;
        }
        Date endMonthSql = TimeUtils.convertDateToSqlDate((java.util.Date)endMonth);
        this.getPeriodListPS.setDate(i++, endMonthSql);
        this.getPeriodListPS.setDate(i++, endMonthSql);
        this.getPeriodListPS.setDate(i++, TimeUtils.convertDateToSqlDate((java.util.Date)startMonth));
        ResultSet rs = this.getPeriodListPS.executeQuery();
        while (rs.next()) {
            java.util.Date date2;
            java.util.Date date1 = rs.getDate(1);
            if (date1 == null || startMonth != null && TimeUtils.dateBefore((java.util.Date)date1, (java.util.Date)startMonth)) {
                date1 = startMonth;
            }
            if ((date2 = rs.getDate(2)) == null || endMonth != null && TimeUtils.dateBefore((java.util.Date)endMonth, (java.util.Date)date2)) {
                date2 = endMonth;
            }
            result.add(new Period(date1, date2));
        }
        rs.close();
        result.trimToSize();
        return result;
    }

    public void recycle() {
        try {
            if (this.getStatusListPS != null) {
                this.getStatusListPS.close();
                this.getStatusListPS = null;
            }
            if (this.getPeriodListPS != null) {
                this.getPeriodListPS.close();
                this.getPeriodListPS = null;
            }
            if (this.contractManager != null) {
                this.contractManager.recycle();
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    static class ContractStatusManagerConf
    extends Config {
        final boolean dependSubContractStatusChange;
        final boolean independSubContractStatusChange = Utils.parseBoolean((String)Setup.getSetup().get("independ.subcontract.status.change", "no"));

        public ContractStatusManagerConf(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            this.dependSubContractStatusChange = Utils.parseBoolean((String)Setup.getSetup().get("depend.subcontract.status.change", "1"));
        }
    }

    public static class ContractStatusManager4Script
    extends ContractStatusManager {
        public ContractStatusManager4Script(Connection con) {
            super(con);
        }

        @Override
        public void deleteStatus(int id) throws BGException {
            super.deleteStatus(id);
        }

        @Override
        public void updateStatus(ContractStatus status, Integer userId) throws BGException {
            super.updateStatus(status, userId);
        }

        @Override
        public void doByPeriod(ContractStatus status, Integer userId) throws BGException {
            super.doByPeriod(status, userId);
        }

        @Override
        public void saveLog(ContractStatusLog log) throws BGException {
            super.saveLog(log);
        }
    }
}

