/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.admin.bean.ContractParameterGroupManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.object.bean.ObjectManager;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.SerializeContract;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ContractUtils {
    private Connection con;
    private ContractParameterGroupManager contractParameterGroupManager;
    private ContractParameterManager contractParameterManager;
    private Map<Integer, String> contractTitleMap;

    public ContractUtils(Connection con) {
        this.con = con;
        this.contractParameterGroupManager = new ContractParameterGroupManager(con);
        this.contractParameterManager = new ContractParameterManager(con);
        this.contractTitleMap = new HashMap<Integer, String>();
    }

    public String getContractTitle(int cid) {
        String title = this.contractTitleMap.get(cid);
        if (title == null) {
            title = this.getContractTitle(cid, false);
            this.contractTitleMap.put(cid, title);
        }
        return title;
    }

    public String getContractTitle(int cid, boolean withComment) {
        return this.getContractTitle(cid, withComment, "TITLE_NOT_FOUND");
    }

    public String getContractTitle(int cid, boolean withComment, String nullText) {
        String result = nullText;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT title" + (withComment ? ", comment" : "") + " FROM contract WHERE id=" + cid);){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = withComment ? rs.getString(1) + " (" + rs.getString(2) + ")" : rs.getString(1);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getCids(long groups) {
        StringBuffer result = new StringBuffer("-1");
        try {
            String query = "SELECT id FROM contract WHERE ?=0 OR ?&gr>0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, groups);
            ps.setLong(2, groups);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.append(", ");
                result.append(rs.getString(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result.toString();
    }

    public static String getCidsStringForQuery(int contractId, int cidMembers, Connection con) throws BGException {
        if (contractId < 1 || cidMembers < 1 || cidMembers > 3) {
            return null;
        }
        StringBuilder cids = new StringBuilder(cidMembers == 1 || cidMembers == 2 ? Integer.toString(contractId) : "");
        if (cidMembers == 2 || cidMembers == 3) {
            try (PreparedStatement ps = con.prepareStatement("SELECT sub_list FROM contract WHERE id=" + contractId);
                 ResultSet rs = ps.executeQuery();){
                if (rs.next() && Utils.notBlankString((String)rs.getString("sub_list"))) {
                    cids.append((cidMembers == 2 ? "," : "") + rs.getString("sub_list"));
                }
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
        return Utils.notBlankString((String)cids.toString()) ? cids.toString() : null;
    }

    public void addContractXML(int contractId, XMLStreamWriter rootNode, boolean withParams) throws SQLException, XMLStreamException, BGException {
        this.addContractXML(contractId, rootNode, withParams, true, false, null, null, null);
    }

    public void addContractXML(int contractId, XMLStreamWriter rootNode, boolean withParams, boolean addSuper) throws SQLException, XMLStreamException, BGException {
        this.addContractXML(contractId, rootNode, withParams, true, addSuper, null, null, null);
    }

    public void addContractXML(int contractId, XMLStreamWriter rootNode, boolean withParams, boolean addSub, boolean addSuper, Set<Integer> xmlContractConsist, Set<Integer> xmlModulesConsist, Set<Integer> xmlPluginConsist) throws SQLException, XMLStreamException, BGException {
        List<ContractObject> list;
        CustomerDao customerDao;
        Optional<CustomerLink> customerLink;
        boolean addCustomer;
        Contract contract = null;
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            contract = (Contract)contractDao.get(contractId);
        }
        if (contract == null) {
            System.err.println("Error taking params of not exist contract cid=" + contractId);
            return;
        }
        rootNode.writeStartElement("contract");
        if (xmlContractConsist == null || xmlContractConsist.contains(2)) {
            rootNode.writeAttribute("cid", String.valueOf(contractId));
            rootNode.writeAttribute("title", contract.getTitle());
            rootNode.writeAttribute("comment", contract.getComment());
            rootNode.writeAttribute("mode", String.valueOf(contract.getBalanceMode()));
            rootNode.writeAttribute("limit", Utils.formatBigDecimalSumm((BigDecimal)contract.getBalanceLimit()));
            rootNode.writeAttribute("date1", TimeUtils.formatDate((java.util.Date)contract.getDateFrom()));
            rootNode.writeAttribute("date2", TimeUtils.formatDate((java.util.Date)contract.getDateTo()));
            rootNode.writeAttribute("pswd", contract.getPassword());
            rootNode.writeAttribute("fc", String.valueOf(contract.getPersonType()));
            rootNode.writeAttribute("time", TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm"));
            rootNode.writeAttribute("gr", String.valueOf(contract.getGroups()));
            rootNode.writeAttribute("param_group", String.valueOf(contract.getParamGroupId()));
            rootNode.writeAttribute("status", String.valueOf(contract.getStatus()));
            rootNode.writeAttribute("status_date", TimeUtils.formatDate((java.util.Date)contract.getStatusTimeChange()));
        }
        if (xmlContractConsist == null || xmlContractConsist.contains(3)) {
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                rootNode.writeAttribute("balance_rest", balanceUtils.getBalance(new java.util.Date(), contractId).toPlainString());
            }
        }
        boolean bl = addCustomer = xmlContractConsist == null || xmlContractConsist.contains(10);
        if (addCustomer && (customerLink = (customerDao = new CustomerDao(this.con)).getCustomerLink(contract.getId(), LocalDateTime.now())).isPresent()) {
            JSONObject jSONObject = customerDao.getCustomerDataJson(customerLink.get().getCustomerId());
            this.addCustomerXML(jSONObject, rootNode);
        }
        if (xmlContractConsist == null || xmlContractConsist.contains(4)) {
            Object tariffData;
            Object rs;
            Iterator<ContractTariffOption> list2 = new ArrayList();
            String query = "SELECT t2.id, t2.title, t1.date1, t1.date2, t1.emid, t1.eid, t2.title_web, t1.id FROM contract_tariff AS t1, tariff_plan AS t2 WHERE t1.tpid=t2.id AND t1.cid=?";
            try (PreparedStatement preparedStatement = this.con.prepareStatement(query);){
                preparedStatement.setInt(1, contractId);
                rs = preparedStatement.executeQuery();
                try {
                    while (rs.next()) {
                        Date tariffPlanDateTo;
                        tariffData = new TariffData();
                        Date tariffPlanDateFrom = rs.getDate(3);
                        if (TimeUtils.dateInRange((java.util.Date)new java.util.Date(), (java.util.Date)tariffPlanDateFrom, (java.util.Date)(tariffPlanDateTo = rs.getDate(4)))) {
                            ((TariffData)tariffData).params.add(new KeyValue("name", "tariff"));
                        } else if (tariffPlanDateFrom != null && TimeUtils.dateBefore((java.util.Date)new java.util.Date(), (java.util.Date)tariffPlanDateFrom)) {
                            ((TariffData)tariffData).params.add(new KeyValue("name", "tariff_future"));
                        } else {
                            ((TariffData)tariffData).params.add(new KeyValue("name", "tariff_past"));
                        }
                        ((TariffData)tariffData).params.add(new KeyValue("tpid", String.valueOf(rs.getInt(1))));
                        ((TariffData)tariffData).params.add(new KeyValue("tariff_plan", rs.getString(2)));
                        ((TariffData)tariffData).params.add(new KeyValue("date1", TimeUtils.formatDate((java.util.Date)tariffPlanDateFrom)));
                        ((TariffData)tariffData).params.add(new KeyValue("date2", TimeUtils.formatDate((java.util.Date)tariffPlanDateTo)));
                        ((TariffData)tariffData).params.add(new KeyValue("emid", String.valueOf(rs.getInt(5))));
                        ((TariffData)tariffData).params.add(new KeyValue("eid", String.valueOf(rs.getInt(6))));
                        ((TariffData)tariffData).params.add(new KeyValue("tariff_plan_web", Utils.maskNull((String)rs.getString(7))));
                        ((TariffData)tariffData).params.add(new KeyValue("id", String.valueOf(rs.getInt(8))));
                        list2.add((ContractTariffOption)((Object)tariffData));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            if (!list2.isEmpty()) {
                try (ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);){
                    rs = list2.iterator();
                    while (rs.hasNext()) {
                        tariffData = (TariffData)rs.next();
                        int contractTariffId = ((TariffData)tariffData).params.stream().filter(a -> "id".equals(a.getKey())).map(a -> Integer.parseInt(a.getValue())).findFirst().orElse(0);
                        ((TariffData)tariffData).vars.addAll(contractTariffDao.getContractTariffVars(contractTariffId));
                    }
                }
            }
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                TariffData tariffData2 = (TariffData)iterator.next();
                rootNode.writeStartElement(tariffData2.params.get(0).getValue());
                tariffData2.params.remove(0);
                tariffData2.params.forEach(a -> {
                    try {
                        rootNode.writeAttribute(a.getKey(), a.getValue());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
                for (ContractTariffVar contractTariffVar : tariffData2.vars) {
                    rootNode.writeStartElement("var");
                    rootNode.writeAttribute("id", String.valueOf(contractTariffVar.getId()));
                    rootNode.writeAttribute("type", contractTariffVar.getType().getCode());
                    rootNode.writeAttribute("title", contractTariffVar.getTitle());
                    if (Utils.notBlankString((String)contractTariffVar.getValue())) {
                        rootNode.writeAttribute("value", contractTariffVar.getValue());
                    }
                    rootNode.writeAttribute("default_value", contractTariffVar.getDefaultValue());
                    rootNode.writeAttribute("module_id", String.valueOf(contractTariffVar.getModuleId()));
                    rootNode.writeEndElement();
                }
                rootNode.writeEndElement();
            }
        }
        if (xmlContractConsist == null || xmlContractConsist.contains(5)) {
            for (PersonalTariff personalTariff : new PersonalTariffManager(this.con).getPersonalTariffList(contractId, new java.util.Date())) {
                rootNode.writeStartElement("personal_tariff");
                rootNode.writeAttribute("id", String.valueOf(personalTariff.getId()));
                rootNode.writeAttribute("title", personalTariff.getTitle());
                rootNode.writeAttribute("date1", TimeUtils.formatDate((Calendar)personalTariff.getDate1()));
                rootNode.writeAttribute("date2", TimeUtils.formatDate((Calendar)personalTariff.getDate2()));
                rootNode.writeAttribute("tariff_plan_web", Utils.maskNull((String)personalTariff.getTitleWeb()));
                rootNode.writeEndElement();
            }
        }
        if (xmlContractConsist == null || xmlContractConsist.contains(6)) {
            for (ContractTariffOption option : new ContractTariffOptionDao(this.con).list(contractId, new java.util.Date())) {
                rootNode.writeStartElement("tariff_option");
                rootNode.writeAttribute("id", String.valueOf(option.getId()));
                rootNode.writeAttribute("option_id", String.valueOf(option.getOptionId()));
                rootNode.writeAttribute("option_title", option.getOptionTitle());
                rootNode.writeAttribute("time_act", TimeUtils.format((java.util.Date)option.getActivatedTime(), (String)"dd.MM.yyyy HH:mm:ss"));
                rootNode.writeAttribute("time_deact", TimeUtils.format((java.util.Date)option.getDeactivatedTime(), (String)"dd.MM.yyyy HH:mm:ss"));
                rootNode.writeAttribute("time_from", TimeUtils.format((java.util.Date)option.getTimeFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
                rootNode.writeAttribute("time_to", TimeUtils.format((java.util.Date)option.getTimeTo(), (String)"dd.MM.yyyy HH:mm:ss"));
                rootNode.writeAttribute("summa", Utils.formatBigDecimalSumm((BigDecimal)option.getSum()));
                rootNode.writeEndElement();
            }
        }
        rootNode.writeEndElement();
        if (xmlContractConsist == null || xmlContractConsist.contains(7)) {
            String query = "SELECT t2.id, t2.mid, t2.title, t1.date1, t1.date2 FROM contract_service AS t1, service AS t2 WHERE t1.sid=t2.id AND t1.cid=? AND ( t1.date1 IS NULL OR t1.date1<=CURDATE() )AND (t1.date2 IS NULL OR t1.date2>=CURDATE())";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                rootNode.writeStartElement("contract_service");
                rootNode.writeAttribute("id", String.valueOf(resultSet.getInt(1)));
                rootNode.writeAttribute("mid", String.valueOf(resultSet.getInt(2)));
                rootNode.writeAttribute("title", resultSet.getString(3));
                rootNode.writeAttribute("date1", TimeUtils.formatDate((java.util.Date)resultSet.getDate(4)));
                rootNode.writeAttribute("date2", TimeUtils.formatDate((java.util.Date)resultSet.getDate(5)));
                rootNode.writeEndElement();
            }
            resultSet.close();
            ps.close();
        }
        if (xmlContractConsist == null || xmlContractConsist.contains(8)) {
            PreparedStatement ps = this.con.prepareStatement("SELECT uid, subject, comment, dt FROM contract_comment WHERE cid=" + contractId);
            ResultSet rs = ps.executeQuery();
            ServerUtils.resultSetToXML(rs, rootNode, "contract_comment");
            rs.close();
            ps.close();
        }
        if (withParams) {
            this.addContractParameters(contractId, rootNode, "parameters");
        }
        ContractModuleManager msu = new ContractModuleManager(this.con);
        for (BGModule bGModule : ModuleCache.getInstance().getModulesListWithIds(msu.getContractModuleSet(contractId))) {
            if (xmlModulesConsist != null && !xmlModulesConsist.contains(bGModule.getId())) continue;
            rootNode.writeStartElement("module");
            rootNode.writeAttribute("id", String.valueOf(bGModule.getId()));
            rootNode.writeAttribute("title", bGModule.getTitle());
            rootNode.writeAttribute("name", bGModule.getName());
            ApplicationModule applicationModule = ModuleCache.getInstance().getApplicationModule(bGModule.getName());
            if (applicationModule != null) {
                applicationModule.serializeContract(this.con, contractId, bGModule.getId(), rootNode, true);
            }
            rootNode.writeEndElement();
        }
        Map<String, BGPluginServer> pluginMap = BGPluginManagerServer.getManager().getPluginsMap();
        for (BGPluginServer plugin : pluginMap.values()) {
            if (xmlPluginConsist != null && !xmlPluginConsist.contains(plugin.getPluginUID())) continue;
            rootNode.writeStartElement("plugin");
            rootNode.writeAttribute("id", String.valueOf(plugin.getPluginUID()));
            rootNode.writeAttribute("title", plugin.getName());
            rootNode.writeAttribute("name", plugin.getId());
            SerializeContract p = plugin.getInvokeablePoint(SerializeContract.class);
            if (p != null) {
                p.serializeContract(this.con, contractId, rootNode, true);
            }
            rootNode.writeEndElement();
        }
        if ((xmlContractConsist == null || xmlContractConsist.contains(9)) && (list = new ObjectManager(this.con).getObjectList(contractId)).size() > 0) {
            Map<Integer, ObjectType> typeMap = new ObjectTypeManager(this.con).getTypeMap();
            rootNode.writeStartElement("objects");
            for (ContractObject object : list) {
                rootNode.writeStartElement("object");
                rootNode.writeAttribute("id", String.valueOf(object.getId()));
                rootNode.writeAttribute("title", object.getTitle());
                rootNode.writeAttribute("date1", TimeUtils.formatDate((java.util.Date)object.getDateFrom()));
                rootNode.writeAttribute("date2", TimeUtils.formatDate((java.util.Date)object.getDateTo()));
                rootNode.writeAttribute("type", String.valueOf(object.getTypeId()));
                ObjectType type = typeMap.get(object.getTypeId());
                if (type == null) {
                    rootNode.writeAttribute("error", "Type not found!");
                    continue;
                }
                ObjectManager.addObjectParams(this.con, object.getId(), rootNode, type);
                rootNode.writeEndElement();
            }
            rootNode.writeEndElement();
        }
        if (contract.getSuperCid() == -1 && addSub) {
            Iterator iterator = Utils.toIntegerList((String)contract.getDependSubList()).iterator();
            while (iterator.hasNext()) {
                int subCid = (Integer)iterator.next();
                rootNode.writeStartElement("sub_contract");
                rootNode.writeAttribute("cid", String.valueOf(subCid));
                this.addContractXML(subCid, rootNode, withParams, false, false, xmlContractConsist, xmlModulesConsist, xmlPluginConsist);
                rootNode.writeEndElement();
            }
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                for (Contract subContract : contractDao.getSubContracts(contract.getId(), 1)) {
                    rootNode.writeStartElement("sub_contract_independ");
                    rootNode.writeAttribute("cid", String.valueOf(subContract.getId()));
                    this.addContractXML(subContract.getId(), rootNode, withParams, false, false, xmlContractConsist, xmlModulesConsist, xmlPluginConsist);
                    rootNode.writeEndElement();
                }
            }
        } else if (contract.isSub() && addSuper) {
            rootNode.writeStartElement("super_contract");
            rootNode.writeAttribute("cid", String.valueOf(contract.getSuperCid()));
            this.addContractXML(contract.getSuperCid(), rootNode, withParams, false, false, xmlContractConsist, xmlModulesConsist, xmlPluginConsist);
            rootNode.writeEndElement();
        }
    }

    private void addCustomerXML(JSONObject customerData, XMLStreamWriter rootNode) {
        customerData.keys().forEachRemaining(k -> {
            Object object = customerData.get(k);
            if (object instanceof String) {
                try {
                    if (Character.isAlphabetic(k.charAt(0))) {
                        rootNode.writeAttribute((String)k, String.valueOf(object));
                    } else {
                        LogManager.getLogger().error("addCustomerXML: \u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 {} = {}", k, object);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        customerData.keys().forEachRemaining(k -> {
            Object object = customerData.get(k);
            if (object instanceof JSONObject) {
                try {
                    if (Character.isAlphabetic(k.charAt(0))) {
                        rootNode.writeStartElement((String)k);
                        this.addCustomerXML((JSONObject)object, rootNode);
                        rootNode.writeEndElement();
                    } else {
                        LogManager.getLogger().error("addCustomerXML: \u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 {} = {}", k, object);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void addContractParameters(int cid, boolean group, Element parameters, Element rootNode) throws DOMException, SQLException, BGException {
        this.addContractParameters(cid, group, parameters, rootNode, 0);
    }

    public void addContractParameters(int cid, boolean group, Element parameters, Element rootNode, int userId) throws DOMException, SQLException, BGException {
        int pgid = 0;
        Element condel = XMLUtils.createElement((Element)rootNode, (String)"condel");
        try (PreparedStatement ps = this.con.prepareStatement("SELECT pgid FROM contract WHERE id=" + cid);){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                pgid = rs.getInt(1);
                condel.setAttribute("pgid", String.valueOf(pgid));
            }
            rs.close();
        }
        if (!group) {
            pgid = 0;
        }
        Set<Integer> parameterGroup = pgid > 0 ? this.contractParameterGroupManager.getParameterSetInGroup(pgid) : null;
        Map<Integer, ContractParamValue> dataType8 = this.contractParameterManager.getContractParamValueMap(cid);
        ContractParameterPrefDao dao = new ContractParameterPrefDao(this.con);
        List<ContractParameterPref> parameterList = dao.getContractParameterPrefList(parameterGroup);
        dao.close();
        HashMap<Integer, String> mapParam = this.contractParameterManager.getValuesForPids(parameterGroup, cid);
        for (ContractParameterPref parameter : parameterList) {
            boolean parameterAllowed;
            ContractParamValue contractParamValue;
            Element parameterElement = XMLUtils.createElement((Element)parameters, (String)"parameter");
            parameterElement.setAttribute("pid", String.valueOf(parameter.getId()));
            parameterElement.setAttribute("pt", String.valueOf(parameter.getType().getId()));
            parameterElement.setAttribute("title", parameter.getTitle());
            parameterElement.setAttribute("history", parameter.isHistory() ? "loopa" : "loopa_fade");
            parameterElement.setAttribute("alwaysVisible", String.valueOf(parameter.isAlwaysVisible()));
            String value = (String)mapParam.get(parameter.getId());
            if (parameter.getType() == ContractParameterPrefType.TYPE_CONTRACT_REF && (contractParamValue = dataType8.get(parameter.getId())) != null) {
                value = contractParamValue.toString();
            }
            parameterElement.setAttribute("value", (parameterAllowed = PermissionOfRoles.checkReadContractParameter(parameter.getId(), userId)) ? Utils.maskNull((String)value) : "<\u0421\u041a\u0420\u042b\u0422\u041e>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContractParameters(int cid, XMLStreamWriter rootNode, String paramsNodeName) throws DOMException, SQLException, XMLStreamException {
        try {
            rootNode.writeStartElement("condel");
            int pgid = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT pgid, del, fc, pfid FROM contract WHERE id=?");
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                pgid = rs.getInt(1);
                rootNode.writeAttribute("pgid", rs.getString(1));
                rootNode.writeAttribute("del", rs.getString(2));
                rootNode.writeAttribute("fc", rs.getString(3));
                rootNode.writeAttribute("pfid", rs.getString(4));
            }
            rs.close();
            ps.close();
            rootNode.writeEndElement();
            ps = this.con.prepareStatement("DROP TEMPORARY TABLE IF EXISTS param_pref_tmp");
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("CREATE TEMPORARY TABLE param_pref_tmp (pid INT NOT NULL, pt INT NOT NULL, sort INT NOT NULL, title VARCHAR(255))");
            ps.executeUpdate();
            ps.close();
            if (pgid > 0) {
                ps1 = this.con.prepareStatement("INSERT INTO param_pref_tmp (SELECT param_group.pid, pref.pt, pref.sort, pref.title FROM contract_parameter_group AS param_group LEFT JOIN contract_parameters_pref as pref ON pref.id=param_group.pid WHERE param_group.gid=? ORDER BY sort)");
                ps1.setInt(1, pgid);
                ps1.executeUpdate();
                ps1.close();
            } else {
                ps1 = this.con.prepareStatement("INSERT INTO param_pref_tmp (SELECT pref.id, pref.pt, pref.sort, pref.title FROM contract_parameters_pref as pref ORDER BY sort)");
                ps1.executeUpdate();
                ps1.close();
            }
            rootNode.writeStartElement(paramsNodeName);
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, param.val FROM param_pref_tmp LEFT JOIN contract_parameter_type_1 as param ON param.pid=param_pref_tmp.pid WHERE param_pref_tmp.pt=1 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.writeParameter(rootNode, rs.getInt(1), rs.getInt(2), rs.getString(3), rs.getInt(4), rs.getString(5));
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, param.address, param.comment FROM param_pref_tmp LEFT JOIN contract_parameter_type_2 as param ON param.pid=param_pref_tmp.pid WHERE param_pref_tmp.pt=2 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                rootNode.writeStartElement("parameter");
                rootNode.writeAttribute("pid", String.valueOf(rs.getInt(1)));
                rootNode.writeAttribute("pt", String.valueOf(rs.getInt(2)));
                rootNode.writeAttribute("title", Utils.maskNull((String)rs.getString(3)));
                rootNode.writeAttribute("sort", String.valueOf(rs.getInt(4)));
                rootNode.writeAttribute("value", Utils.maskNull((String)rs.getString(5)));
                String comment = rs.getString(6);
                if (comment != null) {
                    rootNode.writeAttribute("comment", comment);
                }
                rootNode.writeEndElement();
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, param.email FROM param_pref_tmp LEFT JOIN contract_parameter_type_3 as param ON param.pid=param_pref_tmp.pid WHERE param_pref_tmp.pt=3 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                String value = rs.getString(5);
                if (value == null) {
                    value = "";
                } else if (!value.isEmpty()) {
                    value = value.replaceAll("\n", "; ");
                }
                this.writeParameter(rootNode, rs.getInt(1), rs.getInt(2), rs.getString(3), rs.getInt(4), value);
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, param.val2, dir.title, COUNT(dir.id) FROM param_pref_tmp LEFT JOIN contract_parameter_type_4 as param ON param.pid=param_pref_tmp.pid LEFT JOIN contract_parameter_type_4_directory as dir ON dir.id=param.val2 WHERE param_pref_tmp.pt=4 AND param.cid=? GROUP BY param_pref_tmp.pid, param.val2 ORDER BY param.pid, param.val2");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            int currentPid = -1;
            int pt = 0;
            String title = null;
            int sort = 0;
            StringBuilder value = new StringBuilder();
            while (rs.next()) {
                int pid = rs.getInt(1);
                pt = rs.getInt(2);
                title = rs.getString(3);
                sort = rs.getInt(4);
                if (pid != currentPid && currentPid != -1) {
                    value.setLength(value.length() - 2);
                    this.writeParameter(rootNode, currentPid, pt, title, sort, value.toString());
                    value.setLength(0);
                }
                value.append(rs.getString(6)).append(": ").append(rs.getInt(7));
                value.append("; ");
                currentPid = pid;
            }
            if (value.length() > 0) {
                value.setLength(value.length() - 2);
                this.writeParameter(rootNode, currentPid, pt, title, sort, value.toString());
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, param.val FROM param_pref_tmp LEFT JOIN contract_parameter_type_5 as param ON param.pid=param_pref_tmp.pid WHERE param_pref_tmp.pt=5 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.writeParameter(rootNode, rs.getInt(1), rs.getInt(2), rs.getString(3), rs.getInt(4), rs.getString(5));
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, param.val FROM param_pref_tmp LEFT JOIN contract_parameter_type_6 as param ON param.pid=param_pref_tmp.pid WHERE param_pref_tmp.pt=6 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                String value2 = TimeUtils.format((java.util.Date)rs.getDate(5), (String)"dd.MM.yyyy");
                this.writeParameter(rootNode, rs.getInt(1), rs.getInt(2), rs.getString(3), rs.getInt(4), value2);
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, IF(param.val > 0,list_values.title,param.custom_value), param.val FROM param_pref_tmp LEFT JOIN contract_parameter_type_7 AS param ON param.pid=param_pref_tmp.pid LEFT JOIN contract_parameter_type_7_values AS list_values ON list_values.id=param.val WHERE param_pref_tmp.pt=7 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                rootNode.writeStartElement("parameter");
                rootNode.writeAttribute("pid", String.valueOf(rs.getInt(1)));
                rootNode.writeAttribute("pt", String.valueOf(rs.getInt(2)));
                rootNode.writeAttribute("sort", String.valueOf(rs.getInt(4)));
                rootNode.writeAttribute("title", rs.getString(3));
                rootNode.writeAttribute("value", Utils.maskNull((String)rs.getString(5)));
                rootNode.writeAttribute("valueId", String.valueOf(rs.getInt(6)));
                rootNode.writeEndElement();
            }
            rs.close();
            ps.close();
            String query = "SELECT id, pt, sort, title, val FROM contract_parameters_pref AS pref  LEFT JOIN contract_parameter_type_multilist AS multi ON multi.pid=pref.id  WHERE pt=11 AND cid=? AND title IS NOT NULL";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                rootNode.writeStartElement("parameter");
                rootNode.writeAttribute("pid", String.valueOf(rs.getInt(1)));
                rootNode.writeAttribute("pt", String.valueOf(rs.getInt(2)));
                rootNode.writeAttribute("sort", String.valueOf(rs.getInt(3)));
                rootNode.writeAttribute("title", rs.getString(4));
                rootNode.writeAttribute("value", rs.getString(5));
                rootNode.writeEndElement();
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, contract.title, param.val FROM param_pref_tmp LEFT JOIN contract_parameter_type_8 as param ON param.pid=param_pref_tmp.pid LEFT JOIN contract ON contract.id=param.val WHERE param_pref_tmp.pt=8 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                rootNode.writeStartElement("parameter");
                rootNode.writeAttribute("pid", String.valueOf(rs.getInt(1)));
                rootNode.writeAttribute("pt", String.valueOf(rs.getInt(2)));
                rootNode.writeAttribute("sort", String.valueOf(rs.getInt(4)));
                rootNode.writeAttribute("title", rs.getString(3));
                rootNode.writeAttribute("value", Utils.maskNull((String)rs.getString(5)));
                rootNode.writeAttribute("cid", String.valueOf(rs.getInt(6)));
                rootNode.writeEndElement();
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("SELECT param_pref_tmp.pid, param_pref_tmp.pt, param_pref_tmp.title, param_pref_tmp.sort, param.value FROM param_pref_tmp LEFT JOIN contract_parameter_type_phone AS param ON param.pid=param_pref_tmp.pid WHERE param_pref_tmp.pt=9 AND param.cid=?");
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.writeParameter(rootNode, rs.getInt(1), rs.getInt(2), rs.getString(3), rs.getInt(4), rs.getString(5));
            }
            rs.close();
            ps.close();
            rootNode.writeEndElement();
        }
        finally {
            PreparedStatement ps = this.con.prepareStatement("DROP TEMPORARY TABLE IF EXISTS param_pref_tmp");
            ps.executeUpdate();
            ps.close();
        }
    }

    private void writeParameter(XMLStreamWriter rootNode, int pid, int pt, String title, int sort, String value) throws XMLStreamException {
        rootNode.writeStartElement("parameter");
        rootNode.writeAttribute("pid", String.valueOf(pid));
        rootNode.writeAttribute("pt", String.valueOf(pt));
        rootNode.writeAttribute("sort", String.valueOf(sort));
        rootNode.writeAttribute("title", Utils.maskNull((String)title));
        rootNode.writeAttribute("value", value);
        rootNode.writeEndElement();
    }

    class TariffData {
        List<KeyValue> params = new ArrayList<KeyValue>();
        List<ContractTariffVar> vars = new ArrayList<ContractTariffVar>();

        TariffData() {
        }
    }
}

