/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean.find;

import bitel.billing.server.contract.bean.find.SearchContract;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;

public abstract class SearchContractModule {
    protected static final int MAX_SELECT = 10;

    public abstract List<Contract> findContracts(Connection var1, SearchContract var2, String var3, Date var4);

    public abstract String getName();

    protected void addWhereQuery(StringBuilder query, int compareType, String column) {
        query.append(" AND ");
        query.append(column);
        switch (compareType) {
            case 2: {
                query.append(" LIKE ?");
                break;
            }
            case 3: {
                query.append(" REGEXP ?");
                break;
            }
            default: {
                query.append("=?");
            }
        }
    }

    protected void addContractSelectPart(StringBuilder query) {
        query.append("SELECT DISTINCT contract.id, contract.title, contract.comment FROM contract ");
    }

    protected List<Contract> extractContracts(Connection con, String query, String param) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            PreparedStatement ps = con.prepareStatement(query.toString());
            ps.setString(1, param);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Contract contract = new Contract();
                contract.setId(rs.getInt(1));
                contract.setTitle(rs.getString(2));
                contract.setComment(rs.getString(3));
                result.add(contract);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void addContractFilter(StringBuilder query, SearchContract search, String sqlDate) {
        query.append(" contract.del=0 ");
        if (search.isContractPeriodCheck()) {
            query.append(" AND contract.date1<='");
            query.append(sqlDate);
            query.append("' AND (contract.date2 IS NULL OR '");
            query.append(sqlDate);
            query.append("'<=contract.date2) ");
        }
        if (search.getGroups() != 0L) {
            query.append(" AND contract.gr&");
            query.append(search.getGroups());
            query.append(">0");
        }
    }

    protected void addDateFilter(StringBuilder query, String tableName, String sqlDate) {
        this.addDateFilter(query, tableName, sqlDate, "date1", "date2");
    }

    protected void addDateFilter(StringBuilder query, String tableName, String sqlDate, String dateField1, String dateField2) {
        String fullColumn1 = tableName + "." + dateField1;
        String fullColumn2 = tableName + "." + dateField2;
        query.append(" AND (");
        query.append(fullColumn1);
        query.append(" IS NULL OR ");
        query.append(fullColumn1);
        query.append("<='");
        query.append(sqlDate);
        query.append("') AND (");
        query.append(fullColumn2);
        query.append(" IS NULL OR '");
        query.append(sqlDate);
        query.append("'<=");
        query.append(fullColumn2);
        query.append(")");
    }

    protected void addLimitAndTitleRegexpFilter(StringBuilder query, SearchContract search) {
        this.addContractTitleRegexpFilter(query, search);
        query.append(" LIMIT ");
        query.append(10);
    }

    private void addContractTitleRegexpFilter(StringBuilder query, SearchContract search) {
        if (search.getPatternTitle() != null && !search.getPatternTitle().isEmpty()) {
            query.append(" AND title REGEXP '");
            query.append(search.getPatternTitle());
            query.append("' ");
        }
    }
}

