/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.logon;

import bitel.billing.server.contract.logon.ContractLogonBase;
import bitel.billing.server.contract.logon.ContractLogonError;
import bitel.billing.server.contract.logon.ContractLogonLast;
import bitel.billing.server.contract.logon.ContractLogonOk;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class LogonManager {
    private static final Logger logger = LogManager.getLogger();
    protected Connection con;

    public LogonManager(Connection con) {
        this.con = con;
    }

    public ContractLogonLast getContractLogonLast(int contractId) {
        ContractLogonLast contractLogonLast = null;
        try {
            int index = 1;
            String query = "SELECT * FROM contract_logon_last WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, contractId);
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                contractLogonLast = new ContractLogonLast();
                contractLogonLast.setContractId(resultSet.getInt("cid"));
                contractLogonLast.setRemoteIP(resultSet.getString("ip"));
                contractLogonLast.setCounter(resultSet.getInt("n"));
                contractLogonLast.setDateTime(resultSet.getTimestamp("dt"));
            }
            resultSet.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return contractLogonLast;
    }

    public void searchLogonOk(String contractIds, SearchResult<ContractLogonBase> searchResult) {
        this.searchLogon(true, contractIds, searchResult);
    }

    public void searchLogonOk(int contractId, SearchResult<ContractLogonBase> searchResult) {
        this.searchLogon(true, contractId, searchResult);
    }

    public void searchLogonError(String contractIds, SearchResult<ContractLogonBase> searchResult) {
        this.searchLogon(false, contractIds, searchResult);
    }

    public void searchLogonError(int contractId, SearchResult<ContractLogonBase> searchResult) {
        this.searchLogon(false, contractId, searchResult);
    }

    public void clearLogonOkLog(int contractId, int logonLogRecord, int logonLogPeriod) {
        this.clearLogonLog(true, contractId, logonLogRecord, logonLogPeriod);
    }

    public void clearLogonErrorLog(int contractId, int logonLogRecord, int logonLogPeriod) {
        this.clearLogonLog(false, contractId, logonLogRecord, logonLogPeriod);
    }

    public void saveLogonOk(int contractId, String remoteAddr, String sessionId, String user) {
        try {
            int index = 1;
            String query = "INSERT contract_logon_ok SET cid=?, dt=now(), ip=?, session_id=?, user=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(index++, contractId);
            ps.setString(index++, remoteAddr);
            ps.setString(index++, sessionId);
            ps.setString(index++, user);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void saveLogonError(int contractId, String remoteAddr, HttpServletRequest request) {
        this.saveLogonError(contractId, remoteAddr, request.getParameter("user"), request.getParameter("pswd"));
    }

    public void saveLogonError(int contractId, String remoteAddr, String user, String data) {
        try {
            int index = 1;
            String query = "INSERT contract_logon_error SET cid=?, login=?, dt=now(), ip=?, error_code=?, request_data=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(index++, contractId);
            ps.setString(index++, user);
            ps.setString(index++, remoteAddr);
            ps.setInt(index++, 1);
            ps.setString(index++, data);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void clearLogonLog(boolean okTable, int contractId, int logonLogRecord, int logonLogPeriod) {
        String tableName = okTable ? "contract_logon_ok" : "contract_logon_error";
        try {
            int index = 1;
            int count = 0;
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(*) FROM ");
            query.append(tableName);
            query.append(" WHERE cid=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            ps.close();
            if (count > logonLogRecord) {
                index = 1;
                query = new StringBuilder();
                query.append("DELETE FROM ");
                query.append(tableName);
                query.append(" WHERE cid=? AND dt<?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, contractId);
                ps.setTimestamp(index++, new Timestamp(System.currentTimeMillis() - (long)logonLogPeriod * 86400000L));
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void searchLogon(boolean okTable, int contractId, SearchResult<ContractLogonBase> searchResult) {
        String tableName;
        String string = tableName = okTable ? "contract_logon_ok" : "contract_logon_error";
        if (searchResult != null) {
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            try {
                int index = 1;
                ResultSet resultSet = null;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                StringBuilder queryWhere = new StringBuilder();
                query.append("SELECT * FROM ");
                query.append(tableName);
                query.append(" WHERE cid=?");
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        queryWhere.append(" AND dt>?");
                    }
                    if (period.getDateTo() != null) {
                        queryWhere.append(" AND dt<?");
                    }
                }
                query.append((CharSequence)queryWhere);
                if (page.getPageSize() > 0) {
                    query.append(" LIMIT ?, ?");
                }
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, contractId);
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                    }
                }
                if (page.getPageSize() > 0) {
                    ps.setInt(index++, (page.getPageIndex() - 1) * page.getPageSize());
                    ps.setInt(index++, page.getPageSize());
                }
                resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    if (okTable) {
                        ContractLogonOk contractLogonOk = new ContractLogonOk();
                        contractLogonOk.setContractId(resultSet.getInt("cid"));
                        contractLogonOk.setRemoteIP(resultSet.getString("ip"));
                        contractLogonOk.setSessionId(resultSet.getString("session_id"));
                        contractLogonOk.setDateTime(resultSet.getTimestamp("dt"));
                        contractLogonOk.setPasswordType(resultSet.getString("user"));
                        list.add(contractLogonOk);
                        continue;
                    }
                    ContractLogonError contractLogonError = new ContractLogonError();
                    contractLogonError.setContractId(resultSet.getInt("cid"));
                    contractLogonError.setRemoteIP(resultSet.getString("ip"));
                    contractLogonError.setLogin(resultSet.getString("login"));
                    contractLogonError.setDateTime(resultSet.getTimestamp("dt"));
                    contractLogonError.setErrorCode(resultSet.getInt("error_code"));
                    contractLogonError.setRequestData(resultSet.getString("request_data"));
                    list.add(contractLogonError);
                }
                resultSet.close();
                ps.close();
                index = 1;
                query = new StringBuilder();
                query.append("SELECT COUNT(*) FROM ");
                query.append(tableName);
                query.append(" WHERE cid=?");
                query.append((CharSequence)queryWhere);
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, contractId);
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
                resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    page.setRecordCount(resultSet.getInt(1));
                }
                resultSet.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void searchLogon(boolean okTable, String contractIds, SearchResult<ContractLogonBase> searchResult) {
        String tableName;
        String string = tableName = okTable ? "contract_logon_ok" : "contract_logon_error";
        if (searchResult != null) {
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            try {
                int index = 1;
                StringBuilder query = new StringBuilder();
                StringBuilder queryWhere = new StringBuilder();
                query.append("SELECT t1.*, t2.title FROM ");
                query.append(tableName);
                query.append(" AS t1 LEFT JOIN contract AS t2 ON t1.cid=t2.id WHERE 1=1");
                if (contractIds != null && contractIds.matches("^\\d+(,\\s*\\d+)*$")) {
                    queryWhere.append(" AND t1.cid IN ( ");
                    queryWhere.append(contractIds);
                    queryWhere.append(" )");
                }
                if (period.getDateFrom() != null) {
                    queryWhere.append(" AND t1.dt>?");
                }
                if (period.getDateTo() != null) {
                    queryWhere.append(" AND t1.dt<?");
                }
                query.append((CharSequence)queryWhere);
                if (page.getPageSize() > 0) {
                    query.append(" LIMIT ?, ?");
                }
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
                if (page.getPageSize() > 0) {
                    ps.setInt(index++, (page.getPageIndex() - 1) * page.getPageSize());
                    ps.setInt(index++, page.getPageSize());
                }
                ResultSet resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    if (okTable) {
                        ContractLogonOk contractLogonOk = new ContractLogonOk();
                        contractLogonOk.setContractId(resultSet.getInt("t1.cid"));
                        contractLogonOk.setContractTitle(resultSet.getString("t2.title"));
                        contractLogonOk.setRemoteIP(resultSet.getString("t1.ip"));
                        contractLogonOk.setSessionId(resultSet.getString("t1.session_id"));
                        contractLogonOk.setDateTime(resultSet.getTimestamp("t1.dt"));
                        contractLogonOk.setPasswordType(resultSet.getString("t1.user"));
                        list.add(contractLogonOk);
                        continue;
                    }
                    ContractLogonError contractLogonError = new ContractLogonError();
                    contractLogonError.setContractId(resultSet.getInt("t1.cid"));
                    contractLogonError.setContractTitle(resultSet.getString("t2.title"));
                    contractLogonError.setRemoteIP(resultSet.getString("t1.ip"));
                    contractLogonError.setLogin(resultSet.getString("t1.login"));
                    contractLogonError.setDateTime(resultSet.getTimestamp("t1.dt"));
                    contractLogonError.setErrorCode(resultSet.getInt("t1.error_code"));
                    contractLogonError.setRequestData(resultSet.getString("t1.request_data"));
                    list.add(contractLogonError);
                }
                resultSet.close();
                ps.close();
                index = 1;
                query = new StringBuilder();
                query.append("SELECT COUNT(*) FROM ");
                query.append(tableName);
                query.append(" AS t1 WHERE 1=1");
                query.append((CharSequence)queryWhere);
                ps = this.con.prepareStatement(query.toString());
                if (period.getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
                resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    page.setRecordCount(resultSet.getInt(1));
                }
                resultSet.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateContractLogonLast(int contractId, int n, String remoteAddr) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            if (n > -1) {
                query = "UPDATE contract_logon_last SET dt=now(), n=n+?, ip=? WHERE cid=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(index++, n);
                ps.setString(index++, remoteAddr);
                ps.setInt(index++, contractId);
                if (ps.executeUpdate() == 0) {
                    index = 1;
                    query = "INSERT INTO contract_logon_last SET cid=?, dt=now(), n=?, ip=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(index++, contractId);
                    ps.setInt(index++, n);
                    ps.setString(index++, remoteAddr);
                    ps.executeUpdate();
                }
                ps.close();
            } else {
                index = 1;
                query = "UPDATE contract_logon_last SET dt=now(), n=0, ip=? WHERE cid=?";
                ps = this.con.prepareStatement(query);
                ps.setString(index++, remoteAddr);
                ps.setInt(index++, contractId);
                if (ps.executeUpdate() == 0) {
                    index = 1;
                    query = "INSERT INTO contract_logon_last SET cid=?, dt=now(), n=0, ip=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(index++, contractId);
                    ps.setString(index++, remoteAddr);
                    ps.executeUpdate();
                }
                ps.close();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void deleteContractLogonLast(int contractId) {
        try {
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("DELETE FROM contract_logon_last WHERE cid=?");
            ps.setInt(1, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

