/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.action;

import bitel.billing.server.contract.object.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public class ActionAddressParamValueGet
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Element address = this.createElement(this.rootNode, "address");
        AddressStruct addressStruct = new AddressStruct();
        String selectedKey = null;
        int object = this.getIntParameter("object", -1);
        int param = this.getIntParameter("param", -1);
        if (object > -1 && param > -1) {
            String query = "SELECT address.hid, country.title as country, street.cityid as cityid, city.title as city, area.title as area, quarter.title as quarter, house.streetid as streetid, street.title as street, house.frac, house.box_index, house.house, address.pod, address.floor, address.flat, address.room, address.comment, address.format_key, address.address FROM object_param_value_address AS address LEFT JOIN address_house as house on address.hid=house.id LEFT JOIN address_area as area ON house.areaid=area.id LEFT JOIN address_quarter as quarter ON house.quarterid=quarter.id LEFT JOIN address_street as street ON house.streetid=street.id LEFT JOIN address_city as city ON street.cityid=city.id LEFT JOIN address_country as country ON city.country_id=country.id WHERE address.object_id=? AND address.param_id=? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, object);
            ps.setInt(2, param);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                address.setAttribute("hid", rs.getString("hid"));
                address.setAttribute("index", rs.getString("box_index"));
                address.setAttribute("cityid", rs.getString("cityid"));
                address.setAttribute("city", rs.getString("city"));
                address.setAttribute("area", rs.getString("area"));
                address.setAttribute("streetid", rs.getString("streetid"));
                address.setAttribute("quarter", rs.getString("quarter"));
                address.setAttribute("street", rs.getString("street"));
                address.setAttribute("comment", rs.getString("comment"));
                address.setAttribute("frac", rs.getString("frac"));
                address.setAttribute("house", rs.getInt("house") == 0 ? "" : rs.getString("house"));
                address.setAttribute("flat", rs.getString("flat"));
                address.setAttribute("room", rs.getString("room"));
                address.setAttribute("pod", rs.getInt("pod") == 0 ? "" : rs.getString("pod"));
                address.setAttribute("floor", rs.getInt("floor") == 0 ? "" : rs.getString("floor"));
                address.setAttribute("address", rs.getString("address"));
                selectedKey = rs.getString("format_key");
                addressStruct = this.getAddressStruct(rs);
            }
            rs.close();
            ps.close();
        }
        this.getFormatAddressTable(addressStruct, param, selectedKey, true);
        Element canCreate = this.createElement(address, "create");
        canCreate.setAttribute("value", this.setup.get("address.create", "no"));
    }

    private AddressStruct getAddressStruct(ResultSet rs) {
        AddressStruct result = new AddressStruct();
        try {
            result.setIndex(rs.getString("box_index"));
            result.setCountry(rs.getString("country"));
            result.setCity(rs.getString("city"));
            String area = rs.getString("area");
            result.setArea(area != null ? area : null);
            String quarter = rs.getString("quarter");
            result.setQuarter(quarter != null ? quarter : null);
            result.setStreet(rs.getString("street"));
            result.setHouse(String.valueOf(rs.getInt("house")));
            result.setFrac(rs.getString("frac"));
            result.setFlat(rs.getString("flat"));
            result.setRoom(rs.getString("room"));
            result.setPod(rs.getInt("pod") == 0 ? "" : rs.getString("pod"));
            result.setFloor(rs.getInt("floor") == 0 ? "" : rs.getString("floor"));
            result.setComment(rs.getString("comment"));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

