/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.action;

import bitel.billing.server.tariff.voice.action.base.ActionBase;
import bitel.billing.server.tariff.voice.bean.GeographicCode;
import bitel.billing.server.tariff.voice.bean.GeographicCodeManager;
import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;

public class ActionGeographicCodeTree
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int mapId = this.getIntParameter("map_id", 0);
        if (this.mid <= 0 || mapId <= 0) {
            throw new BGIllegalArgumentException();
        }
        GeographicCodeManager man = new GeographicCodeManager(this.con, this.mid);
        GeographicCode code = man.getRootCode(mapId);
        this.build(code, this.rootNode, this.rootNode.getOwnerDocument());
    }

    private void build(GeographicCode code, Element parent, Document doc) {
        List<GeographicCode> list;
        Element curr = doc.createElement("n");
        parent.appendChild(curr);
        curr.setAttribute("c", code.getCode());
        curr.setAttribute("t", code.getDest());
        if (code.getZoneId() > 0) {
            curr.setAttribute("z", code.getZone());
            curr.setAttribute("i", String.valueOf(code.getZoneId()));
        }
        if ((list = code.getSubList()) != null) {
            for (GeographicCode c : list) {
                this.build(c, curr, doc);
            }
        }
    }
}

