/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.bean;

import bitel.billing.server.tariff.voice.bean.TableManager;
import bitel.billing.server.tariff.voice.bean.ZoneMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ZoneMapManager {
    private Connection con;
    private int mid;
    private String tableName;

    public ZoneMapManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = TableManager.getTable(con, mid, "zone_map_");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void deleteMap(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMap(ZoneMap map) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = map.getId() <= 0 ? "INSERT INTO " + this.tableName + " (title,id) VALUES (?, ?)" : "UPDATE " + this.tableName + " SET title=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, map.getTitle());
            ps.setInt(2, map.getId());
            ps.executeUpdate();
            ps.close();
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ZoneMap> getZoneMapList() {
        ArrayList<ZoneMap> result = new ArrayList<ZoneMap>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getZoneMapFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ZoneMap getZoneMap(int id) {
        ZoneMap result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getZoneMapFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private ZoneMap getZoneMapFromRS(ResultSet rs) throws SQLException {
        ZoneMap map = new ZoneMap();
        map.setId(rs.getInt("id"));
        map.setTitle(rs.getString("title"));
        return map;
    }
}

