/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.groupaction.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class AddContractGroup
extends ContractGroupOperation.ContractGroupOperationItem {
    private BGControlPanelListSelect groups = new BGControlPanelListSelect();
    private JRadioButton add = new JRadioButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", true);
    private JRadioButton del = new JRadioButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", false);
    private JCheckBox showOnlyUsing = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435", false);
    private Document doc;

    public AddContractGroup() {
        super(new GridBagLayout());
    }

    protected void jbInit() throws Exception {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.add, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        buttonPanel.add((Component)this.del, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add.addActionListener(e -> {
            this.add.setSelected(this.add.isSelected());
            this.del.setSelected(!this.add.isSelected());
        });
        this.del.addActionListener(e -> {
            this.del.setSelected(this.del.isSelected());
            this.add.setSelected(!this.del.isSelected());
        });
        JPanel groupPanel = new JPanel(new GridBagLayout());
        groupPanel.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        groupPanel.setMinimumSize(new Dimension(180, 200));
        groupPanel.setPreferredSize(new Dimension(180, 200));
        groupPanel.add((Component)this.showOnlyUsing, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.showOnlyUsing.addActionListener(e -> {
            List<String> selectedItems = this.getSelectedIdList();
            this.getGroups(this.showOnlyUsing.isSelected());
            this.selectByIds(Utils.toString(selectedItems));
        });
        groupPanel.add((Component)this.groups, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(groupPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    protected void setData() {
        this.getGroups(this.showOnlyUsing.isSelected());
    }

    @Override
    protected boolean doItemOperation(String cids) {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("ContractGroupOperation");
        if (this.add.isSelected()) {
            req.setAttribute("type", "addToGroup");
        }
        if (this.del.isSelected()) {
            req.setAttribute("type", "deleteFromGroup");
        }
        req.setAttribute("cids", cids);
        ArrayList<CallSite> groupList = new ArrayList<CallSite>();
        DefaultListModel model = this.groups.getListModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ListItem item = (ListItem)model.elementAt(i);
            if (!item.isSelected()) continue;
            groupList.add((CallSite)((Object)("" + item.getAttribute("id"))));
        }
        req.setAttribute("mids", Utils.toString(groupList));
        return ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)req));
    }

    @Override
    protected String getOperationTitle() {
        return "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435/\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432 \u0433\u0440\u0443\u043f\u043f\u0443/\u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b";
    }

    private void getDocument() {
        Request req = new Request();
        req.setModule("admin");
        req.setAction("GetContractGroupList");
        this.doc = TransferManager.getDocument((Request)req);
    }

    private void getGroups(boolean enabled) {
        if (this.doc == null) {
            this.getDocument();
        }
        Element node = XMLUtils.selectElement((Node)this.doc, (String)"//table/data");
        DefaultListModel model = this.groups.getListModel();
        model.clear();
        if (node != null && node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                if (enabled && !"true".equals(XMLUtils.getAttribute((Element)item, (String)"f1", (String)"false"))) continue;
                String name = XMLUtils.getAttribute((Element)item, (String)"f2", null);
                String moduleId = XMLUtils.getAttribute((Element)item, (String)"f0", null);
                ListItem listItem = new ListItem(name, false);
                listItem.setAttribute("id", (Object)moduleId);
                model.addElement(listItem);
            }
        }
    }

    public List<String> getSelectedIdList() {
        return Utils.toList((String)this.groups.getListValues());
    }

    public void selectByIds(String sids) {
        this.groups.setListValues(sids);
    }
}

