/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.mail.common.bean.MailConfig;
import ru.bitel.bgbilling.kernel.admin.mail.common.dto.MailComponentDto;
import ru.bitel.bgbilling.kernel.admin.mail.common.dto.MailDto;
import ru.bitel.bgbilling.kernel.admin.mail.common.service.MailService;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailCache;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailConfigCache;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailConfigDao;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.mail.common.service.MailService")
public class MailServiceImpl
extends AbstractService
implements MailService {
    private List<String> keys = Arrays.asList("mail.smtp.host", "mail.smtp.port", "mail.smtp.user", "mail.smtp.auth", "mail.smtp.starttls.enable", "mail.smtp.submitter", "mail.smtp.localhost", "mail.smtp.connectiontimeout", "mail.smtp.timeout", "mail.smtp.writetimeout", "mail.smtp.ssl.enable", "mail.smtp.proxy.host", "mail.smtp.proxy.port", "mail.from.email", "mail.encoding", "mail.debug");

    @Override
    public List<MailComponentDto> mailComponentList() throws BGException, BGMessageException {
        return MailCache.getMailComponentList();
    }

    @Override
    public List<MailDto> mailList(String componentId) throws BGException, BGMessageException {
        List<MailData> mailDatas;
        if (componentId.matches("^\\d+$")) {
            componentId = ModuleCache.getInstance().getModule(Utils.parseInt((String)componentId)).getInstalledModule().getName();
        }
        if (Optional.ofNullable(mailDatas = MailCache.getMailList(componentId)).isPresent()) {
            return mailDatas.stream().map(MailData::toMailDto).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public MailConfig mailConfigGet(String componentId, int moduleId, String key) throws BGException, BGMessageException {
        MailConfig defaultMailConfig;
        MailConfig mailConfig = MailConfigCache.getMailConfig(componentId, moduleId, key);
        if (mailConfig == null) {
            mailConfig = new MailConfig();
            mailConfig.setComponentId(componentId);
            mailConfig.setModuleId(moduleId);
            mailConfig.setKey(key);
        }
        if ((defaultMailConfig = MailConfigCache.getMailConfig("default", 0, "default")) != null) {
            mailConfig.setPatternDefault(defaultMailConfig.getPatternCustom());
            mailConfig.setHandlerDefault(defaultMailConfig.getHandlerCustom());
        }
        return mailConfig;
    }

    @Override
    public void mailConfigUpdate(MailConfig mailConfig) throws BGException, BGMessageException {
        try (MailConfigDao mailConfigDao = new MailConfigDao(this.getConnection());){
            mailConfigDao.update(mailConfig);
            MailConfig defaultMailConfig = MailConfigCache.getMailConfig("default", 0, "default");
            if (defaultMailConfig == null) {
                defaultMailConfig = new MailConfig();
                defaultMailConfig.setComponentId("default");
                defaultMailConfig.setKey("default");
            }
            if (mailConfig.getPatternDefault() == null && defaultMailConfig.getPatternDefault() != null || mailConfig.getPatternDefault() != null && defaultMailConfig.getPatternDefault() == null || mailConfig.getPatternDefault() != null && defaultMailConfig.getPatternDefault() != null && !mailConfig.getPatternDefault().equals(defaultMailConfig.getPatternDefault())) {
                defaultMailConfig.setPatternCustom(mailConfig.getPatternDefault());
                mailConfigDao.update(defaultMailConfig);
            }
            if (mailConfig.getHandlerDefault() == null && defaultMailConfig.getHandlerDefault() != null || mailConfig.getHandlerDefault() != null && defaultMailConfig.getHandlerDefault() == null || mailConfig.getHandlerDefault() != null && defaultMailConfig.getHandlerDefault() != null && !mailConfig.getHandlerDefault().equals(defaultMailConfig.getHandlerDefault())) {
                defaultMailConfig.setHandlerCustom(mailConfig.getHandlerDefault());
                mailConfigDao.update(defaultMailConfig);
            }
            MailConfigCache.resetCache();
        }
    }

    @Override
    public List<KeyValue> configList() throws BGException, BGMessageException {
        Setup setup = Setup.getSetup();
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        this.keys.forEach(a -> values.add(new KeyValue(a, setup.get((String)a, ""))));
        return values;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configParamUpdate(KeyValue keyValue) throws BGException, BGMessageException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            ConfigData configData = configDAO.getActiveConfig(0);
            if (configData == null) {
                throw new BGMessageException("\u041a\u043e\u043d\u0444\u0438\u0433 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            boolean add = true;
            ArrayList<Object> list = new ArrayList<Object>();
            for (String string : configData.getConfig().split("\n")) {
                void var9_11;
                if (string.startsWith(keyValue.getKey() + "=")) {
                    add = false;
                    if (Utils.isBlankString((String)keyValue.getValue())) continue;
                    String string2 = keyValue.getKey() + "=" + keyValue.getValue();
                }
                list.add(var9_11);
            }
            if (add) {
                list.add(keyValue.getKey() + "=" + keyValue.getValue());
            }
            configData.setConfig(Utils.toString(list, (String)"\n"));
            configDAO.update((Object)configData);
            EventProcessor.getInstance().publishAfterCommit(new ModuleConfigModifiedEvent(0, this.userId));
        }
    }
}

