/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.web.client.WebMenuEditor;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.BGHandlerParameter;
import ru.bitel.common.model.IdTitle;

public class WebLimitManageConfig
extends BGUPanel {
    private WebMenuEditor webMenuEditor;
    private BGUComboBox<KeyValue> limitHandlers = new BGUComboBox();
    private ParamTableModel generalParamTableModel = new ParamTableModel();
    private GroupTableModel groupTableModel = new GroupTableModel();
    private ParamTableModel groupParamTableModel = new ParamTableModel();

    public WebLimitManageConfig(WebMenuEditor webMenuEditor) {
        this.webMenuEditor = webMenuEditor;
    }

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getGeneralPanel(), (Component)this.getGroupPanel(), 800L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
    }

    private JPanel getGeneralPanel() {
        this.limitHandlers.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.loadHandlerData(((KeyValue)this.limitHandlers.getSelectedItem()).getKey());
            }
        });
        BGUTable table = new BGUTable((TableModel)((Object)this.generalParamTableModel));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 3, 0, 3), 0, 0));
        panel.add((Component)this.limitHandlers, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 3, 3, 3), 0, 0));
        panel.add((Component)new JLabel("\u041e\u0431\u0449\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getGroupPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.groupParamTableModel));
        table.setSelectionMode(0);
        BGUTable groupTable = new BGUTable((TableModel)((Object)this.groupTableModel));
        groupTable.setSelectionMode(0);
        groupTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    String groupKey = (String)WebLimitManageConfig.this.groupTableModel.getSelectedRow();
                    String className = ((KeyValue)WebLimitManageConfig.this.limitHandlers.getSelectedItem()).getKey();
                    WebLimitManageConfig.this.groupParamTableModel.setData(WebLimitManageConfig.this.webMenuEditor.getWebService().webLimitHandlerGroupParameters(className, groupKey));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getGroupLabelPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 3, 0, 3), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)groupTable, (int)300, (int)200), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 3, 0, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getGroupLabelPanel() {
        BGToolBar toolBar = new BGToolBar();
        toolBar.add((Action)new BGUAction("addGroup", "\u0421\u043f\u0438\u0441\u043e\u043a", ClientUtils.getIcon((String)"add")){

            public void actionPerformed(ActionEvent e) {
                if (((KeyValue)WebLimitManageConfig.this.limitHandlers.getSelectedItem()).getKey().isEmpty()) {
                    return;
                }
                BGTitleEditorDialog<IdTitle> bgTitleEditorDialog = new BGTitleEditorDialog<IdTitle>("\u041a\u043b\u044e\u0447 \u043d\u043e\u0432\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b", new IdTitle()){

                    protected void doUpdate() throws Exception {
                        WebLimitManageConfig.this.groupTableModel.addRow(((IdTitle)this.data).getTitle());
                    }
                };
                bgTitleEditorDialog.getDialog().setVisible(true);
            }
        });
        toolBar.add((Action)new BGUAction("delGroup", "\u0421\u043f\u0438\u0441\u043e\u043a", ClientUtils.getIcon((String)"delete")){

            public void actionPerformed(ActionEvent e) {
                if (((KeyValue)WebLimitManageConfig.this.limitHandlers.getSelectedItem()).getKey().isEmpty()) {
                    return;
                }
                String groupKey = (String)WebLimitManageConfig.this.groupTableModel.getSelectedRow();
                if (groupKey == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443");
                    return;
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        return panel;
    }

    private void loadHandlerData(String className) {
        try {
            this.generalParamTableModel.setData(this.webMenuEditor.getWebService().webLimitHandlerGeneralParameters(className));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List<KeyValue> list = WebLimitManageConfig.this.webMenuEditor.getWebService().webLimitHandlers();
                list.add(0, new KeyValue("", "=== \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d ==="));
                WebLimitManageConfig.this.limitHandlers.setData(list);
            }
        };
    }

    class ParamTableModel
    extends BGTableModel<BGHandlerParameter> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 300, 400, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 200, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class GroupTableModel
    extends BGTableModel<String> {
        public GroupTableModel() {
            super(GroupTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043b\u044e\u0447 \u0433\u0440\u0443\u043f\u043f\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432", 100, 200, -1, "groupKey", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(String val, int column) throws BGException {
            return val;
        }
    }
}

