/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.common.VersionInfo;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.update.server.LibInfo;
import ru.bitel.bgbilling.kernel.update.server.LibInfoUtil;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

@WebServlet(name="ClientUpdate", urlPatterns={"/clientUpdate/*"})
public class ClientUpdate
extends HttpServlet {
    private Setup setup = null;
    private static final Logger logger = LogManager.getLogger();

    public void init() throws ServletException {
        super.init();
        logger.info("init()");
        this.setup = Setup.getSetup();
        LibInfoUtil.getClientLibInfos();
        UserMap.initUserMap();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String unencoded;
        String[] userPass;
        String userName = request.getParameter("userName");
        String userPassword = request.getParameter("userPassword");
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic ") && (userPass = (unencoded = Base64.decode((String)(authorization = authorization.substring(6).trim()), (String)"UTF-8")).split(":")).length > 1) {
            try {
                userName = userPass[0];
                userPassword = userPass[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String appsType = request.getParameter("appsType");
        String[] libNames = request.getParameterValues("libName");
        if (userName != null) {
            if (userPassword != null) {
                userPassword = Utils.getDigest((String)userPassword, (String)"UTF-8");
            }
            String auth = "Error";
            String message = null;
            boolean needChangePassword = false;
            for (User user : UserMap.getMap().values()) {
                if (user.getId() <= 0 || !user.getLogin().equalsIgnoreCase(userName)) continue;
                if (user.getPassword().equals(userPassword)) {
                    auth = "Ok";
                    String newUserPassword = request.getParameter("newUserPassword");
                    if (user.isNeedChangePassword() && newUserPassword != null) {
                        user.setPassword(Utils.getDigest((String)newUserPassword, (String)"utf-8"));
                        user.setNeedChangePassword(false);
                        try (Connection connection = Setup.getSetup().getDBConnectionFromPool();
                             UserManager userManager = new UserManager(connection);){
                            userManager.update((Object)user);
                            UserMap.initUserMap(connection);
                        }
                        catch (Exception e2) {
                            logger.error((Object)e2);
                        }
                    }
                    needChangePassword = user.isNeedChangePassword();
                    break;
                }
                message = String.format("%s [%s] \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438, \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c", userName, ServletUtils.getIpFromHeader(request, this.setup));
                break;
            }
            if ("Error".equals(auth)) {
                if (message == null) {
                    message = String.format("%s [%s] \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438, \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", userName, ServletUtils.getIpFromHeader(request, this.setup));
                }
                logger.warn(message);
            }
            response.setContentType("text/plain;charset=UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
            writer.write("auth=" + auth + "\n");
            if (needChangePassword) {
                writer.write("need.change.password=true\n");
            }
            if ("Ok".equals(auth)) {
                writer.write("version=" + Setup.getSetup().get("bg.client.version") + "\n");
                for (LibInfo libInfo : LibInfoUtil.getClientLibInfos().values()) {
                    writer.write("lib=" + libInfo.getName() + "\t" + libInfo.getHash() + "\n");
                }
            }
            try {
                URI uRI = ClassLoader.getSystemResource("runner").toURI();
                File libsDir = new File(uRI);
                if (libsDir.exists() && libsDir.isDirectory()) {
                    for (File file : libsDir.listFiles()) {
                        if (!file.isFile() || !file.getName().startsWith("runner_")) continue;
                        writer.write("runner.version=" + file.getName().substring(7, 17) + "\n");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            VersionInfo versionInfo = VersionInfo.getVersionInfo((String)"~");
            writer.write("billing.version=" + versionInfo.getVersion() + "\n");
            writer.flush();
            writer.close();
            return;
        }
        if (Boolean.valueOf(request.getParameter("updateRunner")).booleanValue()) {
            response.setContentType("application/octet-stream");
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                URI runnerDir = ClassLoader.getSystemResource("runner").toURI();
                File libsDir = new File(runnerDir);
                if (!libsDir.exists() || !libsDir.isDirectory()) return;
                for (File file : libsDir.listFiles()) {
                    if (!file.isFile() || !file.getName().startsWith("runner_")) continue;
                    FileInputStream inputStream = new FileInputStream(file);
                    outputStream.write(this.longToBytes(Long.parseLong(file.getName().substring(7, 17))));
                    outputStream.write(this.longToBytes(file.length()));
                    Utils.flush((InputStream)inputStream, (OutputStream)outputStream);
                    inputStream.close();
                }
                return;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                return;
            }
        }
        if ("getAppsLibInfos".equals(request.getParameter("action"))) {
            if (!this.checkAppsType(appsType, response)) {
                return;
            }
            List<LibInfo> libInfos = LibInfoUtil.getAppsLibInfos().get(appsType);
            if (libInfos != null && libInfos.stream().anyMatch(e -> e.getHash() == null)) {
                try {
                    String libDir = System.getProperty("lib.dir");
                    File dir = libDir == null ? new File(ClientUpdate.class.getResource("/").toURI()) : new File(libDir);
                    ArrayList<File> files = new ArrayList<File>();
                    files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "apps").listFiles()));
                    files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "common").listFiles()));
                    files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "server").listFiles()));
                    files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "ext" + File.separatorChar + "common").listFiles()));
                    files.addAll(Arrays.asList(new File(dir, "lib" + File.separatorChar + "ext" + File.separatorChar + "server").listFiles()));
                    block24: for (LibInfo libInfo : libInfos) {
                        for (File file : files) {
                            String fileName = file.getName();
                            if (!fileName.endsWith(".jar") || !fileName.startsWith(libInfo.getName())) continue;
                            libInfo.setFile(file);
                            libInfo.setHash(LibInfoUtil.sha256Hex(file.getPath()));
                            continue block24;
                        }
                    }
                }
                catch (URISyntaxException e1) {
                    libInfos = null;
                }
                if (libInfos != null) {
                    StringBuffer buffer = new StringBuffer();
                    libInfos.forEach(e -> {
                        if (e.getHash() == null) {
                            buffer.append(e.getFile()).append("\n");
                        }
                    });
                    if (buffer.length() > 0) {
                        logger.error("######################## \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d\u042b \u0424\u0410\u0419\u041b\u042b \u0411\u0418\u0411\u041b\u0418\u041e\u0422\u0415\u041a ########################\n" + buffer.toString() + "############################################################################");
                    }
                }
            }
            response.setContentType("text/plain;charset=UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
            if (libInfos != null) {
                for (LibInfo libInfo : libInfos) {
                    writer.write(libInfo.getType() + "\t" + libInfo.getName() + "\t" + Utils.maskBlank((String)libInfo.getHash(), (String)"\u041e\u0422\u0421\u0423\u0422\u0421\u0422\u0412\u0423\u0415\u0422 \u041d\u0410 \u0421\u0415\u0420\u0412\u0415\u0420\u0415") + "\n");
                }
            }
            writer.flush();
            writer.close();
            return;
        }
        if (Boolean.valueOf(request.getParameter("updateFilesDat")).booleanValue()) {
            response.setContentType("text/plain;charset=UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
            writer.write(Files.readString(Paths.get("data", "files.dat")));
            writer.flush();
            writer.close();
            return;
        } else if ("getAppsLibs".equals(request.getParameter("action"))) {
            void var12_42;
            if (!this.checkAppsType(appsType, response)) {
                return;
            }
            if (libNames == null) return;
            response.setContentType("application/octet-stream");
            ServletOutputStream outputStream = response.getOutputStream();
            HashMap libInfoMap = new HashMap();
            LibInfoUtil.getAppsLibInfos().get(appsType).forEach(e -> libInfoMap.put(e.getType() + "*" + e.getName(), e));
            String[] stringArray = libNames;
            int n = stringArray.length;
            boolean bl = false;
            while (var12_42 < n) {
                LibInfo libInfo;
                String libName = stringArray[var12_42];
                if (libInfoMap.containsKey(libName) && (libInfo = (LibInfo)libInfoMap.get(libName)).getHash() != null) {
                    byte[] bytes = libInfo.getType().getBytes("UTF-8");
                    outputStream.write(bytes.length);
                    outputStream.write(bytes);
                    bytes = libInfo.getName().getBytes("UTF-8");
                    outputStream.write(bytes.length);
                    outputStream.write(bytes);
                    long length = libInfo.getFile().length();
                    outputStream.write(this.longToBytes(length));
                    int b = 0;
                    bytes = new byte[1024];
                    FileInputStream fileInputStream = new FileInputStream(libInfo.getFile());
                    while ((b = fileInputStream.read(bytes)) > -1) {
                        outputStream.write(bytes, 0, b);
                    }
                    fileInputStream.close();
                }
                ++var12_42;
            }
            outputStream.flush();
            outputStream.close();
            return;
        } else {
            if (libNames == null) return;
            response.setContentType("application/octet-stream");
            ServletOutputStream outputStream = response.getOutputStream();
            for (String string : libNames) {
                LibInfo libInfo = LibInfoUtil.getClientLibInfos().get(string);
                if (libInfo == null) continue;
                byte[] bytes = string.getBytes("UTF-8");
                outputStream.write(bytes.length);
                outputStream.write(bytes);
                String hash = libInfo.getHash();
                bytes = hash.getBytes("UTF-8");
                outputStream.write(bytes.length);
                outputStream.write(bytes);
                long length = libInfo.getFile().length();
                outputStream.write(this.longToBytes(length));
                int b = 0;
                bytes = new byte[1024];
                FileInputStream fileInputStream = new FileInputStream(libInfo.getFile());
                while ((b = fileInputStream.read(bytes)) > -1) {
                    outputStream.write(bytes, 0, b);
                }
                fileInputStream.close();
            }
            outputStream.flush();
            outputStream.close();
        }
    }

    private boolean checkAppsType(String appsType, HttpServletResponse response) throws IOException {
        if (appsType == null) {
            response.setContentType("text/plain;charset=UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
            writer.write("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 appsType, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
            writer.flush();
            writer.close();
            return false;
        }
        return true;
    }

    private byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static void main(String[] args) {
        List<LibInfo> libInfos = LibInfoUtil.getAppsLibInfos().get("inet");
        if (libInfos != null && libInfos.stream().anyMatch(e -> e.getHash() == null)) {
            try {
                File dir = new File(ClientUpdate.class.getResource("/").toURI());
                for (LibInfo libInfo : libInfos) {
                    File file = new File(dir, "lib" + File.separatorChar + libInfo.getType() + File.separatorChar + libInfo.getName());
                    libInfo.setFile(file);
                    libInfo.setHash(LibInfoUtil.sha256Hex(file.getPath()));
                }
            }
            catch (URISyntaxException e1) {
                libInfos = null;
            }
        }
    }
}

