/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.server.Action;
import bitel.billing.server.ActionResultContentType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionHandler;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebServlet(name="pubexecuter", urlPatterns={"/pubexecuter/*"})
public class PublicExecuter
extends CommonExecutor {
    @Override
    public void init() {
        this.setup = Setup.getSetup();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String l = request.getParameter("l");
        if (this.redirectByPath(request, response)) {
            return;
        }
        if ("DoTransaction".equals(l)) {
            response.sendRedirect("pubexecuter?action=DoTransaction&module=contract.function");
            return;
        }
        if ("AccessRestore".equals(l)) {
            response.sendRedirect("pubexecuter?action=AccessRestore&module=contract.function");
            return;
        }
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block12: {
            request.setAttribute("setup", (Object)this.setup);
            request.setAttribute("response", (Object)response);
            request.setAttribute("contextPath", (Object)this.setup.get("context.path", "/bgbilling"));
            request.setAttribute("year", (Object)new GregorianCalendar().get(1));
            PublicExecuter.rememberBackUrl(request);
            try {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootNode = doc.createElement("data");
                rootNode.setAttribute("status", "ok");
                rootNode.setAttribute("contextPath", this.setup.get("context.path", "/bgbilling"));
                doc.appendChild(rootNode);
                request.setAttribute("rootNode", (Object)rootNode);
                String contentType = PublicExecuter.getRequestParameters(ActionResultContentType.jsp.toString(), request, "contentType", "ct");
                request.setAttribute("contentType", (Object)contentType);
                this.doModule(request, response, rootNode);
                contentType = (String)request.getAttribute("contentType");
                if (request.getParameter("debug") != null) {
                    System.out.println(XMLUtils.serializeToString((Node)doc, (boolean)false));
                }
                if ("xml".equals(contentType)) {
                    this.sendXmlWithXSLTInstuction(request, response, doc, rootNode.getAttribute("xslt"));
                    break block12;
                }
                if ("jsp".equals(contentType)) {
                    String page = (String)request.getAttribute("page");
                    request.getRequestDispatcher("/WEB-INF/jspf/" + (page != null ? page : "pubcontent.jsp")).forward((ServletRequest)request, (ServletResponse)response);
                    break block12;
                }
                if ("json".equals(contentType)) {
                    try {
                        response.setContentType("application/json; charset=UTF-8");
                        response.getWriter().print(((JSONObject)request.getAttribute("json")).toString());
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                    break block12;
                }
                if (!"html".equals(contentType)) break block12;
                String xslt = rootNode.getAttribute("xslt");
                if (Utils.isEmptyString((String)xslt)) {
                    PrintWriter out = response.getWriter();
                    try {
                        out.write("<html>Error: XSLT file - not specified.</html>");
                        break block12;
                    }
                    finally {
                        out.flush();
                        out.close();
                    }
                }
                rootNode.setAttribute("year", String.valueOf(new GregorianCalendar().get(1)));
                this.xslManager.transform(response, xslt, new DOMSource(doc), null, "text/html", null, false);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doModule(HttpServletRequest request, HttpServletResponse response, Element rootNode) throws Exception {
        block15: {
            String module;
            String action = request.getParameter("action");
            if (Utils.isEmptyString((String)action)) {
                action = "Navigation";
            }
            if ((module = request.getParameter("module")) == null) {
                module = "admin.navigation";
                rootNode.setAttribute("status", "error");
                rootNode.appendChild(rootNode.getOwnerDocument().createTextNode("module=null"));
            }
            String className = "Action" + action.substring(0, 1).toUpperCase() + action.substring(1);
            Class<?> actionClazz = this.findAction(module, "pub.", className);
            Action actionInstance = null;
            if (actionClazz == null) {
                request.setAttribute("jspPage", (Object)"include/error.jsp");
            } else if (Action.class.isAssignableFrom(actionClazz)) {
                try {
                    actionInstance = actionClazz.asSubclass(Action.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (actionInstance != null) {
                        try {
                            actionInstance.init(this.setup, rootNode, request, response, this.servletContext);
                            actionInstance.doAction();
                            break block15;
                        }
                        catch (Exception ex) {
                            PublicExecuter.setErrorStatus(request, rootNode, ex.getLocalizedMessage());
                            ex.printStackTrace();
                            break block15;
                        }
                        finally {
                            actionInstance.commit();
                            actionInstance.freeConnection();
                        }
                    }
                    logger.warn("Action NOT FOUND ! module:" + module + " class: " + className);
                }
                catch (Exception ex) {}
            } else if (AbstractAction.class.isAssignableFrom(actionClazz)) {
                Object webMode = null;
                new ActionHandler().handle(actionClazz.asSubclass(AbstractAction.class), this.setup, webMode, ActionResultContentType.jsp.isEquals((Object)webMode) ? null : rootNode, request, response, this.servletContext, 0, -1);
            }
        }
    }
}

