/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;

public class ContractParameterTableModel
extends BGTableModel<Map<String, Object>> {
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_READ = "read";
    private static final String COLUMN_WRITE = "write";
    private static final String COLUMN_TITLE = "title";
    private static final String RULE_DEFAULT = "\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";
    private static final String RULE_ON = "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e";
    private static final String RULE_OFF = "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e";
    final char[] CODES = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'};
    CellRender cellReadRender;
    CellRender cellWriteRender;

    public ContractParameterTableModel(String name) {
        super(name);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String identifier = this.getIdentifier(columnIndex);
        return COLUMN_READ.equals(identifier) || COLUMN_WRITE.equals(identifier);
    }

    protected void initColumns() {
        this.cellReadRender = new CellRender();
        this.cellWriteRender = new CellRender();
        this.addColumnId();
        this.addColumn("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440", 120, 120, 120, COLUMN_READ, true).setTableCellRenderer((TableCellRenderer)this.cellReadRender);
        this.addColumn("\u041f\u0440\u0430\u0432\u043a\u0430", 120, 120, 120, COLUMN_WRITE, true).setTableCellRenderer((TableCellRenderer)this.cellWriteRender);
        this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, COLUMN_TITLE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
    }

    public void setData(JSONArray rows) {
        ArrayList rowsData = new ArrayList();
        for (int index = 0; index < rows.length(); ++index) {
            JSONObject jsonObject = rows.getJSONObject(index);
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            rowData.put(COLUMN_ID, Utils.parseInt((String)jsonObject.getString(COLUMN_ID)));
            rowData.put(COLUMN_READ, 0);
            rowData.put(COLUMN_WRITE, 0);
            rowData.put(COLUMN_TITLE, jsonObject.getString(COLUMN_TITLE));
            rowsData.add(rowData);
        }
        this.setData(rowsData);
    }

    public void setData(Iterable<Element> rows) {
        ArrayList rowsData = new ArrayList();
        for (Element rowElement : rows) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            rowData.put(COLUMN_ID, Utils.parseInt((String)rowElement.getAttribute(COLUMN_ID)));
            rowData.put(COLUMN_READ, 0);
            rowData.put(COLUMN_WRITE, 0);
            rowData.put(COLUMN_TITLE, rowElement.getAttribute(COLUMN_TITLE));
            rowsData.add(rowData);
        }
        this.setData(rowsData);
    }

    public void setDefault(int defaultRead, int defaultWrite) {
        this.cellReadRender.setDefaultRule(defaultRead);
        this.cellWriteRender.setDefaultRule(defaultWrite);
    }

    public String getValues() {
        StringBuilder pids = new StringBuilder();
        for (Map rowMap : this.getRows()) {
            int rule = 0;
            Integer read = (Integer)rowMap.get(COLUMN_READ);
            Integer write = (Integer)rowMap.get(COLUMN_WRITE);
            if (read != null && write != null) {
                rule = (read & 3) << 2 | write & 3;
            }
            if (rule <= 0) continue;
            if (pids.length() > 0) {
                pids.append(",");
            }
            pids.append((Integer)rowMap.get(COLUMN_ID)).append(this.CODES[rule]);
        }
        return pids.toString();
    }

    public void setValues(List<String> rules) {
        for (Map rowMap : this.getRows()) {
            rowMap.put(COLUMN_READ, 0);
            rowMap.put(COLUMN_WRITE, 0);
        }
        block1: for (String rule : rules) {
            int pid = Utils.parseInt((String)rule.substring(0, rule.length() - 1));
            char code = rule.charAt(rule.length() - 1);
            int read = 0;
            int write = 0;
            for (int index = 0; index < this.CODES.length; ++index) {
                if (this.CODES[index] != code) continue;
                read = (index & 0xC) >> 2;
                write = index & 3;
                break;
            }
            for (Map rowMap : this.getRows()) {
                int id = (Integer)rowMap.get(COLUMN_ID);
                if (pid != id) continue;
                rowMap.put(COLUMN_READ, read);
                rowMap.put(COLUMN_WRITE, write);
                continue block1;
            }
        }
        this.fireTableDataChanged();
    }

    public String[] getUserEditerItems() {
        return new String[]{RULE_DEFAULT, RULE_ON, RULE_OFF};
    }

    public String[] getGroupEditerItems() {
        return new String[]{RULE_DEFAULT, RULE_ON, RULE_OFF};
    }

    class CellRender
    extends DefaultTableCellRenderer {
        private int defaultRule = 1;
        Font font = new Font("SansSerif", 1, 12);

        CellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String valueString = value.toString();
            if ("0".equals(valueString)) {
                if (this.defaultRule == 2) {
                    this.setValue(ContractParameterTableModel.RULE_OFF);
                } else {
                    this.setValue(ContractParameterTableModel.RULE_ON);
                }
                this.setForeground(Color.LIGHT_GRAY);
            } else if ("1".equals(valueString)) {
                this.setForeground(Color.GREEN);
                this.setFont(this.font);
                this.setValue(ContractParameterTableModel.RULE_ON);
            } else if ("2".equals(valueString)) {
                this.setForeground(Color.RED);
                this.setFont(this.font);
                this.setValue(ContractParameterTableModel.RULE_OFF);
            } else if ("3".equals(valueString)) {
                this.setForeground(Color.BLUE);
                this.setFont(this.font);
            }
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            return this;
        }

        public void setDefaultRule(int defaultRule) {
            this.defaultRule = defaultRule;
        }
    }
}

