/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.PermissionKitItem;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSActionGroupDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class PermissionKitDao
extends AbstractIdDao<PermissionKit> {
    public PermissionKitDao(Connection con) {
        super(con, 0, "permission_kit");
    }

    public List<PermissionKit> getList() throws BGException {
        return this.list(null, null, new Object[0]);
    }

    public List<IdTitle> getKitItems() throws BGException {
        ArrayList<IdTitle> items = new ArrayList<IdTitle>();
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT id, title FROM " + this.tableName + " ORDER BY title");){
            while (rs.next()) {
                items.add(new IdTitle(rs.getInt("id"), rs.getString("title")));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return items;
    }

    public List<PermissionKit> getByIds(String ids) throws BGException {
        ArrayList<PermissionKit> result = new ArrayList<PermissionKit>();
        if (Utils.isBlankString((String)ids)) {
            return result;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + ids + ")";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<PermissionKitItem> getPermissionKitItems() throws BGException {
        ArrayList<PermissionKitItem> items = new ArrayList<PermissionKitItem>();
        String queryKit = "SELECT id, title, description, bgs_action_ids, bgs_group_action_ids FROM " + this.tableName;
        String queryRole = "SELECT permission_kit_ids FROM role";
        try (Statement statement = this.con.createStatement();){
            try (ResultSet rs1 = statement.executeQuery(queryKit);){
                while (rs1.next()) {
                    items.add(PermissionKitItem.builder().setId(rs1.getInt("id")).setTitle(rs1.getString("title")).setActionCount(Utils.toList((String)rs1.getString("bgs_action_ids")).size()).setActionGroupCount(Utils.toList((String)rs1.getString("bgs_group_action_ids")).size()).setDescription(rs1.getString("description")).build());
                }
            }
            try (ResultSet rs2 = statement.executeQuery(queryRole);){
                while (rs2.next()) {
                    List kitIds = Utils.toIntegerList((String)rs2.getString(1));
                    items.forEach(a -> a.setRoleCount(a.getRoleCount() + (kitIds.contains(a.getId()) ? 1 : 0)));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return items;
    }

    protected PermissionKit getFromRS(ResultSet rs) throws SQLException, BGException {
        try (BGSActionGroupDao bgsActionGroupDao = new BGSActionGroupDao(this.con);){
            PermissionKit permissionKit = new PermissionKit();
            permissionKit.setId(rs.getInt("id"));
            permissionKit.setTitle(rs.getString("title"));
            permissionKit.setContractLabels(Utils.toIntegerList((String)rs.getString("contract_labels")));
            permissionKit.setDomenIds(Utils.toIntegerList((String)rs.getString("domens")));
            permissionKit.setActions(this.getBGSActions(rs.getString("bgs_action_ids")));
            permissionKit.setActionGroups(bgsActionGroupDao.getByIds(rs.getString("bgs_group_action_ids")));
            permissionKit.setContractObjects(Utils.toList((String)rs.getString("contract_objects")));
            permissionKit.setDescription(rs.getString("description"));
            Pattern pattern = Pattern.compile("^\\d+$");
            List pids = Utils.toList((String)rs.getString("pids"));
            for (int index = 0; index < pids.size(); ++index) {
                if (!pattern.matcher((CharSequence)pids.get(index)).matches()) continue;
                pids.set(index, ((String)pids.get(index)).concat("C"));
            }
            permissionKit.setPids(pids);
            PermissionKit permissionKit2 = permissionKit;
            return permissionKit2;
        }
    }

    private List<BGSAction> getBGSActions(String actions) {
        ArrayList<BGSAction> actionList = new ArrayList<BGSAction>();
        if (Utils.isBlankString((String)actions)) {
            return actionList;
        }
        for (String action : Utils.toList((String)actions, (String)",")) {
            String[] mas = action.split("_");
            BGSAction bgsAction = new BGSAction();
            bgsAction.mid = mas[0];
            bgsAction.actionID = Utils.parseInt((String)mas[1].replaceAll(",", ""), (int)0);
            actionList.add(bgsAction);
        }
        return actionList;
    }

    protected void updateImpl(PermissionKit permissionKit) throws BGException, SQLException {
        String query;
        if (permissionKit == null) {
            return;
        }
        String set = " SET title=?, contract_labels=?, domens=?, bgs_action_ids=?, bgs_group_action_ids=?, pids=?, contract_objects=?, description=?";
        String string = query = permissionKit.getId() > 0 ? "UPDATE " + this.tableName + set : "INSERT INTO " + this.tableName + set;
        if (permissionKit.getId() > 0) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, permissionKit.getTitle());
            ps.setString(index++, Utils.toString(permissionKit.getContractLabels(), (String)","));
            ps.setString(index++, Utils.toString(permissionKit.getDomenIds(), (String)","));
            ps.setString(index++, this.bgsActionsToString(permissionKit.getActions()));
            String actionGroups = permissionKit.getActionGroups() == null ? "" : Utils.toString((Iterable)permissionKit.getActionGroups().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()), (String)",");
            ps.setString(index++, actionGroups);
            ps.setString(index++, Utils.toString(permissionKit.getPids()));
            ps.setString(index++, Utils.toString(permissionKit.getContractObjects()));
            ps.setString(index++, Utils.maskBlank((String)permissionKit.getDescription(), (String)""));
            if (permissionKit.getId() > 0) {
                ps.setInt(index, permissionKit.getId());
            }
            ps.executeUpdate();
            if (permissionKit.getId() <= 0) {
                permissionKit.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private String bgsActionsToString(List<BGSAction> actionList) {
        if (Utils.isEmptyCollection(actionList)) {
            return "";
        }
        StringBuilder actions = new StringBuilder();
        for (int i = 0; i < actionList.size(); ++i) {
            BGSAction action = actionList.get(i);
            actions.append(action.mid).append("_").append(action.actionID);
            if (i == actionList.size() - 1) continue;
            actions.append(",");
        }
        return actions.toString();
    }
}

