/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.PermissionKitItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UnregRequestRecord;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.bgsecure.server.UserActionRecorderCache;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSActionGroupDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.PermissionKitDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.RequestRecordLogDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.RoleDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserRecordLogDao;
import ru.bitel.bgbilling.kernel.container.security.server.FindAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSActionGroup;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.module.common.event.PermissionKitUpdateEvent;
import ru.bitel.bgbilling.kernel.module.common.event.RoleUpdateEvent;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService")
public class RoleServiceImpl
extends AbstractService
implements RoleService {
    private final Logger logger = LogManager.getLogger();
    private RoleDao roleDao;
    private PermissionKitDao permissionKitDao;
    private BGSActionGroupDao actionGroupDao;

    @PostConstruct
    public void init() {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException exception) {
            this.logger.error(exception.getMessage());
        }
        this.roleDao = new RoleDao(connection);
        this.permissionKitDao = new PermissionKitDao(connection);
        this.actionGroupDao = new BGSActionGroupDao(connection);
    }

    @Override
    public List<Role> getRoles() throws BGException {
        return this.roleDao.list(null, null, new Object[0]);
    }

    @Override
    public List<RoleItem> getRoleItems(boolean initChilds, boolean sortByTitle) throws BGException {
        List<RoleItem> roleItems = this.roleDao.roleItemList(initChilds);
        if (sortByTitle) {
            Collections.sort(roleItems, Comparator.comparing(IdTitle::getTitle, String::compareTo));
        }
        return roleItems;
    }

    @Override
    public Role getByRoleId(int roleId) throws BGException {
        return (Role)this.roleDao.get(roleId);
    }

    @Override
    public void updateRole(Role role) throws BGException {
        this.roleDao.update((Object)role);
        EventProcessor.getInstance().request(new RoleUpdateEvent(role.getId(), this.userId));
    }

    @Override
    public void deleteRole(Role role) throws BGException {
        if (role == null) {
            return;
        }
        this.deleteRoleById(role.getId());
    }

    @Override
    public void deleteRoleById(int roleId) throws BGException {
        ArrayList users = new ArrayList();
        UserMap.getMap().values().forEach(user -> {
            if (user.getRoleId() == roleId) {
                users.add(user.getTitle());
            }
        });
        if (!users.isEmpty()) {
            Object errorMessage = "\u0420\u043e\u043b\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439: ";
            errorMessage = (String)errorMessage + (users.size() > 0 ? (String)users.get(0) : "");
            errorMessage = (String)errorMessage + (String)(users.size() > 1 ? "; " + (String)users.get(1) : "");
            errorMessage = (String)errorMessage + (String)(users.size() > 2 ? "; ( \u0435\u0449\u0435 +" + (users.size() - 2) : "");
            throw new BGMessageException((String)errorMessage);
        }
        this.roleDao.delete(roleId);
        EventProcessor.getInstance().request(new RoleUpdateEvent(roleId, this.userId));
    }

    @Override
    public List<BGSActionGroup> getBGSActionGroups() throws BGException {
        return this.actionGroupDao.getList();
    }

    @Override
    public void updateBGSActionGroup(BGSActionGroup group) throws BGException {
        this.actionGroupDao.update((Object)group);
        EventProcessor.getInstance().request(new RoleUpdateEvent(-1, this.userId));
    }

    @Override
    public void deleteBGSActionGroup(BGSActionGroup group) throws BGException {
        this.actionGroupDao.delete(group.getId());
    }

    @Override
    public List<IdTitle> getKitItems() throws BGException, BGMessageException {
        return this.permissionKitDao.getKitItems();
    }

    @Override
    public List<PermissionKitItem> getPermissionKitItems() throws BGException, BGMessageException {
        return this.permissionKitDao.getPermissionKitItems();
    }

    @Override
    public PermissionKit getByKitId(int kitId) throws BGException {
        return (PermissionKit)this.permissionKitDao.get(kitId);
    }

    @Override
    public int updatePermissionKit(PermissionKit kit) throws BGException {
        this.permissionKitDao.update((Object)kit);
        EventProcessor.getInstance().request(new PermissionKitUpdateEvent(kit.getId(), this.getRolesIdsContainsKit(kit.getId()), this.userId, PermissionKitUpdateEvent.EventType.UPDATE));
        return kit.getId();
    }

    @Override
    public void deletePermissionKit(int permissionKitId) throws BGException {
        List<Role> rolesWithKit = this.getRolesContainsKit(permissionKitId);
        for (Role role : rolesWithKit) {
            role.getPermissionKits().removeIf(kit -> kit.getId() == permissionKitId);
            this.updateRole(role);
        }
        this.permissionKitDao.delete(permissionKitId);
        EventProcessor.getInstance().request(new PermissionKitUpdateEvent(permissionKitId, rolesWithKit.stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()), this.userId, PermissionKitUpdateEvent.EventType.DELETE));
    }

    @Override
    public int checkRoleContainsKit(int permissionKitId) throws BGException, BGMessageException {
        return this.getRolesContainsKit(permissionKitId).size();
    }

    private List<Integer> getRolesIdsContainsKit(int permissionKitId) throws BGException {
        return this.getRolesContainsKit(permissionKitId).stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
    }

    private List<Role> getRolesContainsKit(int permissionKitId) throws BGException {
        return this.getRoles().stream().filter(r -> r.getPermissionKits() != null && r.getPermissionKits().stream().filter(kit -> kit.getId() == permissionKitId).collect(Collectors.toList()).size() > 0).collect(Collectors.toList());
    }

    @Override
    public SearchResult<UnregRequestRecord> searchUnregRequestRecordList(Page page) throws BGException, BGMessageException {
        try (UserRecordLogDao userRecordLogDao = new UserRecordLogDao(this.getConnection());){
            HashMap componentMap = new HashMap();
            ModuleService moduleService = this.context.getService(ModuleService.class, 0);
            moduleService.moduleList().forEach(a -> componentMap.put(String.valueOf(a.getId()), a.getName()));
            moduleService.installedPluginList().forEach(a -> componentMap.put(String.valueOf(a.getId()), a.getGuiTitle()));
            SearchResult searchResult = new SearchResult(null, page);
            userRecordLogDao.searchUnregRequestRecordList((SearchResult<UnregRequestRecord>)searchResult);
            searchResult.getList().forEach(a -> {
                if ("0".equals(a.getModuleId())) {
                    a.setModuleName("kernel");
                } else if (a.getModuleId().startsWith("p")) {
                    a.setModuleName(componentMap.getOrDefault(a.getModuleId().substring(1), "?"));
                } else {
                    a.setModuleName(componentMap.getOrDefault(a.getModuleId(), "?"));
                }
            });
            SearchResult searchResult2 = searchResult;
            return searchResult2;
        }
    }

    @Override
    public void clearUnregRequestRecordList() throws BGException, BGMessageException {
        try (UserRecordLogDao userRecordLogDao = new UserRecordLogDao(this.getConnection());){
            userRecordLogDao.clearUnregRequestRecordList();
        }
    }

    @Override
    public void recheckUnregRequestRecordList() throws BGException, BGMessageException {
        try (UserRecordLogDao userRecordLogDao = new UserRecordLogDao(this.getConnection());){
            SearchResult searchResult = new SearchResult(null, null);
            userRecordLogDao.searchUnregRequestRecordList((SearchResult<UnregRequestRecord>)searchResult);
            searchResult.getList().forEach(a -> {
                ModuleAction moduleAction = null;
                try {
                    moduleAction = FindAction.find(new String[]{a.getModuleId()}, a.getService(), a.getOperation(), null);
                    if (moduleAction != null) {
                        userRecordLogDao.deleteUnregRequestRecord((UnregRequestRecord)a);
                    }
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
            });
        }
    }

    @Override
    public SearchResult<RequestRecordLog> searchRequestRecordLogList() throws BGException, BGMessageException {
        try (RequestRecordLogDao requestRecordLogDao = new RequestRecordLogDao(this.getConnection());){
            SearchResult searchResult = new SearchResult();
            requestRecordLogDao.searchRequestRecordLogList((SearchResult<RequestRecordLog>)searchResult);
            for (RequestRecordLog log : searchResult.getList()) {
                RequestRecordLog cacheLog = UserActionRecorderCache.getInstance().getInProgress().get(log.getUserId());
                if (cacheLog == null) {
                    if (log.getEndRecordingTime() != null) continue;
                    UserActionRecorderCache.getInstance().getInProgress().put(this.userId, log);
                    continue;
                }
                if (cacheLog.getId() != log.getId()) continue;
                log.setActions(cacheLog.getActions());
            }
            SearchResult searchResult2 = searchResult;
            return searchResult2;
        }
    }

    @Override
    public void deleteRequestRecordLog(RequestRecordLog log) throws BGException, BGMessageException {
        UserActionRecorderCache.getInstance().getInProgress().remove(log.getUserId());
        try (RequestRecordLogDao requestRecordLogDao = new RequestRecordLogDao(this.getConnection());){
            requestRecordLogDao.delete(log.getId());
        }
    }

    @Override
    public void startRecordingActions(int userId, String title) throws BGException, BGMessageException {
        RequestRecordLog userActionsRecording = UserActionRecorderCache.getInstance().getInProgress().get(userId);
        if (userActionsRecording != null) {
            throw new BGException("\u0414\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ID=" + userId + " \u0443\u0436\u0435 \u0432\u0435\u0434\u0451\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439!");
        }
        userActionsRecording = new RequestRecordLog();
        userActionsRecording.setTitle(title);
        userActionsRecording.setStartRecordingTime(new Date());
        userActionsRecording.setUserId(userId);
        try (RequestRecordLogDao requestRecordLogDao = new RequestRecordLogDao(this.getConnection());){
            requestRecordLogDao.update((Object)userActionsRecording);
        }
        UserActionRecorderCache.getInstance().getInProgress().put(userId, userActionsRecording);
    }

    @Override
    public RequestRecordLog stopRecordingActions(int user) throws BGException, BGMessageException {
        UserActionRecorderCache recorderCache = UserActionRecorderCache.getInstance();
        RequestRecordLog userActionsRecording = recorderCache.getInProgress().get(user);
        if (userActionsRecording == null) {
            throw new BGException("\u0414\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ID=" + user + " \u043d\u0435 \u0432\u0435\u0434\u0451\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
        }
        RequestRecordLog stoppedRecord = recorderCache.stopRecording(user);
        try (RequestRecordLogDao requestRecordLogDao = new RequestRecordLogDao(this.getConnection());){
            requestRecordLogDao.update((Object)stoppedRecord);
        }
        return stoppedRecord;
    }

    @Override
    public void updateRequestLog(RequestRecordLog requestRecordLog) throws BGException, BGMessageException {
        RequestRecordLog fromCache = UserActionRecorderCache.getInstance().getInProgress().get(requestRecordLog.getUserId());
        if (fromCache != null) {
            fromCache.setActions(requestRecordLog.getActions());
        }
        try (RequestRecordLogDao requestRecordLogDao = new RequestRecordLogDao(this.getConnection());){
            requestRecordLogDao.update((Object)requestRecordLog);
        }
    }
}

