/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.container.security.server.ModulePluginMap;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public abstract class AbstractPermissionChecker {
    private static final char[] CODES = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'};
    public static final Set<String> parameterActionSet = new HashSet<String>();
    protected Setup setup;
    protected ModulePluginMap modulePluginMap;

    protected AbstractPermissionChecker(Setup setup) {
        this.setup = setup;
        this.modulePluginMap = ModulePluginMap.getInstance(setup.getDBConnection());
    }

    public static boolean isAdmin(int userId) {
        return userId == 1;
    }

    protected Map<String, String> getRequestMap(HttpServletRequest httpServletRequest) {
        Map parameterMap = httpServletRequest.getParameterMap();
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String key : parameterMap.keySet()) {
            keyValueMap.put(key, ((String[])parameterMap.get(key))[0]);
        }
        return keyValueMap;
    }

    public static int getWriteRule(List<String> rules, int pid) {
        int result = 0;
        if (rules == null) {
            return result;
        }
        block0: for (String rule : rules) {
            int rulePid = Utils.parseInt((String)rule.substring(0, rule.length() - 1));
            if (rulePid != pid) continue;
            char code = rule.charAt(rule.length() - 1);
            for (int index = 0; index < CODES.length; ++index) {
                if (CODES[index] != code) continue;
                result = index & 3;
                break block0;
            }
        }
        return result;
    }

    public static int getReadRule(List<String> rules, int pid) {
        int result = 0;
        if (rules == null) {
            return result;
        }
        block0: for (String rule : rules) {
            int rulePid = Utils.parseInt((String)rule.substring(0, rule.length() - 1));
            if (rulePid != pid) continue;
            char code = rule.charAt(rule.length() - 1);
            for (int index = 0; index < CODES.length; ++index) {
                if (CODES[index] != code) continue;
                result = (index & 0xC) >> 2;
                break block0;
            }
        }
        return result;
    }

    static {
        parameterActionSet.add("UpdateParameterType1");
        parameterActionSet.add("UpdateEmailInfo");
        parameterActionSet.add("UpdateServiceInfo");
        parameterActionSet.add("UpdateParameterType5");
        parameterActionSet.add("UpdateParameterType6");
        parameterActionSet.add("UpdateParameterType8");
        parameterActionSet.add("UpdatePhoneInfo");
    }
}

