/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;

public class CheckPermissionKitToAllowContract {
    private static final Logger logger = LogManager.getLogger();

    public static boolean check(String service, int parameterId, int opid, int userId) {
        boolean isAllow = true;
        if (parameterId > 0 && PermissionOfRoles.parameterActionSet.contains(service) && !(isAllow = PermissionOfRoles.checkWriteContractParameter(parameterId, userId))) {
            return false;
        }
        if (opid > 0) {
            isAllow = PermissionOfRoles.checkWriteObjectParameter(opid, userId);
        }
        return isAllow;
    }

    public static List<PermissionKit> checkAllowContract(List<PermissionKit> kits, int cid) {
        ArrayList<PermissionKit> allowsKit = new ArrayList<PermissionKit>();
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            ContractRuntime runtime = ContractRuntimeMap.getInstance().getContractRuntime(con, (Integer)cid);
            DomainRuntimeMap domainRuntimeMap = DomainRuntimeMap.getInstance(con);
            for (PermissionKit kit : kits) {
                if (!CheckPermissionKitToAllowContract.checkAllowContract(kit, runtime, domainRuntimeMap)) continue;
                allowsKit.add(kit);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return allowsKit;
    }

    private static boolean checkAllowContract(PermissionKit kit, ContractRuntime runtime, DomainRuntimeMap domainRuntimeMap) {
        if (runtime != null) {
            boolean isAllow;
            List<Integer> contractLabelsInKit = kit.getContractLabels();
            List<Integer> contractLabels = PermissionOfRoles.getInstance().getContractLabelsMap().get(runtime.contractId);
            if (Utils.isEmptyCollection(contractLabels) || Utils.isEmptyCollection(contractLabelsInKit)) {
                return true;
            }
            boolean bl = isAllow = contractLabels.stream().filter(contractLabelsInKit::contains).findFirst().orElse(-1) > 0;
            if (isAllow && domainRuntimeMap != null && runtime.getDomainId() > 0 && Utils.notEmptyCollection(kit.getDomenIds())) {
                isAllow = domainRuntimeMap.getAllDescendantDomainIds(new HashSet<Integer>(kit.getDomenIds())).contains(runtime.getDomainId());
            }
            return isAllow;
        }
        return true;
    }
}

