/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;

public abstract class AbstractPaymentAction
extends AbstractAction {
    private Logger logger;
    protected String customerAddress = null;

    public AbstractPaymentAction(String module) {
        super(module);
    }

    @Override
    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        this.setResultParam("jspPage", "include/payment.jsp");
        if (this.req.getBoolean("getBody", false)) {
            this.requestDispatcher(this.moduleName, "../include/payment");
        }
    }

    @WebOperation(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432")
    public void check() throws Exception {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        ThreadContext.put((String)"componentName", (String)this.moduleName);
        ThreadContext.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        ThreadContext.put((String)"contractId", (String)String.valueOf(this.contractId));
        try (Connection con = this.setup.getDBConnectionFromPool();){
            this.customerAddress = this.req.get("customerAddress");
            ContractUtils.saveCustomerAddress(con, this.moduleId, this.contractId, this.customerAddress);
            ContractUtils.saveCustomerAddress(con, 0, this.contractId, this.customerAddress);
        }
    }

    protected BigDecimal payCheckSum(String prefix, Class<?> constantsClass) throws Exception {
        String prefixUpperCase = prefix.toUpperCase();
        int defSumMin = (Integer)constantsClass.getDeclaredField(prefixUpperCase + "_SUM_MIN").get(null);
        int defSumMax = (Integer)constantsClass.getDeclaredField(prefixUpperCase + "_SUM_MAX").get(null);
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal(prefix + ".sum.min", new BigDecimal(defSumMin));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal(prefix + ".sum.max", new BigDecimal(defSumMax));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        return sum;
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        ThreadContext.put((String)"componentName", (String)this.moduleName);
        ThreadContext.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        ThreadContext.put((String)"contractId", (String)String.valueOf(this.contractId));
    }

    protected void autopaymentImpl(String prefix, AbstractAutopaymentManager autopaymentManager, Class<?> constantClass) throws Exception {
        int mode;
        boolean autopaymentEnable = this.moduleSetup.getBoolean(prefix + ".autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled(this.con, this.moduleId, this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = new Autopayment();
                autopayment.setContractId(this.contractId);
            }
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else {
                String prefixUpperCase = prefix.toUpperCase();
                if (mode == AutopaymentMode.WEEK.getCode()) {
                    this.autopaymentWeek(prefixUpperCase, modeDataMap, autopayment, constantClass);
                } else if (mode == AutopaymentMode.MONTH.getCode()) {
                    this.autopaymentMonth(prefixUpperCase, modeDataMap, autopayment, constantClass);
                } else if (mode == AutopaymentMode.AUTO.getCode()) {
                    this.autopaymentAuto(prefixUpperCase, modeDataMap, autopayment, constantClass);
                }
                String customerAddress = ContractUtils.saveCustomerAddress(this.con, this.moduleId, this.contractId, this.req.get("customerAddress"));
                this.registerOrder(autopayment.getSum(), customerAddress);
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            this.autopaymentRedirect(autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode());
        }
    }

    protected void registerOrder(BigDecimal sum, String customerAddress) throws Exception {
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogManager.getLogger();
        }
        return this.logger;
    }
}

