/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

public class ContractStatusLogDao
extends AbstractIdDao<ContractStatusLog> {
    public ContractStatusLogDao(Connection con) {
        super(con, 0, "contract_status_log");
    }

    protected ContractStatusLog getFromRS(ResultSet rs) throws SQLException, BGException {
        return ContractStatusLog.builder().setId(rs.getInt("id")).setUserId(rs.getInt("uid")).setDate(rs.getTimestamp("date")).setStatus(rs.getInt("status")).setComment(rs.getString("comment")).setContractId(rs.getInt("cid")).setDate1(rs.getDate("date1")).setDate2(rs.getDate("date2")).build();
    }

    protected void updateImpl(ContractStatusLog contractStatusLog) throws BGException {
        String query = "INSERT INTO " + this.tableName + " SET date=?, status=?, comment=?, uid=?, date1=?, date2=?, cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractStatusLog.getDate()));
            ps.setInt(index++, contractStatusLog.getStatus());
            ps.setString(index++, contractStatusLog.getComment());
            ps.setInt(index++, contractStatusLog.getUserId());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractStatusLog.getDate1()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractStatusLog.getDate2()));
            ps.setInt(index++, contractStatusLog.getContractId());
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<ContractStatusLog> getLogList(int contractId) throws BGException {
        return this.list("cid=?", "date desc", new Object[]{contractId});
    }

    public void searchContractStatusLog(SearchResult<ContractStatusLog> searchResult, int contractId) throws BGException {
        Result result = this.list(searchResult.getPage(), "cid=?", "date desc", new Object[]{contractId});
        searchResult.setList(result.getList());
        searchResult.setPage(result.getPage());
    }
}

