/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.customer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.Customer;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContactType;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class CustomerDao {
    public static final String TABLE_CUSTOMER = "customer";
    public static final String TABLE_CUSTOMER_LOG = "customer_log";
    public static final String TABLE_CUSTOMER_LINK = "customer_link";
    private Connection con;
    private static final Logger logger = LogManager.getLogger();

    public CustomerDao(Connection con) {
        this.con = con;
    }

    public void searchCustomer(SearchResult<Customer> searchResult, Customer.CustomerType customerType, List<KeyValue> filters) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        boolean filter = filters != null && !filters.isEmpty();
        String query = "SELECT SQL_CALC_FOUND_ROWS *, contract_count AS c FROM customer LEFT JOIN customer_contract_count AS cc ON id=cc.customer_id WHERE type=?" + (filter ? this.getSQLFilter(filters) : "") + (page != null ? page.sqlLimit() : "");
        try (Statement st = this.con.createStatement();
             PreparedStatement ps = this.con.prepareStatement(query);){
            st.executeUpdate("CREATE TEMPORARY TABLE IF NOT EXISTS customer_contract_count SELECT customer_id, COUNT(contract_id) AS contract_count FROM customer_link WHERE (`date_to` IS NULL OR `date_to` >= now()) GROUP BY customer_id");
            int index = 1;
            ps.setString(index++, customerType.getType());
            if (filter) {
                for (KeyValue keyValue : filters) {
                    ps.setString(index++, keyValue.getKey());
                    ps.setString(index++, "%" + keyValue.getValue() + "%");
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Customer customer = new Customer();
                    customer.setId(rs.getInt("id"));
                    customer.setCustomerType(Customer.CustomerType.defineType(rs.getString("type")));
                    customer.setData(rs.getString("data"));
                    customer.setContractCount(rs.getInt("c"));
                    list.add(customer);
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            st.executeUpdate("DROP TEMPORARY TABLE IF EXISTS customer_contract_count");
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private String getSQLFilter(List<KeyValue> filters) {
        return filters != null && !filters.isEmpty() ? " AND id IN ( SELECT customer_id FROM customer_log WHERE old=0 AND field_key=? AND field_value LIKE ? )".repeat(filters.size()) : "";
    }

    public Optional<CustomerLink> getCustomerLink(int contractId, LocalDateTime dateTime) throws BGException {
        CustomerLink customerLink = null;
        String sql = "SELECT * FROM customer_link WHERE contract_id=? AND ( date_from<=? AND (date_to IS NULL OR date_to>=?))";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)dateTime));
            ps.setTimestamp(index, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)dateTime));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                customerLink = new CustomerLink();
                customerLink.setCustomerId(rs.getInt("customer_id"));
                customerLink.setContractId(rs.getInt("contract_id"));
                customerLink.setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return Optional.ofNullable(customerLink);
    }

    public void addCustomerLink(CustomerLink customerLink) throws BGException {
        if (customerLink == null) {
            return;
        }
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO customer_link SET customer_id=?, contract_id=?, date_from=?, date_to=?");){
            int index = 1;
            ps.setInt(index++, customerLink.getCustomerId());
            ps.setInt(index++, customerLink.getContractId());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)customerLink.getPeriod().getLocalDateTimeFrom()));
            ps.setTimestamp(index, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)customerLink.getPeriod().getLocalDateTimeTo()));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int getNewCustomerId(Customer.CustomerType type) throws BGException {
        int customerId;
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO customer SET `type`=?, `data`=?", 1);){
            ps.setString(1, type.getType());
            ps.setString(2, "{}");
            ps.executeUpdate();
            customerId = ServerUtils.lastInsertId(ps);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return customerId;
    }

    public String updateCustomerFieldValue(int customerId, String fieldKey, String fieldValue, int userId) throws BGException {
        String data = null;
        String querySelect = "SELECT data FROM customer WHERE id=?";
        String queryUpdate = "UPDATE customer SET data=? WHERE id=? AND data=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int updateRow;
            do {
                String oldText;
                JSONObject customerFromDB;
                String oldData = "{}";
                psSelect.setInt(1, customerId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        oldData = rs.getString("data");
                    }
                }
                JSONObject parentOfCustomer = customerFromDB = new JSONObject(oldData);
                String[] fields = (fieldKey.startsWith("/") ? fieldKey.substring(1) : fieldKey).split("/");
                for (int index = 0; index < fields.length - 1; ++index) {
                    JSONObject innerParent = parentOfCustomer.optJSONObject(fields[index]);
                    if (innerParent == null) {
                        innerParent = new JSONObject();
                        parentOfCustomer.put(fields[index], (Object)innerParent);
                    }
                    parentOfCustomer = innerParent;
                }
                String key = fields[fields.length - 1];
                String string = oldText = parentOfCustomer.has(key) ? parentOfCustomer.getString(key) : null;
                if (oldText != null && oldText.equals(fieldValue)) break;
                if (Utils.isBlankString((String)fieldValue) && this.isContactField(fieldKey)) {
                    JSONObject contacts = (JSONObject)parentOfCustomer.optQuery("/customer/contact");
                    if (contacts.has(fieldKey)) {
                        contacts.remove(fieldKey);
                    }
                } else if (Utils.isBlankString((String)fieldValue)) {
                    if (parentOfCustomer.has(key)) {
                        parentOfCustomer.remove(key);
                    }
                } else {
                    parentOfCustomer.put(key, (Object)fieldValue);
                }
                data = customerFromDB.toString();
                psUpdate.setString(1, data);
                psUpdate.setInt(2, customerId);
                psUpdate.setString(3, oldData);
                updateRow = psUpdate.executeUpdate();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("updateCustomerFieldValue() => customerId = {}; newData = {}; oldData = {}; updateRow = {}", (Object)customerId, (Object)data, (Object)oldData, (Object)updateRow);
            } while (updateRow <= 0);
            this.updateLog(customerId, fieldKey, fieldValue, userId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return data;
    }

    public String updateCustomerContact(int customerId, CustomerContactType contactType, String value, int userId) throws BGException {
        String data = null;
        String querySelect = "SELECT data FROM customer WHERE id=?";
        String queryUpdate = "UPDATE customer SET data=? WHERE id=? AND data=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int updateRow;
            do {
                JSONObject contact;
                String oldData = "{}";
                psSelect.setInt(1, customerId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        oldData = rs.getString("data");
                    }
                }
                JSONObject customerFromDB = new JSONObject(oldData);
                JSONObject customer = (JSONObject)customerFromDB.optQuery("/customer");
                if (customer == null) {
                    customer = new JSONObject();
                    customerFromDB.put(TABLE_CUSTOMER, (Object)customer);
                }
                if ((contact = (JSONObject)customerFromDB.optQuery("/customer/contact")) == null) {
                    contact = new JSONObject();
                    customer.put("contact", (Object)contact);
                }
                String key = contactType.name().toLowerCase();
                if (Utils.notEmptyString((String)value)) {
                    contact.put(key, (Object)new JSONArray(value));
                } else if (contact.has(key)) {
                    contact.remove(key);
                }
                data = customerFromDB.toString();
                if (oldData.equals(data)) break;
                psUpdate.setString(1, data);
                psUpdate.setInt(2, customerId);
                psUpdate.setString(3, oldData);
                updateRow = psUpdate.executeUpdate();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("updateCustomerContact() => customerId = {}; newData = {}; oldData = {}; updateRow = {}", (Object)customerId, (Object)data, (Object)oldData, (Object)updateRow);
            } while (updateRow <= 0);
            StringBuilder emails = new StringBuilder();
            new JSONArray(value).forEach(a -> emails.append(emails.length() > 0 ? "; " : "").append(((JSONObject)a).optString("value")));
            this.updateLog(customerId, contactType.key, emails.toString(), userId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return data;
    }

    private boolean isContactField(String fieldKey) {
        return fieldKey.contains("phone") || fieldKey.contains("home_phone") || fieldKey.contains("email");
    }

    private void updateLog(int customerId, String fieldKey, String fieldValue, int userId) throws SQLException {
        if (!((String)fieldKey).startsWith("/")) {
            fieldKey = "/" + (String)fieldKey;
        }
        if (this.isContactField((String)fieldKey) && !((String)fieldKey).startsWith("/customer/contact")) {
            fieldKey = "/customer/contact" + (String)fieldKey;
        }
        String queryUpdate = "UPDATE customer_log SET `old`=1 WHERE customer_id=? AND `field_key`=?";
        String queryInsert = "INSERT INTO customer_log SET `customer_id`=?, `update_time`=NOW(), `user_id`=?, `field_key`=?, `field_value`=?";
        try (PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);
             PreparedStatement psInsert = this.con.prepareStatement(queryInsert);){
            psUpdate.setInt(1, customerId);
            psUpdate.setString(2, (String)fieldKey);
            psUpdate.executeUpdate();
            int parameterIndex = 1;
            psInsert.setInt(parameterIndex++, customerId);
            psInsert.setInt(parameterIndex++, userId);
            psInsert.setString(parameterIndex++, (String)fieldKey);
            psInsert.setString(parameterIndex, Utils.maskBlank((String)fieldValue, (String)""));
            psInsert.executeUpdate();
        }
    }

    public JSONObject getCustomerDataJson(int customerId) throws BGException {
        if (customerId <= 0) {
            return new JSONObject();
        }
        return new JSONObject(this.getCustomer(customerId).getData());
    }

    public Customer getCustomer(int customerId) throws BGException {
        Customer customer = null;
        try (PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM customer WHERE id=?");){
            psSelect.setInt(1, customerId);
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                customer = new Customer();
                customer.setId(customerId);
                customer.setCustomerType(Customer.CustomerType.defineType(rs.getString("type")));
                customer.setData(rs.getString("data"));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return customer;
    }

    public JSONArray searchByKey(Customer.CustomerType customerType, String key, String value) throws BGException {
        JSONArray customers = new JSONArray();
        String query = "SELECT c.`id`, c.`data` FROM customer AS c LEFT JOIN customer_log AS cl ON cl.`customer_id`=c.`id` WHERE c.`type`=? AND cl.`old`=0 AND cl.`field_key`=? AND cl.`field_value`=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setString(parameterIndex++, customerType.getType());
            psSelect.setString(parameterIndex++, key);
            psSelect.setString(parameterIndex, value);
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                JSONObject customerFromDB = new JSONObject(rs.getString("data"));
                JSONObject customer = new JSONObject();
                if (customerType == Customer.CustomerType.JUR_CUSTOMER) {
                    customer.put("id", rs.getInt("id"));
                    customer.put("title", customerFromDB.optQuery(Customer.CustomerJur.NAME.key()));
                    customer.put("inn", customerFromDB.optQuery(Customer.CustomerJur.INN.key()));
                    customer.put("ogrn", customerFromDB.optQuery(Customer.CustomerJur.OGRN.key()));
                } else if (customerType == Customer.CustomerType.FIZ_CUSTOMER) {
                    StringBuilder fio = new StringBuilder();
                    Object last = customerFromDB.optQuery(Customer.CustomerFiz.LAST_NAME.key());
                    fio.append((String)(last == null ? "" : last + " "));
                    Object first = customerFromDB.optQuery(Customer.CustomerFiz.FIRST_NAME.key());
                    fio.append((String)(first == null ? "" : first + " "));
                    Object middle = customerFromDB.optQuery(Customer.CustomerFiz.MIDDLE_NAME.key());
                    fio.append(middle == null ? "" : String.valueOf(middle));
                    StringBuilder passport = new StringBuilder();
                    Object passportRF = customerFromDB.optQuery(Customer.CustomerFizDocument.PASSPORT_RF.key());
                    if (passportRF != null) {
                        JSONObject passportObject = (JSONObject)passportRF;
                        passport.append(passportObject.optString("series")).append(" ").append(passportObject.optString("number"));
                    }
                    Object birthday = customerFromDB.optQuery(Customer.CustomerFiz.BIRTHDAY.key());
                    customer.put("id", rs.getInt("id"));
                    customer.put("title", (Object)fio.toString().trim());
                    customer.put("birthday", (Object)(birthday == null ? "" : TimeUtils.format((LocalDate)LocalDate.parse((String)birthday), (String)"dd.MM.yyyy")));
                    customer.put("passport", (Object)passport.toString().trim());
                }
                customers.put((Object)customer);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return customers;
    }

    public void setCustomerLink(int contractId, int customerId, LocalDateTime linkDateTimeFrom) throws BGException {
        if (linkDateTimeFrom == null) {
            return;
        }
        String selectQuery = "SELECT * FROM customer_link WHERE contract_id=? AND customer_id=?";
        String insertQuery = "INSERT INTO customer_link SET contract_id=?, customer_id=?, date_from=?";
        String deleteQuery = "DELETE FROM customer_link WHERE contract_id=? AND customer_id=? AND date_from=? AND date_to=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(selectQuery);
             PreparedStatement psInsert = this.con.prepareStatement(insertQuery);
             PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, contractId);
            psSelect.setInt(parameterIndex, customerId);
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                LocalDateTime dateFrom = TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("date_from"));
                LocalDateTime dateTo = TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("date_to"));
                if (dateFrom != null && dateFrom.isBefore(linkDateTimeFrom) && dateTo != null && dateTo.isBefore(linkDateTimeFrom)) continue;
                if (dateFrom != null && linkDateTimeFrom.isBefore(dateFrom)) {
                    parameterIndex = 1;
                    psDelete.setInt(parameterIndex++, contractId);
                    psDelete.setInt(parameterIndex++, customerId);
                    psDelete.setTimestamp(parameterIndex++, rs.getTimestamp("date_from"));
                    psDelete.setTimestamp(parameterIndex, rs.getTimestamp("date_to"));
                    psDelete.executeUpdate();
                    continue;
                }
                if (dateFrom == null || !dateFrom.isBefore(linkDateTimeFrom) || dateTo != null && !linkDateTimeFrom.isBefore(dateTo)) continue;
                parameterIndex = 1;
                psDelete.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)linkDateTimeFrom.minusSeconds(1L)));
                psDelete.setInt(parameterIndex++, contractId);
                psDelete.setInt(parameterIndex++, customerId);
                psDelete.setTimestamp(parameterIndex, rs.getTimestamp("date_from"));
                psDelete.executeUpdate();
            }
            parameterIndex = 1;
            psInsert.setInt(parameterIndex++, contractId);
            psInsert.setInt(parameterIndex++, customerId);
            psInsert.setTimestamp(parameterIndex, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)linkDateTimeFrom));
            psInsert.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public JSONArray getCustomerContracts(int customerId, LocalDateTime onTime) throws BGException {
        JSONArray contracts = new JSONArray();
        String selectQuery = "SELECT c.id, c.title FROM customer_link AS cl LEFT JOIN contract AS c ON c.id=cl.contract_id WHERE cl.customer_id=?" + (onTime != null ? " AND ( cl.date_from IS NULL OR cl.date_from<?) AND ( cl.date_to IS NULL OR cl.date_to>? )" : "");
        try (PreparedStatement psSelect = this.con.prepareStatement(selectQuery);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, customerId);
            if (onTime != null) {
                psSelect.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)onTime));
                psSelect.setTimestamp(parameterIndex, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)onTime));
            }
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt("id");
                    if (id <= 0) continue;
                    JSONObject contract = new JSONObject();
                    contract.put("id", id);
                    contract.put("title", (Object)rs.getString("title"));
                    contracts.put((Object)contract);
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return contracts;
    }

    public boolean setCustomerUnlinkContract(int contractId, LocalDateTime unlinkTime) throws BGException {
        boolean result;
        String updateQuery = "UPDATE customer_link SET date_to=? WHERE contract_id=? AND date_to IS NULL";
        try (PreparedStatement psUpdate = this.con.prepareStatement(updateQuery);){
            int parameterIndex = 1;
            psUpdate.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)unlinkTime));
            psUpdate.setInt(parameterIndex, contractId);
            result = psUpdate.executeUpdate() > 0;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public String getCustomerParameterHistory(int customerId, String fieldKey, int lastRecordCount) throws BGException {
        JSONArray jsonArray = new JSONArray();
        try (PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM `customer_log` WHERE `customer_id`=? AND `field_key`=? ORDER BY `update_time` DESC " + (lastRecordCount > 0 ? " LIMIT ?" : ""));){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, customerId);
            psSelect.setString(parameterIndex++, fieldKey);
            if (lastRecordCount > 0) {
                psSelect.setInt(parameterIndex, lastRecordCount);
            }
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    JSONObject json = new JSONObject();
                    json.put("value", (Object)rs.getString("field_value"));
                    json.put("date", (Object)TimeUtils.format((Date)rs.getTimestamp("update_time"), (String)"dd.MM.yyyy HH:mm:ss"));
                    json.put("userId", rs.getInt("user_id"));
                    jsonArray.put((Object)json);
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return jsonArray.toString();
    }

    public String getCustomerParameter(int customerId, String fieldKey) throws BGException {
        String value = null;
        String query = "SELECT * FROM `customer_log` WHERE `customer_id`=? AND old=0 AND `field_key`=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, customerId);
            psSelect.setString(parameterIndex++, fieldKey);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    value = rs.getString("field_value");
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return value;
    }

    public void deleteCustomer(int customerId) throws BGException {
        String queryDelete = "DELETE FROM customer WHERE id=?";
        String queryDeleteLog = "DELETE FROM customer_log WHERE customer_id=?";
        String queryDeleteLink = "DELETE FROM customer_link WHERE customer_id=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);
             PreparedStatement psDeleteLog = this.con.prepareStatement(queryDeleteLog);
             PreparedStatement psDeleteLink = this.con.prepareStatement(queryDeleteLink);){
            psDelete.setInt(1, customerId);
            psDelete.executeUpdate();
            psDeleteLog.setInt(1, customerId);
            psDeleteLog.executeUpdate();
            psDeleteLink.setInt(1, customerId);
            psDeleteLink.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

