/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

public class ContractParameterGroupAttrDao
extends AbstractIdDao<ContractParameterGroupAttr>
implements Directory<ContractParameterGroupAttr> {
    public ContractParameterGroupAttrDao(Connection con) {
        super(con, 0, "contract_parameters_pref");
    }

    private static int toEntityType(int pt) {
        switch (pt) {
            case 1: {
                return EntitySpecAttrType.TEXT.getCode();
            }
            case 2: {
                return EntitySpecAttrType.ADDRESS.getCode();
            }
            case 3: {
                return EntitySpecAttrType.EMAIL.getCode();
            }
            case 4: {
                return EntitySpecAttrType.SERVICING_PERSON.getCode();
            }
            case 5: {
                return EntitySpecAttrType.BOOLEAN.getCode();
            }
            case 6: {
                return EntitySpecAttrType.DATE.getCode();
            }
            case 7: {
                return EntitySpecAttrType.LIST.getCode();
            }
            case 8: {
                return EntitySpecAttrType.CONTRACT.getCode();
            }
            case 9: {
                return EntitySpecAttrType.PHONE.getCode();
            }
            case 10: {
                return EntitySpecAttrType.SEPARATOR.getCode();
            }
            case 11: {
                return EntitySpecAttrType.MULTILIST.getCode();
            }
        }
        return 0;
    }

    private static int toParameterType(int entitySpecAttrTypeId) {
        switch (EntitySpecAttrType.getEntitySpecAttrType((int)entitySpecAttrTypeId)) {
            case TEXT: {
                return 1;
            }
            case ADDRESS: {
                return 2;
            }
            case DATE: {
                return 6;
            }
            case LIST: {
                return 7;
            }
            case EMAIL: {
                return 3;
            }
            case CONTRACT: {
                return 8;
            }
            case BOOLEAN: {
                return 5;
            }
            case PHONE: {
                return 9;
            }
            case SEPARATOR: {
                return 10;
            }
            case MULTILIST: {
                return 11;
            }
        }
        return 0;
    }

    protected ContractParameterGroupAttr getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractParameterGroupAttr result = new ContractParameterGroupAttr();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setType(ContractParameterGroupAttrDao.toEntityType(rs.getInt("pt")));
        result.setOrder(rs.getInt("sort"));
        result.setComment("");
        int flags = rs.getInt("flags");
        result.setHistory((flags & 1) > 0);
        result.setCustomerWrite((flags & 2) > 0);
        result.setCustomerRead((flags & 4) > 0);
        result.setAlwaysVisible((flags & 8) > 0);
        return result;
    }

    protected void updateImpl(ContractParameterGroupAttr contractParameterGroupAttr) throws BGException, SQLException {
        try {
            String query = null;
            PreparedStatement ps = null;
            int flags = contractParameterGroupAttr.isHistory() ? 1 : 0;
            flags |= contractParameterGroupAttr.isCustomerWrite() ? 2 : 0;
            flags |= contractParameterGroupAttr.isCustomerRead() ? 4 : 0;
            flags |= contractParameterGroupAttr.isAlwaysVisible() ? 8 : 0;
            if (contractParameterGroupAttr.getId() <= 0) {
                query = "SELECT if( isnull( max(sort) ), 1, max(sort) + 1 ) FROM " + this.tableName;
                ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    contractParameterGroupAttr.setOrder(rs.getInt(1));
                }
                ps.close();
                query = "INSERT INTO " + this.tableName + " SET title=?, sort=?, script=?, pt=?, flags=?";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(4, ContractParameterGroupAttrDao.toParameterType(contractParameterGroupAttr.getType()));
                ps.setByte(5, (byte)flags);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, sort=?, script=?, flags=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setByte(4, (byte)flags);
                ps.setInt(5, contractParameterGroupAttr.getId());
            }
            ps.setString(1, contractParameterGroupAttr.getTitle());
            ps.setInt(2, contractParameterGroupAttr.getOrder());
            ps.setString(3, "");
            ps.executeUpdate();
            if (contractParameterGroupAttr.getId() <= 0) {
                contractParameterGroupAttr.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
            ContractParameterManager.resetParametersHistoryMap();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @Override
    public ContractParameterGroupAttr get(String title) throws BGException {
        return (ContractParameterGroupAttr)((Object)super.get("title=?", new Object[]{title}));
    }

    @Override
    public List<ContractParameterGroupAttr> list() throws BGException {
        return super.list(null, "sort", new Object[0]);
    }

    public List<ContractParameterGroupAttr> list(int paramGroupId) throws BGException {
        try {
            ArrayList<ContractParameterGroupAttr> result = new ArrayList<ContractParameterGroupAttr>();
            PreparedStatement ps = this.con.prepareStatement("SELECT pref.* FROM contract_parameter_group as gr LEFT JOIN " + this.tableName + " as pref ON pref.id=gr.pid WHERE gr.gid=?");
            ps.setInt(1, paramGroupId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractParameterGroupAttr attr = this.getFromRS(rs);
                if (attr.getType() <= 0) continue;
                result.add(attr);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        this.checkUsed(id);
        return super.deleteImpl(id);
    }

    private void checkUsed(int id) throws SQLException, BGMessageException {
        boolean found = false;
        PreparedStatement ps = this.con.prepareStatement("SELECT pref.* FROM contract_parameter_group as gr LEFT JOIN " + this.tableName + " as pref ON pref.id=gr.pid WHERE pref.id=? LIMIT 1");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            found = true;
        }
        rs.close();
        ps.close();
        if (found) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0433\u0440\u0443\u043f\u043f\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432.");
        }
    }

    public void updateLink(int contractParameterGroupId, Set<Integer> parameterIds) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM contract_parameter_group WHERE gid=?");
            ps.setInt(1, contractParameterGroupId);
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("INSERT INTO contract_parameter_group SET gid=?, pid=?");
            ps.setInt(1, contractParameterGroupId);
            for (Integer id : parameterIds) {
                ps.setInt(2, id);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateOrderPosition(List<ContractParameterGroupAttr> list) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET sort=? WHERE id=?");){
            for (ContractParameterGroupAttr contract : list) {
                ps.setInt(1, contract.getOrder());
                ps.setInt(2, contract.getId());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

