/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.server.service;

import bitel.billing.server.util.Config;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.sql.ConnectionSet;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService")
public class ContractAutopaymentServiceImpl
extends AbstractService
implements ContractAutopaymentService {
    private static final Logger logger = LogManager.getLogger();
    private ContractAutopaymentManager contractAutopaymentManager;

    @PostConstruct
    void init() {
        this.contractAutopaymentManager = new ContractAutopaymentManager(this.getConnection(), this.moduleId);
    }

    @PreDestroy
    void destroy() {
        try {
            if (this.contractAutopaymentManager != null) {
                this.contractAutopaymentManager.close();
                this.contractAutopaymentManager = null;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public SearchResult<ContractAutopayment> searchContractAutopayment(int contractId, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page, sort);
        this.contractAutopaymentManager.searchContractAutopayment((SearchResult<ContractAutopayment>)searchResult, contractId);
        return searchResult;
    }

    @Override
    public boolean isEnabled(int contractId) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        return this.contractAutopaymentManager.isEnabled(contractId);
    }

    @Override
    public boolean setEnabled(int contractId, boolean enabled) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        return this.contractAutopaymentManager.setEnabled(contractId, enabled, this.userId);
    }

    @Override
    public List<ContractAutopaymentMode> contractAutopaymentModeList(int contractId) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        ContractAutopaymentConf contractAutopaymentConf = this.getSetup().getConfig(this.moduleId, ContractAutopaymentConf.class);
        return this.contractAutopaymentModeList((ParameterMap)this.getSetup().getModuleSetup(this.moduleId), this.getConnectionSet(), this.moduleId, contractAutopaymentConf.prefix, contractAutopaymentConf.defaultAutopaymentSetup, contractId);
    }

    private List<ContractAutopaymentMode> contractAutopaymentModeList(ParameterMap moduleSetup, ConnectionSet connectionSet, int moduleId, String prefix, ParameterMap defaultSetup, int contractId) throws BGException {
        boolean autopaymentModeAutoEnable;
        boolean autopaymentModeMonthEnable;
        boolean autopaymentEnable;
        moduleSetup = moduleSetup.sub(prefix);
        if (defaultSetup != null) {
            moduleSetup = defaultSetup.inherit(moduleSetup);
        }
        if (!(autopaymentEnable = moduleSetup.getBoolean("autopayment.enable", false))) {
            return null;
        }
        if (!this.isEnabled(contractId)) {
            return null;
        }
        if (defaultSetup == null) {
            logger.info("Autopayment enabled but defaultAutopaymentSetup not found");
        }
        ArrayList<ContractAutopaymentMode> result = new ArrayList<ContractAutopaymentMode>();
        boolean autopaymentModeWeekEnable = moduleSetup.getBoolean("autopayment.mode.week.enable", false);
        if (autopaymentModeWeekEnable) {
            ContractAutopaymentMode.ContractAutopaymentModePeriodic mode = new ContractAutopaymentMode.ContractAutopaymentModePeriodic();
            mode.setMode(AutopaymentMode.WEEK);
            mode.setDay(moduleSetup.getInt("autopayment.mode.week.day.default", 1));
            mode.setSum(moduleSetup.getBigDecimal("autopayment.mode.week.sum.default", BigDecimal.valueOf(50L)));
            mode.setSumMin(moduleSetup.getBigDecimal("autopayment.mode.week.sum.min", BigDecimal.valueOf(50L)));
            mode.setSumMax(moduleSetup.getBigDecimal("autopayment.mode.week.sum.max", BigDecimal.valueOf(3000L)));
            result.add(mode);
        }
        if (autopaymentModeMonthEnable = moduleSetup.getBoolean("autopayment.mode.month.enable", false)) {
            ContractAutopaymentMode.ContractAutopaymentModePeriodic mode = new ContractAutopaymentMode.ContractAutopaymentModePeriodic();
            mode.setMode(AutopaymentMode.MONTH);
            mode.setDay(moduleSetup.getInt("autopayment.mode.month.day.default", 1));
            mode.setSum(moduleSetup.getBigDecimal("autopayment.mode.month.sum.default", BigDecimal.valueOf(50L)));
            mode.setSumMin(moduleSetup.getBigDecimal("autopayment.mode.month.sum.min", BigDecimal.valueOf(50L)));
            mode.setSumMax(moduleSetup.getBigDecimal("autopayment.mode.month.sum.max", BigDecimal.valueOf(10000L)));
            result.add(mode);
        }
        if (autopaymentModeAutoEnable = moduleSetup.getBoolean("autopayment.mode.auto.enable", false)) {
            ContractAutopaymentMode.ContractAutopaymentModeAuto mode = new ContractAutopaymentMode.ContractAutopaymentModeAuto();
            mode.setMode(AutopaymentMode.AUTO);
            mode.setDaySum(moduleSetup.getBigDecimal("autopayment.mode.auto.day.sum.default", BigDecimal.valueOf(500L)));
            mode.setDaySumMax(moduleSetup.getBigDecimal("autopayment.mode.auto.day.sum.max", BigDecimal.valueOf(3000L)));
            mode.setWeekSum(moduleSetup.getBigDecimal("autopayment.mode.auto.week.sum.default", BigDecimal.valueOf(1000L)));
            mode.setWeekSumMax(moduleSetup.getBigDecimal("autopayment.mode.auto.week.sum.max", BigDecimal.valueOf(5000L)));
            mode.setMonthSum(moduleSetup.getBigDecimal("autopayment.mode.auto.month.sum.default", BigDecimal.valueOf(3000L)));
            mode.setMonthSumMax(moduleSetup.getBigDecimal("autopayment.mode.auto.month.sum.max", BigDecimal.valueOf(10000L)));
            result.add(mode);
        }
        return result;
    }

    @Override
    public void contractAutopaymentModeCheck(int contractId, ContractAutopaymentMode autopaymentMode) throws BGIllegalAccessException, BGException {
        if (autopaymentMode == null) {
            throw new BGIllegalArgumentException("autopaymentMode");
        }
        if (autopaymentMode.getMode() == null) {
            throw new BGIllegalArgumentException("autopaymentMode.mode");
        }
        if (autopaymentMode.getMode() == null) {
            throw new BGIllegalArgumentException("autopaymentMode.mode");
        }
        List<ContractAutopaymentMode> contractAutopaymentModeList = this.contractAutopaymentModeList(contractId);
        if (contractAutopaymentModeList == null || contractAutopaymentModeList.size() == 0) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.", "autopayment.disabled");
        }
        ContractAutopaymentMode authorizedMode = contractAutopaymentModeList.stream().filter(a -> a.getMode() == autopaymentMode.getMode()).findFirst().orElse(null);
        if (authorizedMode == null) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430.", "autopaymentMode.mode.error");
        }
        switch (autopaymentMode.getMode()) {
            case MONTH: 
            case WEEK: {
                ContractAutopaymentMode.ContractAutopaymentModePeriodic m = (ContractAutopaymentMode.ContractAutopaymentModePeriodic)autopaymentMode;
                ContractAutopaymentMode.ContractAutopaymentModePeriodic a2 = (ContractAutopaymentMode.ContractAutopaymentModePeriodic)authorizedMode;
                if (m.getSum() == null) {
                    throw new BGIllegalArgumentException("autopaymentMode.sum");
                }
                if (a2.getSumMin().compareTo(m.getSum()) <= 0 && a2.getSumMax().compareTo(m.getSum()) >= 0) break;
                throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u043e\u0442 " + a2.getSumMin() + " \u0434\u043e " + a2.getSumMax() + ".", "autopaymentMode.sum.range");
            }
            case AUTO: {
                ContractAutopaymentMode.ContractAutopaymentModeAuto m = (ContractAutopaymentMode.ContractAutopaymentModeAuto)autopaymentMode;
                ContractAutopaymentMode.ContractAutopaymentModeAuto a3 = (ContractAutopaymentMode.ContractAutopaymentModeAuto)authorizedMode;
                if (m.getDaySum() == null || BigDecimal.ZERO.compareTo(m.getDaySum()) >= 0 || m.getWeekSum() == null || BigDecimal.ZERO.compareTo(m.getWeekSum()) >= 0 || m.getMonthSum() == null || BigDecimal.ZERO.compareTo(m.getMonthSum()) >= 0) {
                    throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f.", "autopaymentMode.auto.sum.empty");
                }
                if (m.getDaySum() != null && a3.getDaySumMax().compareTo(m.getDaySum()) < 0) {
                    throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u0437\u0430 \u0434\u0435\u043d\u044c \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u043e " + a3.getDaySumMax() + ".", "autopaymentMode.auto.day.sum");
                }
                if (m.getWeekSum() != null && a3.getWeekSumMax().compareTo(m.getWeekSum()) < 0) {
                    throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u0437\u0430 \u043d\u0435\u0434\u0435\u043b\u044e \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u043e " + a3.getWeekSumMax() + ".", "autopaymentMode.auto.week.sum");
                }
                if (m.getMonthSum() == null || a3.getMonthSumMax().compareTo(m.getMonthSum()) >= 0) break;
                throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u043e " + a3.getMonthSumMax() + ".", "autopaymentMode.auto.month.sum");
            }
            default: {
                throw new BGIllegalArgumentException("autopaymentMode.mode");
            }
        }
    }

    private AbstractAutopaymentManager newAutopaymentManager() throws BGException {
        try {
            ContractAutopaymentConf contractAutopaymentConf = this.getSetup().getConfig(this.moduleId, ContractAutopaymentConf.class);
            return (AbstractAutopaymentManager)((Object)Class.forName("ru.bitel.bgbilling.modules." + contractAutopaymentConf.module + ".server.bean.AutopaymentManager").getConstructor(Connection.class, Integer.TYPE).newInstance(this.getConnection(), this.moduleId));
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public SearchResult<Autopayment> autopaymentSearch(int contractId, Period period, String[] sort, Page page) throws BGException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        SearchResult searchResult = new SearchResult(period, page, sort);
        AbstractAutopaymentManager autopaymentManager = this.newAutopaymentManager();
        autopaymentManager.searchAutopayment((SearchResult<Autopayment>)searchResult, contractId);
        autopaymentManager.close();
        return searchResult;
    }

    @Override
    public void autopaymentInvoke(int contractId, BigDecimal amount) throws BGException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        try (AbstractAutopaymentManager autopaymentManager = this.newAutopaymentManager();){
            autopaymentManager.invokeAutopayment(contractId, amount);
        }
    }

    public static class ContractAutopaymentConf
    extends Config {
        final ParameterMap defaultAutopaymentSetup;
        final String module;
        final String prefix;

        public ContractAutopaymentConf(int moduleId, ParameterMap moduleSetup, Setup serverSetup) {
            super(moduleId, moduleSetup, serverSetup);
            String name;
            this.module = name = ModuleCache.getInstance().getModule(moduleId).getName();
            this.prefix = name + ".";
            ParameterMap defaultAutopaymentSetup = null;
            try {
                defaultAutopaymentSetup = (ParameterMap)Class.forName("ru.bitel.bgbilling.modules." + name + ".server.bean.Constants").getField("defaultAutopaymentSetup").get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                logger.debug(e.getMessage());
            }
            this.defaultAutopaymentSetup = defaultAutopaymentSetup;
        }
    }
}

