/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.task;

import bitel.billing.server.admin.errorlog.bean.PeriodicErrorManager;
import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailTaskBalanceValidator;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Validator
extends TaskBase {
    private Connection conSlave;
    private String email;
    private StringBuilder report = new StringBuilder(1000);
    private static final int MAX_SUM_ERRORS = 200;
    private static final String PAYMENT_SUM_TABLE = "_validator_payment_sum";
    private static final String PAYMENT_SUB_SUM_TABLE = "_validator_payment_sub_sum";
    private static final String CHARGE_SUM_TABLE = "_validator_charge_sum";
    private static final String CHARGE_SUB_SUM_TABLE = "_validator_charge_sub_sum";
    private static final String ACCOUNT_SUM_TABLE = "_validator_account_sum";
    private static final String ACCOUNT_SUB_SUM_TABLE = "_validator_account_sub_sum";
    private static final String TEMP_BALANCE = "_validator_temp_balance";
    private static final int MAX_REST_ERRORS = 200;
    private static final String BALANCE_DUMP_TABLE = "_validator_balance_dump";

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 (\u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438) \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432.";
    }

    @Override
    protected boolean initTask() {
        this.email = this.taskSetup.get("email", null);
        if (Utils.isBlankString((String)this.email)) {
            this.log.error("Param email not defined!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            Calendar date = this.getOperatingTime();
            Calendar month = (Calendar)date.clone();
            Calendar prevMonth = (Calendar)date.clone();
            prevMonth.add(2, -1);
            int size = this.report.length();
            this.checkSums(prevMonth, this.conSlave);
            if (this.report.length() != size) {
                this.report.append("\n\n\u0415\u0434\u0438\u043d\u0438\u0447\u043d\u044b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0440\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0441\u0443\u043c\u043c \u043c\u043e\u0436\u043d\u043e \u0440\u0435\u0448\u0438\u0442\u044c \u0437\u0430\u043d\u0435\u0441\u0435\u043d\u0438\u0435\u043c \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c \u0444\u0438\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u043c\u0435\u0441\u044f\u0446 \u0441 \u043d\u0435\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435\u043c.");
                this.report.append("\u041f\u0440\u0438 \u043c\u043d\u043e\u0433\u043e\u043a\u0440\u0430\u0442\u043d\u044b\u0445 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f\u0445 \u043f\u043e\u0434\u043e\u0431\u043d\u044b\u0445 \u043e\u0448\u0438\u0431\u043e\u043a \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c.");
            }
            size = this.report.length();
            this.checkRests(month, this.conSlave);
            if (this.report.length() != size) {
                this.report.append("\n\n\u0415\u0434\u0438\u043d\u0438\u0447\u043d\u044b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u043e\u0441\u0442\u0430\u0442\u043a\u0430 \u043c\u043e\u0436\u043d\u043e \u0440\u0435\u0448\u0438\u0442\u044c \u0437\u0430\u043d\u0435\u0441\u0435\u043d\u0438\u0435\u043c \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c \u0444\u0438\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u043c\u0435\u0441\u044f\u0446, \u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0431\u044b\u043b \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u043e\u0441\u0442\u0430\u0442\u043e\u043a.");
                this.report.append("\u041f\u0440\u0438 \u043c\u043d\u043e\u0433\u043e\u043a\u0440\u0430\u0442\u043d\u044b\u0445 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f\u0445 \u043f\u043e\u0434\u043e\u0431\u043d\u044b\u0445 \u043e\u0448\u0438\u0431\u043e\u043a \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c.");
            }
            size = this.report.length();
            this.checkErrors(prevMonth, this.conSlave);
            this.checkErrors(month, this.conSlave);
            String subject = this.report.length() == 0 ? "\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f => \u041e\u041a" : "\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f => \u041e\u0448\u0438\u0431\u043a\u0438";
            String text = this.report.length() == 0 ? "\u041e\u0448\u0438\u0431\u043e\u043a \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e" : this.report.toString();
            this.log.info(subject);
            MailTaskBalanceValidator mailData = new MailTaskBalanceValidator();
            mailData.setRecipients(this.email);
            mailData.setSubject(subject);
            mailData.addTextPart("text", text);
            new MailMsg(this.setup).sendMessage(mailData);
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
        finally {
            ServerUtils.closeConnection(this.conSlave);
        }
    }

    private void checkSums(Calendar month, Connection conSlave) throws SQLException {
        Date dateFrom = TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getStartMonth((Calendar)month));
        Date dateTo = TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getEndMonth((Calendar)month));
        int yy = month.get(1);
        int mm = month.get(2) + 1;
        String query = null;
        PreparedStatement ps = null;
        query = "DROP TEMPORARY TABLE IF EXISTS _validator_payment_sum,_validator_charge_sum,_validator_account_sum,_validator_payment_sub_sum,_validator_charge_sub_sum,_validator_account_sub_sum,_validator_temp_balance";
        conSlave.createStatement().executeUpdate(query);
        query = "CREATE TEMPORARY TABLE _validator_temp_balance ( UNIQUE(cid) ) SELECT cid, summa2, summa3, summa4 FROM contract_balance WHERE mm=? AND yy=?";
        ps = conSlave.prepareStatement(query);
        ps.setInt(1, mm);
        ps.setInt(2, yy);
        ps.executeUpdate();
        ps.close();
        query = "CREATE TEMPORARY TABLE _validator_payment_sum ( UNIQUE(cid) ) SELECT cid, SUM(summa) AS summa FROM contract_payment WHERE dt>=? AND dt<=? GROUP BY cid";
        ps = conSlave.prepareStatement(query);
        ps.setDate(1, dateFrom);
        ps.setDate(2, dateTo);
        ps.executeUpdate();
        ps.close();
        query = "CREATE TEMPORARY TABLE _validator_payment_sub_sum ( UNIQUE(cid) ) SELECT contract.scid as cid, SUM(cp.summa) AS summa FROM contract_payment AS cp LEFT JOIN contract ON contract.id=cp.cid WHERE cp.dt>=? AND cp.dt<=? AND contract.scid > 0 AND contract.sub_mode=0 GROUP BY contract.scid";
        ps = conSlave.prepareStatement(query);
        ps.setDate(1, dateFrom);
        ps.setDate(2, dateTo);
        ps.executeUpdate();
        ps.close();
        query = "CREATE TEMPORARY TABLE _validator_charge_sum ( UNIQUE(cid) ) SELECT cid, SUM(summa) AS summa FROM contract_charge WHERE dt>=? AND dt<=? GROUP BY cid";
        ps = conSlave.prepareStatement(query);
        ps.setDate(1, dateFrom);
        ps.setDate(2, dateTo);
        ps.executeUpdate();
        ps.close();
        query = "CREATE TEMPORARY TABLE _validator_charge_sub_sum ( UNIQUE(cid) ) SELECT contract.scid as cid, SUM(cc.summa) AS summa FROM contract_charge AS cc LEFT JOIN contract ON contract.id=cc.cid WHERE cc.dt>=? AND cc.dt<=? AND contract.scid > 0 AND contract.sub_mode=0 GROUP BY contract.scid";
        ps = conSlave.prepareStatement(query);
        ps.setDate(1, dateFrom);
        ps.setDate(2, dateTo);
        ps.executeUpdate();
        ps.close();
        query = "CREATE TEMPORARY TABLE _validator_account_sum ( UNIQUE(cid) ) SELECT cid, SUM( ROUND(summa,2) ) AS summa FROM contract_account WHERE yy=? AND mm=? GROUP BY cid";
        ps = conSlave.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        ps.executeUpdate();
        ps.close();
        query = "CREATE TEMPORARY TABLE _validator_account_sub_sum ( UNIQUE(cid) ) SELECT contract.scid as cid, SUM( ROUND(summa,2) ) AS summa FROM contract_account as ca LEFT JOIN contract ON contract.id=ca.cid WHERE ca.yy=? AND ca.mm=? AND contract.scid > 0 AND contract.sub_mode=0 GROUP BY contract.scid";
        ps = conSlave.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        ps.executeUpdate();
        ps.close();
        query = "SELECT contract.id, IF(balance.summa2, balance.summa2, 0) as summa2, IF(balance.summa3, balance.summa3, 0) as summa3, IF(balance.summa4, balance.summa4, 0) as summa4, IF(payment.summa, payment.summa, 0) AS payment_summa, IF(account.summa, account.summa, 0) AS account_summa, IF(charge.summa, charge.summa, 0) AS charge_summa FROM contract LEFT JOIN _validator_temp_balance AS balance ON contract.id=balance.cid LEFT JOIN _validator_payment_sum AS payment ON contract.id=payment.cid LEFT JOIN _validator_account_sum AS account ON contract.id=account.cid LEFT JOIN _validator_charge_sum AS charge ON contract.id=charge.cid WHERE contract.scid >= 0 HAVING (summa2!=payment_summa) OR (summa3!=account_summa) OR (summa4!=charge_summa) LIMIT ?";
        ps = conSlave.prepareStatement(query);
        ps.setInt(1, 200);
        int cnt = 0;
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Check sums alarm " + rs.getString(1) + " " + rs.getString(2) + " " + rs.getString(3) + " " + rs.getString(4) + " " + rs.getString(5) + " " + rs.getString(6) + " " + rs.getString(7));
            }
            if (cnt++ == 0) {
                this.report.append("\n\n\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0440\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439/\u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432/\u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 ");
                this.report.append(TimeUtils.format((Calendar)month, (String)"yyyy.MM"));
                this.report.append(" \u0434\u043b\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u043a\u043e\u0434\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:");
            }
            this.report.append("\n");
            this.report.append(rs.getString(1));
            if (cnt != 200) continue;
            this.report.append("\n\u041f\u0435\u0440\u0435\u0447\u0435\u043d\u044c \u043a\u043e\u0434\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0443\u0441\u0435\u0447\u0435\u043d \u0434\u043e 200");
        }
        ps.close();
        if (cnt < 200) {
            query = "SELECT contract.id, IF(balance.summa2, balance.summa2, 0) as summa2, IF(balance.summa3, balance.summa3, 0) as summa3, IF(balance.summa4, balance.summa4, 0) as summa4, IF(payment.summa, payment.summa, 0) + IF(payment_sub.summa, payment_sub.summa, 0) AS payment_summa, IF(account.summa, account.summa, 0) + IF(account_sub.summa, account_sub.summa, 0) AS account_summa, IF(charge.summa, charge.summa, 0) + IF(charge_sub.summa, charge_sub.summa, 0) AS charge_summa FROM contract LEFT JOIN _validator_temp_balance AS balance ON contract.id=balance.cid LEFT JOIN _validator_payment_sum AS payment ON contract.id=payment.cid LEFT JOIN _validator_account_sum AS account ON contract.id=account.cid LEFT JOIN _validator_charge_sum AS charge ON contract.id=charge.cid LEFT JOIN _validator_payment_sub_sum AS payment_sub ON contract.id=payment_sub.cid LEFT JOIN _validator_account_sub_sum AS account_sub ON contract.id=account_sub.cid LEFT JOIN _validator_charge_sub_sum AS charge_sub ON contract.id=charge_sub.cid WHERE contract.scid = -1 HAVING (summa2!=payment_summa) OR (summa3!=account_summa) OR (summa4!=charge_summa) LIMIT ?";
            ps = conSlave.prepareStatement(query);
            ps.setInt(1, 200 - cnt);
            rs = ps.executeQuery();
            while (rs.next()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Check sums alarm " + rs.getString(1) + " " + rs.getString(2) + " " + rs.getString(3) + " " + rs.getString(4) + " " + rs.getString(5) + " " + rs.getString(6) + " " + rs.getString(7));
                }
                if (cnt++ == 0) {
                    this.report.append("\n\n\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u0440\u0430\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439/\u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432/\u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 ");
                    this.report.append(TimeUtils.format((Calendar)month, (String)"yyyy.MM"));
                    this.report.append(" \u0434\u043b\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u043a\u043e\u0434\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:");
                }
                this.report.append("\n");
                this.report.append(rs.getString(1));
                if (cnt != 200) continue;
                this.report.append("\n\u041f\u0435\u0440\u0435\u0447\u0435\u043d\u044c \u043a\u043e\u0434\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0443\u0441\u0435\u0447\u0435\u043d \u0434\u043e 200");
            }
            ps.close();
        }
        query = "DROP TEMPORARY TABLE IF EXISTS _validator_payment_sum,_validator_charge_sum,_validator_account_sum,_validator_payment_sub_sum,_validator_charge_sub_sum,_validator_account_sub_sum,_validator_temp_balance";
        conSlave.createStatement().executeUpdate(query);
    }

    private void checkRests(Calendar month, Connection conSlave) throws SQLException {
        int yy = month.get(1);
        int mm = month.get(2) + 1;
        String query = null;
        PreparedStatement ps = null;
        query = "DROP TEMPORARY TABLE IF EXISTS _validator_balance_dump";
        conSlave.createStatement().executeUpdate(query);
        query = "CREATE TEMPORARY TABLE _validator_balance_dump( UNIQUE(cid) ) SELECT cid, MAX(yy*12+(mm-1))%12 + 1 AS mm,FLOOR(MAX(yy*12+(mm-1)) / 12) AS yy FROM contract_balance WHERE (yy*12 + mm)<(?*12 + ?) GROUP BY cid";
        ps = conSlave.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        ps.executeUpdate();
        ps.close();
        query = "SELECT cb.cid, cb.summa1, (cbp.summa1 + cbp.summa2 - cbp.summa3 - cbp.summa4) AS summa_prev FROM contract_balance AS cb INNER JOIN _validator_balance_dump AS dump ON cb.cid=dump.cid INNER JOIN contract_balance AS cbp ON cb.cid=cbp.cid AND cbp.yy=dump.yy AND cbp.mm=dump.mm INNER JOIN contract on cb.cid=contract.id WHERE cb.yy=? AND cb.mm=? AND (contract.scid <= 0 OR contract.sub_mode = 1) HAVING cb.summa1!=summa_prev";
        ps = conSlave.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        int cnt = 0;
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            if (cnt++ == 0) {
                this.report.append("\n\n\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043d\u0430 \u043c\u0435\u0441\u044f\u0446 ");
                this.report.append(TimeUtils.format((Calendar)month, (String)"yyyy.MM"));
                this.report.append(" \u0434\u043b\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u043a\u043e\u0434\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:");
            }
            this.report.append("\n");
            this.report.append(rs.getString(1));
            if (cnt != 200) continue;
            this.report.append("\n\u041f\u0435\u0440\u0435\u0447\u0435\u043d\u044c \u043a\u043e\u0434\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0443\u0441\u0435\u0447\u0435\u043d \u0434\u043e 200");
        }
        query = "DROP TEMPORARY TABLE IF EXISTS _validator_balance_dump";
        conSlave.createStatement().executeUpdate(query);
    }

    private void checkErrors(Calendar month, Connection conSlave) throws SQLException {
        String dataLogErrorTable;
        int periodicProcessErrors = new PeriodicErrorManager(conSlave).getErrorCount(month.getTime());
        if (periodicProcessErrors > 0) {
            this.report.append("\n\n\u0412 \u0436\u0443\u0440\u043d\u0430\u043b\u0435 \u043e\u0448\u0438\u0431\u043e\u043a \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0432 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 ");
            this.report.append(TimeUtils.format((Calendar)month, (String)"yyyy.MM"));
            this.report.append(" \u0435\u0441\u0442\u044c ");
            this.report.append(periodicProcessErrors);
            this.report.append(" \u043e\u0448\u0438\u0431\u043e\u043a. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0445 \u0438 \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u0443 \u043b\u0438\u0431\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438, \u0435\u0441\u043b\u0438 \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u0443\u0436\u0435 \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0430.");
        }
        if (ServerUtils.tableExists(conSlave, dataLogErrorTable = "data_log_" + TimeUtils.format((Calendar)month, (String)"yyyyMM"))) {
            String query = "SELECT COUNT(*) FROM " + dataLogErrorTable;
            PreparedStatement ps = conSlave.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                this.report.append("\n\n\u0412 \u0436\u0443\u0440\u043d\u0430\u043b\u0435 \u043e\u0448\u0438\u0431\u043e\u043a \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043b\u043e\u0433\u043e\u0432 \u0437\u0430 \u043c\u0435\u0441\u044f\u0446 ");
                this.report.append(TimeUtils.format((Calendar)month, (String)"yyyy.MM"));
                this.report.append(" \u0435\u0441\u0442\u044c ");
                this.report.append(count);
                this.report.append(" \u043e\u0448\u0438\u0431\u043e\u043a. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0445, \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u0443 \u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043b\u043e\u0433\u0438.");
            }
            ps.close();
        }
    }
}

