/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import jakarta.servlet.http.HttpSession;
import java.time.LocalDateTime;
import java.util.Optional;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.Customer;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;

public class ActionContracts
extends AbstractAction {
    public ActionContracts() {
        super("contract");
    }

    @Override
    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        this.setResultParam("pageTitle", "\u041a\u043b\u0438\u0435\u043d\u0442. \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b.");
        this.setResultParam("jspPage", "contract/contracts.jsp");
    }

    @WebOperation(title="\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430")
    public void customer() throws BGException {
        CustomerDao customerDao = new CustomerDao(this.con);
        HttpSession httpSession = this.context.getRequest().getSession();
        Contract generalContract = (Contract)httpSession.getAttribute("contract_general");
        Optional<CustomerLink> optional = customerDao.getCustomerLink(generalContract.getId(), LocalDateTime.now());
        if (optional.isPresent()) {
            Customer customer = customerDao.getCustomer(optional.get().getCustomerId());
            JSONObject customerJSON = new JSONObject(customer.getData());
            if (customer.getCustomerType().equals((Object)Customer.CustomerType.FIZ_CUSTOMER)) {
                this.setResultParam("customerFioLast", customerJSON.optQuery("/customer/fio/last"));
                this.setResultParam("customerFioFirst", customerJSON.optQuery("/customer/fio/first"));
                this.setResultParam("customerFioMiddle", customerJSON.optQuery("/customer/fio/middle"));
                this.setResultParam("customerPhone", customerJSON.optQuery("/customer/contact/phone_1"));
                this.setResultParam("customerEmail", customerJSON.optQuery("/customer/contact/email_1"));
            } else if (customer.getCustomerType().equals((Object)Customer.CustomerType.JUR_CUSTOMER)) {
                this.setResultParam("customerName", customerJSON.optQuery("/customer/name"));
                this.setResultParam("customerOgrn", customerJSON.optQuery("/customer/ogrn"));
                this.setResultParam("customerDirector", customerJSON.optQuery("/customer/director/post") + " " + customerJSON.optQuery("/customer/director/fio"));
                this.setResultParam("customerInn", customerJSON.optQuery("/customer/inn") + " / " + customerJSON.optQuery("/customer/kpp"));
                this.setResultParam("customerPhone", customerJSON.optQuery("/customer/contact/phone_1"));
                this.setResultParam("customerEmail", customerJSON.optQuery("/customer/contact/email_1"));
            }
            this.setResultParam("customer", customer);
            this.setResultParam("customerJson", customerJSON.toString());
        }
        this.requestDispatcher(this.moduleName, "customer");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432")
    public void contracts() throws BGException {
        this.requestDispatcher(this.moduleName, "contract_list");
    }

    @WebOperation(title="\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    public void subcontracts() throws BGException {
        this.requestDispatcher(this.moduleName, "contract_sublist");
    }

    @WebOperation(title="\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440")
    public void changeContract() throws BGException {
        String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle().toUpperCase();
        ActionMessage message = new ActionMessage("", "", "?", "\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contractTitle);
        message.setOnClose("reload");
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }
}

