/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.customer.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.CellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyNameValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.Customer;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.customer.client.CustomerManagerPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;

public class CustomerEditor
extends BGEditorDialog<Customer> {
    private JPanel selectedPanel;
    private Color bgColor;
    private Color bgSelectColor;
    private JPanel contracts = new JPanel(new GridBagLayout());
    private CustomerManagerPanel customerManagerPanel;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private ParamTableModel paramTableModel = new ParamTableModel();

    public CustomerEditor(String title, Customer data, CustomerManagerPanel customerManagerPanel) {
        super(title, (Object)data);
        this.customerManagerPanel = customerManagerPanel;
    }

    public void doDialogPanel() {
        this.bgColor = UIManager.getColor("Table.background");
        this.bgSelectColor = new Color(UIManager.getDefaults().getColor("List.selectionBackground").getRGB());
        this.tabbedPane.add((Component)this.getParameterPanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.tabbedPane.add((Component)this.getContractPanel(), "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        try {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (CustomerEditor.this.selectedPanel != null) {
                        CustomerEditor.this.selectedPanel.setOpaque(false);
                        CustomerEditor.this.selectedPanel.repaint();
                    }
                    CustomerEditor.this.selectedPanel = (JPanel)e.getSource();
                    CustomerEditor.this.selectedPanel.setOpaque(true);
                    CustomerEditor.this.selectedPanel.setBackground(CustomerEditor.this.bgSelectColor);
                    CustomerEditor.this.selectedPanel.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JPanel panel = (JPanel)e.getSource();
                    panel.setOpaque(false);
                    panel.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CustomerEditor.this.selectedPanel = (JPanel)e.getComponent();
                        BGClientBase.getFrame().getTabbedPane().addContractEditorTab(Utils.parseInt((String)CustomerEditor.this.selectedPanel.getName()));
                    }
                }
            };
            JSONArray array = new JSONArray(this.customerManagerPanel.getContractParameterService().customerContracts(((Customer)this.data).getId(), null));
            array.forEach(a -> {
                JLabel label = new JLabel(((JSONObject)a).getString("title"));
                label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() * 1.7f));
                JPanel contractPanel = new JPanel(new GridBagLayout());
                contractPanel.setOpaque(false);
                contractPanel.setName(String.valueOf(((JSONObject)a).getInt("id")));
                contractPanel.add((Component)label, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 15, 5, 5), 0, 0));
                contractPanel.add((Component)new JLabel(((JSONObject)a).optString("period")), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
                contractPanel.addMouseListener(mouseAdapter);
                this.contracts.add((Component)contractPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            });
            this.contracts.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            ArrayList<KeyNameValue> values = new ArrayList<KeyNameValue>();
            JSONObject json = new JSONObject(((Customer)this.data).getData());
            if (((Customer)this.data).getCustomerType() == Customer.CustomerType.JUR_CUSTOMER) {
                this.addValue(Customer.CustomerJur.NAME, json, values);
                this.addValue(Customer.CustomerJur.INN, json, values);
                this.addValue(Customer.CustomerJur.KPP, json, values);
                this.addValue(Customer.CustomerJur.OGRN, json, values);
                this.addValue(Customer.CustomerJur.ADDRESS, json, values);
            }
            if (((Customer)this.data).getCustomerType() == Customer.CustomerType.FIZ_CUSTOMER) {
                this.addValue(Customer.CustomerFiz.LAST_NAME, json, values);
                this.addValue(Customer.CustomerFiz.FIRST_NAME, json, values);
                this.addValue(Customer.CustomerFiz.MIDDLE_NAME, json, values);
                this.addValue(Customer.CustomerFiz.INN, json, values);
                this.addValue(Customer.CustomerFiz.GENDER, json, values);
                this.addValue(Customer.CustomerFiz.BIRTHDAY, json, values);
            }
            this.paramTableModel.setData(values);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public boolean doApply() throws Exception {
        this.customerManagerPanel.performAction("refresh");
        return super.doApply();
    }

    private void addValue(Customer.CustomerJur customerJur, JSONObject json, List<KeyNameValue> values) {
        values.add(new KeyNameValue(customerJur.key(), customerJur.description(), (String)json.optQuery(customerJur.key())));
    }

    private void addValue(Customer.CustomerFiz customerFiz, JSONObject json, List<KeyNameValue> values) {
        values.add(new KeyNameValue(customerFiz.key(), customerFiz.description(), (String)json.optQuery(customerFiz.key())));
    }

    private JPanel getParameterPanel() {
        final BGUTable table = new BGUTable((TableModel)((Object)this.paramTableModel));
        table.setAutoRowHeight(true);
        table.setSelectionMode(0);
        table.setFont(table.getFont().deriveFont(table.getFont().getSize2D() * 1.3f));
        table.getDefaultEditor(String.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                KeyNameValue keyNameValue = (KeyNameValue)CustomerEditor.this.paramTableModel.getRows().get(table.getSelectedRow());
                String value = (String)((CellEditor)changeEvent.getSource()).getCellEditorValue();
                try {
                    ((ContractParameterService)((ClientContext)CustomerEditor.this.customerManagerPanel.getContext()).getWebService(ContractParameterService.class)).customerParameterUpdate(((Customer)CustomerEditor.this.data).getId(), keyNameValue.getKey(), value);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getContractPanel() {
        this.contracts.setBackground(this.bgColor);
        Dimension dimension = new Dimension(1000, 400);
        JScrollPane scrollPane = new JScrollPane(this.contracts);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    class ParamTableModel
    extends BGTableModel<KeyNameValue> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 250, 300, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", String.class, 200, 300, -1, "value", true, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(KeyNameValue val, int column) throws BGException {
            return super.getValue((Object)val, column);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            super.setValueAt(value, rowIndex, columnIndex);
        }
    }
}

