/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.dashboard.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.dashboard.common.bean.DashboardItem;
import ru.bitel.bgbilling.kernel.contract.dashboard.common.bean.DashboardItemType;

public class ActionDashboard
extends AbstractAction {
    public ActionDashboard() {
        super("contract");
    }

    @Override
    public void execute() throws BGException {
        this.setResultParam("contentType", (Object)ActionResultContentType.jsp);
        this.setResultParam("jspPage", "contract/dashboard.jsp");
    }

    public void paths() throws BGException {
        this.requestDispatcher(this.moduleName, "dashboard_paths");
    }

    public void list() throws BGException {
        ArrayList<DashboardItem> dashboardPaths = new ArrayList<DashboardItem>();
        String key = this.context.getRequest().getParameter("key");
        if (key != null && !"group0".equals(key)) {
            List dashboardItems = (List)this.context.getRequest().getAttribute("dashboardItems");
            this.setResultParam("dashboardItems", this.getListForKey(dashboardItems, "group0", key));
            this.getDashboardPaths(dashboardItems, key, dashboardPaths);
        }
        DashboardItem dashboardItem = new DashboardItem();
        dashboardItem.setTitle("\u0413\u041b\u0410\u0412\u041d\u0410\u042f");
        dashboardItem.setKey("group0");
        dashboardPaths.add(0, dashboardItem);
        this.context.getRequest().getSession().setAttribute("dashboardPaths", dashboardPaths);
        this.requestDispatcher(this.moduleName, "dashboard_list");
    }

    private boolean getDashboardPaths(List<DashboardItem> dashboardItems, String key, List<DashboardItem> dashboardPaths) {
        for (DashboardItem dashboardItem : dashboardItems) {
            if (key.equals(dashboardItem.getKey())) {
                dashboardPaths.add(0, dashboardItem);
                return true;
            }
            if (dashboardItem.getItemType() != DashboardItemType.FOLDER || !this.getDashboardPaths(dashboardItem.getSubItems(), key, dashboardPaths)) continue;
            dashboardPaths.add(0, dashboardItem);
            return true;
        }
        return false;
    }

    private List<DashboardItem> getListForKey(List<DashboardItem> dashboardItems, String parentKey, String key) {
        for (DashboardItem dashboardItem : dashboardItems) {
            List<DashboardItem> list;
            if (key.equals(dashboardItem.getKey())) {
                if (parentKey != null) {
                    this.setResultParam("dashboardParentGroupKey", parentKey);
                }
                return dashboardItem.getSubItems();
            }
            if (dashboardItem.getItemType() != DashboardItemType.FOLDER || (list = this.getListForKey(dashboardItem.getSubItems(), dashboardItem.getKey(), key)) == null) continue;
            return list;
        }
        return null;
    }
}

