/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectParam;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractObjectParamDao
extends AbstractIdDao<ContractObjectParam>
implements Directory<ContractObjectParam> {
    public ContractObjectParamDao(Connection con) {
        super(con, 0, "object_param");
    }

    protected ContractObjectParam getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractObjectParam result = new ContractObjectParam();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setType(rs.getInt("type"));
        result.setComment(rs.getString("comment"));
        result.setHistory(rs.getBoolean("history"));
        return result;
    }

    protected void updateImpl(ContractObjectParam b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, type, comment, history) VALUES (?, ?, ?, ?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, type=?, comment=?, history=? WHERE id=?");
            ps.setInt(5, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setInt(2, b.getType());
        ps.setString(3, b.getComment());
        ps.setBoolean(4, b.isHistory());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public ContractObjectParam get(String title) throws BGException {
        return (ContractObjectParam)((Object)super.get("title=?", new Object[]{title}));
    }

    @Override
    public List<ContractObjectParam> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }
}

