/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.service;

import bitel.billing.server.contract.object.bean.ObjectParam;
import bitel.billing.server.contract.object.bean.ParamManager;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ObjectParameterService;
import ru.bitel.bgbilling.kernel.contract.object.server.utils.ObjectUtils;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.object.common.service.ObjectParameterService")
public class ObjectParameterServiceImpl
extends AbstractService
implements ObjectParameterService {
    private ParamManager parameterManager;

    @PostConstruct
    public void init() {
        this.parameterManager = new ParamManager(this.getConnection());
    }

    @Override
    public SearchResult<ContractObjectParam> searchObjectParam() throws BGException {
        SearchResult searchResult = new SearchResult();
        ArrayList<ContractObjectParam> list = new ArrayList<ContractObjectParam>();
        searchResult.setList(list);
        for (ObjectParam param : this.parameterManager.getParamList()) {
            ContractObjectParam contractObjectParam = new ContractObjectParam();
            contractObjectParam.setId(param.getId());
            contractObjectParam.setTitle(param.getTitle());
            contractObjectParam.setType(param.getTypeId());
            contractObjectParam.setComment(param.getComment());
            contractObjectParam.setHistory(param.isHistory());
            list.add(contractObjectParam);
        }
        return searchResult;
    }

    @Override
    public ContractObjectParam getObjectParam(int parameterId) throws BGException {
        return ObjectUtils.convertObjectParamToContractObjectParam(this.parameterManager.getParameter(parameterId));
    }

    @Override
    public void updateObjectParam(ContractObjectParam contractObjectParam) throws BGException {
        ObjectParam parameter = ObjectUtils.convertContractObjectParamToObjectParam(contractObjectParam);
        if (parameter != null) {
            this.parameterManager.updateParam(parameter);
        }
    }

    @Override
    public void deleteObjectParam(int id) throws BGException {
        this.parameterManager.deleteParam(id);
    }
}

