/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import jakarta.xml.ws.Holder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.event.UpdateContractEmailEvent;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.PhoneUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamPhoneData;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamPhoneTableCellEditor;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamPhoneTableModel;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamPhoneToolBar;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class ContractParamPhoneEditorDialog
extends BGEditorDialog<ContractParamEditorData> {
    private static final int FONT_SIZE = 14;
    private String formats = "";
    private int customLengthNumber = -1;
    private ParamPhoneTableModel tableModel = new ParamPhoneTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
    private ParamPhoneToolBar toolBar = new ParamPhoneToolBar(this.table, this.tableModel);
    private ParamPhoneTableCellEditor cellEditor;

    public ContractParamPhoneEditorDialog(String title, ContractParamEditorData data, String formats) {
        super(title, (Object)data);
        this.formats = formats;
    }

    public void doDialogPanel() {
        this.cellEditor = new ParamPhoneTableCellEditor(this.table, 14, this.customLengthNumber, this.formats);
        this.table.setDefaultEditor(this.table.getColumnClass(0), (TableCellEditor)this.cellEditor);
        this.table.setRowHeight(22);
        this.table.setFont(new Font("Dialog", 0, 14));
        this.table.setAutoResizeMode(2);
        this.panel.add((Component)new BGTitleLabel(((ContractParamEditorData)this.data).parameterTitle), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panel.add((Component)((Object)this.toolBar), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.table, (int)700, (int)300), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.tableModel.deleteRows();
        try {
            EntityAttrPhone attrPhone;
            EntityAttrPhone entityAttrPhone = attrPhone = ((ContractParamEditorData)this.data).value != null ? (EntityAttrPhone)((ContractParamEditorData)this.data).getValue() : (EntityAttrPhone)((ContractService)((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0)).contractParameterGet(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId);
            if (attrPhone != null) {
                attrPhone.getContactList().forEach(a -> this.tableModel.addRow(new ParamPhoneData(a.getPhone(), a.getComment())));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public boolean doApply() throws Exception {
        this.cellEditor.stopCellEditing();
        EntityAttrPhone attrPhone = new EntityAttrPhone(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId);
        this.tableModel.getRows().forEach(a -> attrPhone.addContact(a.getPhone(), a.getComment()));
        switch (((ContractParamEditorData)this.data).entityType) {
            case CONTRACT_PARAMETER: {
                ((ContractService)((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0)).contractParameterPhoneUpdate(((ContractParamEditorData)this.data).contractId, attrPhone);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ContractParamEditorData)this.data).contractId));
                EventBus.publish((Object)new UpdateContractEmailEvent(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId));
                break;
            }
            case NEW_CONTRACT_PARAMETER: {
                ((ContractParamEditorData)this.data).value = attrPhone.getContactList() == null || attrPhone.getContactList().isEmpty() ? null : attrPhone;
                break;
            }
        }
        return true;
    }

    class PhonePopup
    extends JPanel {
        private int index;
        private Popup popup;
        private String[] prefix;
        private List<JLabel> labels;
        private BGTextField phoneField;
        private Color color;
        private Color selectedColor;

        PhonePopup(BGTextField phoneField, String prefixs) {
            super(new GridBagLayout());
            this.index = -1;
            this.prefix = null;
            this.labels = new ArrayList<JLabel>();
            this.color = new Color(240, 240, 240);
            this.selectedColor = new Color(200, 200, 255);
            this.setBackground(this.color);
            this.phoneField = phoneField;
            int gridy = 0;
            int height = 0;
            if (prefixs != null) {
                for (String p : this.prefix = prefixs.split(",")) {
                    JLabel label = new JLabel(p);
                    label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
                    label.setOpaque(true);
                    label.setBackground(this.color);
                    this.labels.add(label);
                    this.add((Component)this.labels.get(gridy), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                    height += label.getPreferredSize().height;
                }
            }
            this.setPreferredSize(new Dimension(phoneField.getSize().width, height));
        }

        Popup getPopup() {
            if (this.popup == null) {
                Point p = this.phoneField.getLocationOnScreen();
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                this.popup = popupFactory.getPopup((Component)this.phoneField, this, p.x, p.y + this.phoneField.getSize().height);
            }
            return this.popup;
        }

        void update(String text) {
            Holder i = new Holder((Object)0);
            this.labels.forEach(e -> {
                e.setText(this.getPhone(this.prefix[(Integer)i.value], text));
                i.value = (Integer)i.value + 1;
            });
        }

        void select() {
            if (this.index > -1) {
                this.phoneField.setText(this.labels.get(this.index).getText());
                this.popup.hide();
            }
        }

        private String getPhone(String prefix, String value) {
            Object phoneText = prefix + value.replaceAll("[^\\d]", "");
            if (((String)phoneText).length() > 11 && ((String)phoneText).length() > ContractParamPhoneEditorDialog.this.customLengthNumber) {
                phoneText = ((String)phoneText).substring(0, Math.max(11, ContractParamPhoneEditorDialog.this.customLengthNumber));
            }
            if (((String)phoneText).length() > 14) {
                phoneText = ((String)phoneText).substring(0, 14);
            }
            return PhoneUtils.getPhones((EntityAttrPhone)new EntityAttrPhone(0, 0, (String)phoneText, ""), (String)ContractParamPhoneEditorDialog.this.formats);
        }

        void selectedMove(int step) {
            this.index += step;
            if (this.index < 0) {
                this.index = this.labels.size() - 1;
            } else if (this.index > this.labels.size() - 1) {
                this.index = 0;
            }
            this.labels.forEach(e -> e.setBackground(this.color));
            this.labels.get(this.index).setBackground(this.selectedColor);
        }
    }
}

