/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;

public class ContractParamServiceEditorDialog
extends BGEditorDialog<ContractParamEditorData> {
    private String service_id = null;
    private Vector<Properties> parameterList = new Vector();
    private DefaultListModel<ListItem> listModel = new DefaultListModel();
    private JList<ListItem> serviceList = new JList<ListItem>(this.listModel);
    private BGControlPanelListSelect addressPanel = new BGControlPanelListSelect();

    public ContractParamServiceEditorDialog(String title, ContractParamEditorData data) {
        super(title, (Object)data);
    }

    public void doDialogPanel() {
        this.panel.add((Component)new BGTitleLabel(((ContractParamEditorData)this.data).parameterTitle), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.getServicePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ServiceList");
        request.setContractId(((ContractParamEditorData)this.data).contractId);
        request.setAttribute("pid", ((ContractParamEditorData)this.data).parameterId);
        this.setDocument(TransferManager.getDocument((Request)request));
    }

    public boolean doApply() throws Exception {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.parameterList.size(); ++i) {
            Properties prop = this.parameterList.elementAt(i);
            buf.append(prop.getProperty("id"));
            buf.append("=");
            buf.append(prop.getProperty("sid"));
            buf.append(";");
        }
        Request request = new Request();
        request.setModule("contract");
        request.setAction("UpdateServiceInfo");
        request.setAttribute("pid", ((ContractParamEditorData)this.data).parameterId);
        request.setContractId(((ContractParamEditorData)this.data).contractId);
        request.setAttribute("value", buf.toString());
        boolean result = ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request));
        EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ContractParamEditorData)this.data).contractId));
        return result;
    }

    private JPanel getServicePanel() {
        this.serviceList.setSelectionMode(0);
        this.serviceList.addListSelectionListener(e -> this.serviceList_valueChanged(e));
        JPanel servicePanel = new JPanel(new GridBagLayout());
        servicePanel.setBorder((Border)new BGTitleBorder(" \u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0438\u0435 \u043b\u0438\u0446\u0430 "));
        servicePanel.add((Component)BGSwingUtilites.wrapScrollPane(this.serviceList, (int)300, (int)200), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        Dimension dimension = new Dimension(400, 200);
        this.addressPanel.setBorder((Border)new BGTitleBorder(" \u0410\u0434\u0440\u0435\u0441\u0430 "));
        this.addressPanel.addPropertyChangeListener(e -> this.addressPanel_propertyChange(e));
        this.addressPanel.setMinimumSize(dimension);
        this.addressPanel.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)servicePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.addressPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList(this.serviceList, (Node)XMLUtils.selectNode((Node)doc, (String)"//serviceList"));
            this.addressPanel.getList().setModel(new DefaultListModel());
            this.parameterList = new Vector();
            Element node = XMLUtils.selectElement((Node)doc, (String)"//parameterList");
            if (node != null && node.hasChildNodes()) {
                for (Element item : XMLUtils.elements((NodeList)node.getChildNodes())) {
                    Properties prop = new Properties();
                    prop.setProperty("id", XMLUtils.getAttribute((Element)item, (String)"id", null));
                    prop.setProperty("sid", XMLUtils.getAttribute((Element)item, (String)"sid", null));
                    prop.setProperty("title", XMLUtils.getAttribute((Element)item, (String)"title", null));
                    this.parameterList.addElement(prop);
                }
            }
        }
    }

    private void serviceList_valueChanged(ListSelectionEvent e) {
        this.listModel = (DefaultListModel)this.serviceList.getModel();
        if (!this.serviceList.isSelectionEmpty()) {
            int index = this.serviceList.getMinSelectionIndex();
            ListItem li = this.listModel.elementAt(index);
            this.service_id = (String)li.getAttribute("id");
            if (this.service_id != null && this.parameterList != null && this.parameterList.size() > 0) {
                DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
                for (int i = 0; i < this.parameterList.size(); ++i) {
                    Properties prop = this.parameterList.elementAt(i);
                    String sid = prop.getProperty("sid", null);
                    boolean check = this.service_id.equals(sid);
                    if (sid != null && !check && !"0".equals(sid)) continue;
                    ListItem item = new ListItem(prop.getProperty("title", "-"), check);
                    item.setAttribute("prop", (Object)prop);
                    model.addElement(item);
                }
                this.addressPanel.getList().setModel(model);
            }
        }
    }

    void addressPanel_propertyChange(PropertyChangeEvent e) {
        if (this.service_id == null) {
            return;
        }
        if ("itemChange".equals(e.getPropertyName())) {
            DefaultListModel model = (DefaultListModel)this.addressPanel.getList().getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ListItem item = (ListItem)model.getElementAt(i);
                Properties prop = (Properties)item.getAttribute("prop");
                prop.setProperty("sid", item.isSelected() ? this.service_id : "0");
            }
        }
    }
}

