/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamPanel;

public class CustomerParamTextArea
extends JTextArea {
    private String title = "";
    private String oldValue = "";
    private String fieldKey = null;
    private CustomerParamPanel customerParamPanel = null;

    public CustomerParamTextArea(String title, int row, int column, final String fieldKey, final String regexp, final CustomerParamPanel customerParamPanel) {
        super(row, column);
        this.title = title;
        this.fieldKey = fieldKey;
        this.customerParamPanel = customerParamPanel;
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setMargin(new Insets(3, 3, 3, 3));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = CustomerParamTextArea.this.getText();
                if (((ClientContext)customerParamPanel.getContext()).getCustomerId() > 0 && !CustomerParamTextArea.this.oldValue.equals(text)) {
                    if (regexp != null && !text.matches(regexp)) {
                        ClientUtils.showErrorMessageDialog((String)("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u0443 - " + regexp));
                        return;
                    }
                    customerParamPanel.updateCustomerValue(fieldKey, text);
                    CustomerParamTextArea.this.oldValue = text;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void setData() {
        Object object = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery(this.fieldKey);
        this.oldValue = object == null ? "" : String.valueOf(object);
        this.setText(this.oldValue);
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getTitle() {
        return this.title;
    }
}

