/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.ConfigParameter;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class PatternMasterPanel
extends BGUPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTabbedPane parameterTabbedPane = new JTabbedPane();
    private BGUList<IdTitle> requiredParameterList = new BGUList();
    private BGUList<IdTitle> optionalParameterList = new BGUList();
    private BGUList<IdTitle> availableParameterList = new BGUList();
    private DynamicClassChooser dynamicClassChooser = new DynamicClassChooser(true);
    private ConfigParameterTableModel configParameterTableModel = new ConfigParameterTableModel();
    private ButtonGroup tariifButtonGroup = new ButtonGroup();
    private List<IdTitle> contractParameterValues = new ArrayList<IdTitle>();
    private Set<Integer> requiredParameterIds = new HashSet<Integer>();
    private Set<Integer> optionalParameterIds = new HashSet<Integer>();

    protected void jbInit() throws Exception {
        this.tabbedPane.add((Component)this.getParameterSelectPanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.tabbedPane.add((Component)this.getTariffSelectPanel(), "\u0412\u044b\u0431\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430");
        this.tabbedPane.add((Component)this.getHandlerParameterPanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430");
        this.setLayout(new GridBagLayout());
        this.add(this.getMasterTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.add(this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getMasterTopPanel() {
        String iface = "ru.bitel.bgbilling.kernel.contract.pattern.server.bean.PatternContractMasterHandler";
        this.dynamicClassChooser.setIfaceName("ru.bitel.bgbilling.kernel.contract.pattern.server.bean.PatternContractMasterHandler");
        this.dynamicClassChooser.setSuperclassName("ru.bitel.bgbilling.kernel.contract.pattern.server.bean.PatternContractMasterHandlerAdapter");
        this.dynamicClassChooser.setDerivingIfaces(Collections.singleton("ru.bitel.bgbilling.kernel.contract.pattern.server.bean.PatternContractMasterHandler"));
        this.dynamicClassChooser.setSelectHandler((className, ifaceName) -> {
            try {
                this.configParameterTableModel.setData(((ContractService)((ClientContext)this.getContext()).getWebService(ContractService.class, 0)).configParameterList(className.getClassName()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        this.dynamicClassChooser.refresh((ClientContext)this.getContext());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new BGTitleLabel("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043c\u0430\u0441\u0442\u0435\u0440\u0430"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 50, 0, 0), 0, 0));
        panel.add((Component)((Object)this.dynamicClassChooser), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getHandlerParameterPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.configParameterTableModel));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getParameterSelectPanel() {
        ParamItemCellRenderer cellRenderer = new ParamItemCellRenderer();
        this.requiredParameterList.setCellRenderer((ListCellRenderer)cellRenderer);
        this.optionalParameterList.setCellRenderer((ListCellRenderer)cellRenderer);
        this.parameterTabbedPane.add((Component)BGSwingUtilites.wrapScrollPane(this.requiredParameterList, (int)200, (int)300), "\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435");
        this.parameterTabbedPane.add((Component)BGSwingUtilites.wrapScrollPane(this.optionalParameterList, (int)200, (int)300), "\u041e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.parameterTabbedPane, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        panel.add((Component)this.availableParameterPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTariffSelectPanel() {
        TariffButton noTariff = new TariffButton("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444", "noTariff", this.tariifButtonGroup, false);
        TariffButton noSelectTariff = new TariffButton("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444 \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430", "noSelectTariff", this.tariifButtonGroup, true);
        TariffButton selectTariffFromGroup = new TariffButton("\u0412\u044b\u0431\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430 \u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b", "selectTariffFromGroup", this.tariifButtonGroup, false);
        TariffButton selectTariffFromList = new TariffButton("\u0412\u044b\u0431\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430", "selectTariffFromList", this.tariifButtonGroup, false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)noTariff, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        panel.add((Component)noSelectTariff, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)selectTariffFromGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)selectTariffFromList, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        JButton addButton = new JButton("<<<");
        addButton.addActionListener(e -> {
            this.availableParameterList.getSelectedValuesList().forEach(a -> (this.parameterTabbedPane.getSelectedIndex() == 0 ? this.requiredParameterIds : this.optionalParameterIds).add(a.getId()));
            this.setListData();
        });
        JButton delButton = new JButton(">>>");
        delButton.addActionListener(e -> {
            (this.parameterTabbedPane.getSelectedIndex() == 0 ? this.requiredParameterList : this.optionalParameterList).getSelectedValuesList().forEach(a -> (this.parameterTabbedPane.getSelectedIndex() == 0 ? this.requiredParameterIds : this.optionalParameterIds).remove(a.getId()));
            this.setListData();
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(" "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)delButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel availableParameterPanel() {
        this.availableParameterList.setCellRenderer((ListCellRenderer)new ParamItemCellRenderer());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.availableParameterList, (int)200, (int)300), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setData(List<IdTitle> contractParameterValues) {
        this.contractParameterValues = contractParameterValues;
    }

    public void setValue(ContractPattern contractPattern) {
        this.dynamicClassChooser.clearSelection();
        if (Utils.notBlankString((String)contractPattern.getMasterHandlerClass())) {
            this.dynamicClassChooser.setSelectedItem(contractPattern.getMasterHandlerClass());
        }
        this.requiredParameterIds = contractPattern.getMasterRequiredParameterIds();
        this.optionalParameterIds = contractPattern.getMasterOptionalParameterIds();
        this.tariifButtonGroup.getElements().asIterator().forEachRemaining(a -> {
            if (a.getActionCommand().equals(contractPattern.getMasterTariffMode())) {
                a.setSelected(true);
            }
        });
        this.tabbedPane.setSelectedIndex(0);
        this.parameterTabbedPane.setSelectedIndex(0);
        this.setListData();
    }

    public String getHandlerClass() {
        return this.dynamicClassChooser.getSelectedClass();
    }

    public Set<Integer> getMasterRequiredParameterIds() {
        return this.requiredParameterIds;
    }

    public Set<Integer> getMasterOptionalParameterIds() {
        return this.optionalParameterIds;
    }

    public String getMasterTariffMode() {
        return this.tariifButtonGroup.getSelection().getActionCommand();
    }

    private void setListData() {
        this.requiredParameterList.setData(this.contractParameterValues.stream().filter(a -> this.requiredParameterIds.contains(a.getId())).toList());
        this.optionalParameterList.setData(this.contractParameterValues.stream().filter(a -> this.optionalParameterIds.contains(a.getId())).toList());
        this.availableParameterList.setData(this.contractParameterValues.stream().filter(a -> !this.requiredParameterIds.contains(a.getId()) && !this.optionalParameterIds.contains(a.getId())).toList());
    }

    class ConfigParameterTableModel
    extends BGTableModel<ConfigParameter> {
        public ConfigParameterTableModel() {
            super(ConfigParameterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 200, -1, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, 200, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", 200, 200, -1, "defaultValue", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public static class ParamItemCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            IdTitle val = (IdTitle)value;
            int pos = val.getTitle().lastIndexOf(91);
            String title = val.getTitle().substring(0, pos).trim();
            String type = val.getTitle().substring(pos);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(true);
            panel.add((Component)new JLabel(title), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 3, 2, 3), 0, 0));
            panel.add((Component)new JLabel(type), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 3, 2, 3), 0, 0));
            panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            panel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return panel;
        }
    }

    class TariffButton
    extends JRadioButton {
        public TariffButton(String text, String actionCommand, ButtonGroup buttonGroup, boolean selected) {
            super(text, selected);
            this.setActionCommand(actionCommand);
            buttonGroup.add(this);
        }
    }
}

