/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class PatternObjectsTabPanel
extends PatternBaseTabPanel {
    private static final String TABLE_PATTERN_OBJECTS = "pattern_objects";
    private static final String OBJECTS_NODE = "objects";
    private BGTable objectTable = new BGTable();
    private JPanel editorPanel = new JPanel(new GridBagLayout());
    private BGComboBox<ComboBoxItem> objectsCB = new BGComboBox();
    private IntTextField amountTF = new IntTextField();
    private Map<Integer, String> objectDictionary;

    public PatternObjectsTabPanel(Document moduleDoc) {
        this.objectTable.setHeader(this.rb_name, moduleDoc, TABLE_PATTERN_OBJECTS);
        Dimension size = new Dimension(60, 24);
        this.amountTF.setPreferredSize(size);
        this.amountTF.setMinimumSize(size);
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternObjectsTabPanel.this.okCancelAction(e);
            }
        });
        JPanel topPanel = new JPanel(new GridBagLayout());
        Dimension buttonSize = new Dimension(24, 24);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternObjectsTabPanel.this.newEditDeleteButtonsPressed(e);
            }
        };
        JButton newButton = new JButton(ClientUtils.getIcon((String)"item_add.png"));
        newButton.setPreferredSize(buttonSize);
        newButton.setBorderPainted(false);
        newButton.setActionCommand("new");
        newButton.addActionListener(al);
        JButton editButton = new JButton(ClientUtils.getIcon((String)"item_edit.png"));
        editButton.setPreferredSize(buttonSize);
        editButton.setBorderPainted(false);
        editButton.setActionCommand("edit");
        editButton.addActionListener(al);
        JButton deleteButton = new JButton(ClientUtils.getIcon((String)"item_delete.png"));
        deleteButton.setPreferredSize(buttonSize);
        deleteButton.setBorderPainted(false);
        deleteButton.setActionCommand("delete");
        deleteButton.addActionListener(al);
        topPanel.add((Component)newButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        topPanel.add((Component)editButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        topPanel.add((Component)deleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editorPanel.add((Component)new JLabel("\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)this.objectsCB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)this.amountTF, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.objectTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.setVisible(false);
    }

    private void okCancelAction(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            if (this.objectsCB.getSelectedIndex() < 0) {
                this.editorPanel.setVisible(false);
                return;
            }
            if (Utils.parseInt((String)this.amountTF.getText()) <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f!");
                return;
            }
            int type = Utils.parseInt((String)ClientUtils.getIdFromComboBox(this.objectsCB));
            for (int i = 0; i < this.objectTable.getRowCount(); ++i) {
                int rowType = Utils.parseInt((String)((String)this.objectTable.getValueAt(i, 0)));
                if (rowType != type) continue;
                this.objectTable.removeRow(i);
                break;
            }
            String amount = this.amountTF.getText();
            String title = this.objectDictionary.get(type);
            Vector<String> rowData = new Vector<String>();
            rowData.add(String.valueOf(type));
            rowData.add(amount);
            rowData.add(title);
            this.objectTable.addRow(rowData);
        } else if ("cancel".equals(e.getActionCommand())) {
            // empty if block
        }
        this.editorPanel.setVisible(false);
    }

    private void newEditDeleteButtonsPressed(ActionEvent actionEvent) {
        if ("new".equals(actionEvent.getActionCommand())) {
            this.editorPanel.setVisible(true);
            if (this.objectsCB.getItemCount() > 0) {
                this.objectsCB.setSelectedIndex(0);
            }
            this.amountTF.setText("0");
        } else if ("delete".equals(actionEvent.getActionCommand())) {
            int row = this.objectTable.getSelectedRow();
            if (row < 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0442\u0430\u0431\u043b\u0438\u0446\u044b?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 1) {
                return;
            }
            this.objectTable.removeRow(row);
        } else if ("edit".equals(actionEvent.getActionCommand())) {
            String id = ClientUtils.getRowId((BGTable)this.objectTable);
            if (id == null) {
                return;
            }
            int size = this.objectsCB.getItemCount();
            for (int i = 0; i < size; ++i) {
                ComboBoxItem item = (ComboBoxItem)this.objectsCB.getItemAt(i);
                String cur_id = (String)item.getObject();
                if (!cur_id.equals(id)) continue;
                this.objectsCB.setSelectedIndex(i);
                break;
            }
            int row = this.objectTable.getSelectedRow();
            String amount = (String)this.objectTable.getValueAt(row, 1);
            this.amountTF.setText(amount);
            this.editorPanel.setVisible(true);
        }
    }

    @Override
    public void setData(Document doc) {
        Node objectNode = XMLUtils.selectNode((Node)doc, (String)"//objects");
        ClientUtils.buildComboBox(this.objectsCB, (Node)objectNode, null);
        NodeList nl = objectNode.getChildNodes();
        int size = nl.getLength();
        this.objectDictionary = new HashMap<Integer, String>(size);
        for (int i = 0; i < size; ++i) {
            Element child = (Element)nl.item(i);
            if (!"item".equals(child.getNodeName())) continue;
            int id = Utils.parseInt((String)child.getAttribute("id"));
            String title = child.getAttribute("title");
            this.objectDictionary.put(id, title);
        }
    }

    @Override
    public void setPatternData(Element pattern) {
        this.objectTable.removeRows();
        Element objects = XMLUtils.selectElement((Node)pattern, (String)"//objects");
        if (objects != null) {
            NodeList objectNodes = objects.getElementsByTagName("object");
            for (int i = 0; i < objectNodes.getLength(); ++i) {
                Element child = (Element)objectNodes.item(i);
                int type = Utils.parseInt((String)child.getAttribute("type"));
                int amount = Utils.parseInt((String)child.getAttribute("amount"));
                String title = this.objectDictionary.get(type);
                Vector<String> rowData = new Vector<String>();
                rowData.add(String.valueOf(type));
                rowData.add(String.valueOf(amount));
                rowData.add(title);
                this.objectTable.addRow(rowData);
            }
        }
    }

    @Override
    public void setPatternData(ContractPattern contractPattern) {
    }

    @Override
    public void resetData() {
        this.objectTable.removeRows();
    }

    @Override
    public boolean setRequestData(Request request) {
        Object objects = "";
        for (int i = 0; i < this.objectTable.getRowCount(); ++i) {
            if (Utils.notBlankString((String)objects)) {
                objects = (String)objects + ",";
            }
            objects = (String)objects + this.objectTable.getValueAt(i, 0) + ":" + this.objectTable.getValueAt(i, 1);
        }
        request.setAttribute(OBJECTS_NODE, (String)objects);
        return true;
    }
}

