/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.status.client.ClientStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusControlPanel;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.MonitorStatusResult;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ServiceService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ContractStatusMonitorPanel
extends BGUPanel {
    private ContractLabelTree groupTree = new ContractLabelTree();
    private ContractLabelTree notGroupTree = new ContractLabelTree();
    private BGControlPanelListSelect serviceList = new BGControlPanelListSelect();
    private BGControlPanelListSelect statusList = new BGControlPanelListSelect();
    private FloatTextField serviceMax = new FloatTextField(7);
    private JLabel countLabel = new JLabel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private StatusControlPanel statusControl = new StatusControlPanel();
    private IntTextField saldoFromTf = new IntTextField();
    private IntTextField saldoToTf = new IntTextField();
    private JRadioButton modeCredit = new JRadioButton("\u043a\u0440\u0435\u0434\u0438\u0442", true);
    private JRadioButton modeDebet = new JRadioButton("\u0434\u0435\u0431\u0435\u0442");
    private JRadioButton modeAll = new JRadioButton("\u0432\u0441\u0435");
    private JCheckBox subContract = new JCheckBox("\u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u043c");
    private JCheckBox monthLimit = new JCheckBox("\u0431\u0430\u043b\u0430\u043d\u0441 < \u043b\u0438\u043c\u0438\u0442\u0430");
    private JCheckBox prevMonthLimit = new JCheckBox("\u0431\u0430\u043b\u0430\u043d\u0441 \u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430 < \u043b\u0438\u043c\u0438\u0442\u0430");
    private JCheckBox saldoCh = new JCheckBox("\u0441\u0430\u043b\u044c\u0434\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0430 ");
    private FloatTextField saldoTf = new FloatTextField();
    private IntTextField saldoMonths = new IntTextField();
    private BGComboBox<ComboBoxItem> sort = new BGComboBox();
    private IntTextField statusPeriodTf = new IntTextField();
    private BGUTable table;
    private BGComboBox<ComboBoxItem> statusPeriodUnit = new BGComboBox();
    private BGSelectFilePanel selectFilePanel;
    private ContractStatusService contractStatusService = null;
    private MonitorStatusResultTableModel tableModel = new MonitorStatusResultTableModel();

    public ContractStatusMonitorPanel() {
        this.pagePanel.setKey(((Object)((Object)this)).getClass().getName());
    }

    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getLeftPanel(), (Component)this.getRightPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getLeftPanel() {
        JPanel accountPanel = new JPanel(new GridBagLayout());
        accountPanel.setMinimumSize(new Dimension(200, 100));
        accountPanel.setPreferredSize(new Dimension(230, 100));
        accountPanel.add((Component)this.getServiceMaxPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        accountPanel.add((Component)this.serviceList, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 2), 0, 0));
        JTabbedPane groupTab = new JTabbedPane();
        groupTab.setMinimumSize(new Dimension(200, 100));
        groupTab.setPreferredSize(new Dimension(230, 100));
        groupTab.addTab("\u041c\u0435\u0442\u043a\u0438", BGSwingUtilites.wrapPanel((JComponent)new JScrollPane(this.groupTree)));
        groupTab.addTab("\u0418\u0441\u043a\u043b. \u043c\u0435\u0442\u043a\u0438", BGSwingUtilites.wrapPanel((JComponent)new JScrollPane(this.notGroupTree)));
        groupTab.addTab("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430", accountPanel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)groupTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getServiceMaxPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("<html>\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0430\u043c \u0437\u0430 \u043f\u0440\u043e\u0448\u043b\u044b\u0439 \u0438 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446\u044b</html>"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("<="), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.serviceMax, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        BGButton saveButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        saveButton.addActionListener(e -> {
            try {
                this.save();
            }
            catch (IOException e1) {
                ClientUtils.showErrorMessageDialog((String)e1.getLocalizedMessage());
                e1.printStackTrace();
            }
        });
        this.selectFilePanel = new BGSelectFilePanel();
        this.selectFilePanel.setFileFilter("csv", "CSV File");
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() != 2) {
                    return;
                }
                ContractStatusMonitorPanel.this.openContract(((MonitorStatusResult)ContractStatusMonitorPanel.this.tableModel.getSelectedRow()).getContractId());
            }
        });
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.setTableModel(this.doFilter(this.pagePanel));
            }
        });
        this.statusControl.getOkButton().addActionListener(e -> this.changeStatus());
        JPanel countPanel = new JPanel(new GridBagLayout());
        countPanel.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        countPanel.add((Component)new JLabel("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        countPanel.add((Component)this.countLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        countPanel.add((Component)this.pagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        JTabbedPane filterStatusTabbedPane = new JTabbedPane();
        filterStatusTabbedPane.add((Component)this.getFilterPanel(), "\u0424\u0438\u043b\u044c\u0442\u0440");
        filterStatusTabbedPane.add((Component)((Object)this.statusControl), "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c");
        JPanel saveTablePanel = new JPanel(new GridBagLayout());
        saveTablePanel.setBorder((Border)new BGTitleBorder("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u0444\u0430\u0439\u043b"));
        saveTablePanel.add((Component)this.selectFilePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        saveTablePanel.add((Component)saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)filterStatusTabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)countPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)saveTablePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void save() throws IOException {
        if (this.tableModel.getRowCount() > 0) {
            File outFile = this.selectFilePanel.getSelectedFile();
            if (outFile == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                return;
            }
            BGControlPanelPages pp = new BGControlPanelPages();
            pp.setPageIndex(1);
            pp.setPageSize(0);
            SearchResult<MonitorStatusResult> result = this.doFilter(pp);
            ArrayList<String[]> lines = new ArrayList<String[]>();
            List msrList = result.getList();
            for (int row = 0; row < msrList.size(); ++row) {
                String[] line = new String[7];
                MonitorStatusResult r = (MonitorStatusResult)msrList.get(row);
                line[0] = String.valueOf(r.getContractId());
                line[1] = String.valueOf(r.getContractTitle());
                line[2] = String.valueOf(r.getContractComment());
                line[3] = String.valueOf(r.getStatus());
                line[4] = String.valueOf(r.getStatusDate());
                line[5] = String.valueOf(r.getStatusDateTo());
                line[6] = String.valueOf(r.getSaldo());
                lines.add(line);
            }
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outFile));
            CSVWriter csvWriter = new CSVWriter((Writer)writer, ';');
            csvWriter.writeAll(lines);
            csvWriter.flush();
            csvWriter.close();
            ((Writer)writer).close();
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430.", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
        } else {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u0447\u0435\u0433\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 2);
        }
    }

    private void changeStatus() {
        List selectedRows = this.tableModel.getSelectedRows();
        if (selectedRows.size() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
            return;
        }
        if (this.statusControl.getDateFrom() == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041f\u043e\u043c\u0435\u043d\u044f\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432?", "\u0421\u043c\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430", 0) == 0) {
            int[] cids = new int[selectedRows.size()];
            for (int i = 0; i < cids.length; ++i) {
                cids[i] = ((MonitorStatusResult)selectedRows.get(i)).getContractId();
            }
            ClientStatusUtil.changeStatusOnServer((Component)((Object)this), (ClientContext)this.getContext(), cids, this.statusControl.getStatusId(), this.statusControl.getDateFrom(), this.statusControl.getDateTo(), this.statusControl.getComment());
            this.setTableModel(this.doFilter(this.pagePanel));
        }
    }

    private JPanel getFilterPanel() {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.getStatusPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.getFilter1Panel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
        filterPanel.add((Component)this.getFilter2Panel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(5, 0, 5, 5), 0, 0));
        return filterPanel;
    }

    private JPanel getStatusPanel() {
        this.statusList.setBorder((Border)BorderFactory.createTitledBorder("\u0421\u0442\u0430\u0442\u0443\u0441"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.statusList, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFilter1Panel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.modeCredit);
        buttonGroup.add(this.modeDebet);
        buttonGroup.add(this.modeAll);
        this.statusPeriodTf.setMinValue(0L);
        this.statusPeriodTf.setMaxValue(1000L);
        this.statusPeriodTf.setText("0");
        this.statusPeriodUnit.addItem((Object)new ComboBoxItem((Object)"day", "\u0434\u043d\u0435\u0439 \u0438 \u0431\u043e\u043b\u0435\u0435"));
        this.statusPeriodUnit.addItem((Object)new ComboBoxItem((Object)"month", "\u043c\u0435\u0441\u044f\u0446\u0435\u0432 \u0438 \u0431\u043e\u043b\u0435\u0435"));
        this.saldoFromTf.setMinValue(-1000000L);
        this.saldoFromTf.setMaxValue(1000000L);
        this.saldoFromTf.setColumns(8);
        this.saldoToTf.setMinValue(-1000000L);
        this.saldoToTf.setMaxValue(1000000L);
        this.saldoToTf.setColumns(8);
        JPanel panelR1 = new JPanel(new FlowLayout(0, 5, 0));
        panelR1.add(new JLabel("\u0420\u0435\u0436\u0438\u043c:"));
        panelR1.add(this.modeCredit);
        panelR1.add(this.modeDebet);
        panelR1.add(this.modeAll);
        JPanel panelR2 = new JPanel(new FlowLayout(0, 5, 0));
        panelR2.add(new JLabel("\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"));
        panelR2.add(this.subContract);
        JPanel panelR3 = new JPanel(new FlowLayout(0, 5, 0));
        panelR3.add(new JLabel("\u041d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435: "));
        panelR3.add((Component)this.statusPeriodTf);
        panelR3.add((Component)this.statusPeriodUnit);
        JPanel panelR4 = new JPanel(new FlowLayout(0, 5, 0));
        panelR4.add(new JLabel("\u0421\u0430\u043b\u044c\u0434\u043e \u043e\u0442:"));
        panelR4.add((Component)this.saldoFromTf);
        panelR4.add(new JLabel("\u0434\u043e:"));
        panelR4.add((Component)this.saldoToTf);
        JPanel panelR5 = new JPanel(new GridBagLayout());
        panelR5.add((Component)this.saldoCh, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelR5.add((Component)this.saldoTf, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelR5.add((Component)new JLabel(" \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430 "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelR5.add((Component)this.saldoMonths, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelR5.add((Component)new JLabel(" \u043f\u0440\u0435\u0434. \u043c\u0435\u0441\u044f\u0446\u0435\u0432"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)panelR1, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)panelR2, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)panelR3, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)panelR4, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)this.monthLimit, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)this.prevMonthLimit, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)panelR5, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFilter2Panel() {
        this.sort.addItem((Object)new ComboBoxItem((Object)"", "----"));
        this.sort.addItem((Object)BGComboBox.SEPARATOR);
        this.sort.addItem((Object)new ComboBoxItem((Object)"saldo", "\u0441\u0443\u043c\u043c\u0430 \u0437\u0430\u0434\u043e\u043b\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u0438"));
        this.sort.addItem((Object)new ComboBoxItem((Object)"contract.status_date", "\u0441 \u0434\u0430\u0442\u044b"));
        this.sort.addItem((Object)new ComboBoxItem((Object)"contract.title", "\u043d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        this.sort.addItem((Object)new ComboBoxItem((Object)"contract.comment", "\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        JButton balanceDumpButton = new JButton("\u0421\u0440\u0435\u0437 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432");
        balanceDumpButton.addActionListener(e -> this.balanceDump());
        JButton showButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        showButton.addActionListener(e -> this.setTableModel(this.doFilter(this.pagePanel)));
        JPanel sortPanel = new JPanel(new GridBagLayout());
        sortPanel.add((Component)new JLabel("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        sortPanel.add((Component)this.sort, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)sortPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 5, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)balanceDumpButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)showButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void balanceDump() {
        try {
            this.getContractStatusService().createBalanceDump();
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0421\u0440\u0435\u0437 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private SearchResult<MonitorStatusResult> doFilter(BGControlPanelPages pagePanel) {
        int mode = -1;
        mode = this.modeAll.isSelected() ? -1 : (this.modeCredit.isSelected() ? 0 : 1);
        int statusPeriod = 0;
        if (!this.statusPeriodTf.getText().trim().isEmpty()) {
            statusPeriod = Integer.valueOf(this.statusPeriodTf.getText().trim());
        }
        StringBuilder status = new StringBuilder("");
        for (int i : this.statusList.getSelectedIds()) {
            if (status.length() > 0) {
                status.append(",");
            }
            status.append(i);
        }
        if (status.length() == 0) {
            status.append(this.statusList.getListValues());
        }
        int subContr = 0;
        if (this.subContract.isSelected()) {
            subContr = 1;
        }
        int saldoMonth = 0;
        BigDecimal saldo = BigDecimal.ZERO;
        if (this.saldoCh.isSelected()) {
            if (!this.saldoMonths.getText().isEmpty()) {
                saldoMonth = Integer.valueOf(this.saldoMonths.getText());
            }
            if (!this.saldoTf.getText().isEmpty()) {
                saldo = BigDecimal.valueOf(Double.valueOf(this.saldoTf.getText()));
            }
        }
        float serviceMaxVal = Utils.parseFloat((String)this.serviceMax.getText(), (float)-1.0f);
        HashSet<Integer> serviceAccountMax = new HashSet<Integer>();
        if (serviceMaxVal >= 0.0f) {
            for (int id : this.serviceList.getSelectedIds()) {
                serviceAccountMax.add(id);
            }
        }
        int balanceLimit = 0;
        if (this.monthLimit.isSelected()) {
            balanceLimit = 1;
        }
        int balancePrevLimit = 0;
        if (this.prevMonthLimit.isSelected()) {
            balancePrevLimit = 1;
        }
        SearchResult<MonitorStatusResult> serResult = null;
        try {
            serResult = this.getContractStatusService().contractSearch(mode, statusPeriod, this.statusPeriodUnit.getSelectedId(), this.groupTree.getSelectedItems(false), this.notGroupTree.getSelectedItems(false), status.toString(), this.saldoFromTf.getText(), this.saldoToTf.getText(), this.sort.getSelectedId(), subContr, pagePanel.getPage(), saldoMonth, saldo, serviceAccountMax, serviceMaxVal, balanceLimit, balancePrevLimit);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        return serResult;
    }

    private void setTableModel(SearchResult<MonitorStatusResult> result) {
        this.tableModel.setData(result.getList());
        this.pagePanel.setPage(result.getPage());
        this.countLabel.setText(String.valueOf(result.getPage().getRecordCount()));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "refresh"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ContractStatusMonitorPanel.this.groupTree.setData(((ContractLabelService)((ClientContext)ContractStatusMonitorPanel.this.getContext()).getPort(ContractLabelService.class)).getContractLabelTreeItemList(-1, false));
                ContractStatusMonitorPanel.this.notGroupTree.setData(((ContractLabelService)((ClientContext)ContractStatusMonitorPanel.this.getContext()).getPort(ContractLabelService.class)).getContractLabelTreeItemList(-1, false));
                ContractStatusMonitorPanel.this.statusControl.setStatusList(ContractStatusMonitorPanel.this.getContractStatusService().statusList());
                ArrayList<BGUListItem> serviceListItems = new ArrayList<BGUListItem>();
                for (Service service : ((ServiceService)((ClientContext)ContractStatusMonitorPanel.this.getContext()).getPort(ServiceService.class, 0)).serviceList(0)) {
                    serviceListItems.add(new BGUListItem(service.getId(), service.getTitle()));
                }
                ContractStatusMonitorPanel.this.serviceList.getList().setData(serviceListItems);
                ArrayList<BGUListItem> statusListItems = new ArrayList<BGUListItem>();
                for (Status status : ContractStatusMonitorPanel.this.getContractStatusService().getStatusList(false)) {
                    statusListItems.add(new BGUListItem(status.getId(), status.getTitle()));
                }
                ContractStatusMonitorPanel.this.statusList.getList().setData(statusListItems);
            }
        };
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = (ContractStatusService)((ClientContext)this.getContext()).getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    class MonitorStatusResultTableModel
    extends BGTableModel<MonitorStatusResult> {
        public MonitorStatusResultTableModel() {
            super(MonitorStatusResultTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("ID", 80, 80, 80, "contractId", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 200, 300, "contractTitle", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 100, -1, "contractComment", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 200, 200, 200, "status", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421 \u0434\u0430\u0442\u044b", 150, 150, 150, "statusDate", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e \u0434\u0430\u0442\u0443", 150, 150, 150, "statusDateTo", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0430\u043b\u044c\u0434\u043e", 150, 150, 150, "saldo", false).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }
    }
}

