/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.convert;

import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.util.MailMsg;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailConvertUtil;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.ScriptUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ConvertUtil
implements AutoCloseable {
    private DefaultServerSetup setup;
    private Connection con;
    private BalanceUtils balanceUtils;
    private ContractModuleManager contractModuleManager;
    private PaymentDao paymentDao;
    private ChargeDao chargeDao;
    private ContractStatusManager contractStatusManager;
    private MailMsg mailmsg;
    private ContractDao contractDao;

    public ConvertUtil(DefaultServerSetup setup, Connection con) throws BGException {
        this.setup = setup;
        this.con = con;
        this.balanceUtils = new BalanceUtils(con);
        this.contractModuleManager = new ContractModuleManager(con);
        this.paymentDao = new PaymentDao(con);
        this.chargeDao = new ChargeDao(con);
        this.contractStatusManager = new ContractStatusManager(con);
        this.mailmsg = new MailMsg(setup);
        this.contractDao = new ContractDao(con, 0);
    }

    @Override
    public void close() throws BGException {
        this.balanceUtils.close();
        this.contractStatusManager.recycle();
        this.contractDao.close();
    }

    @Deprecated
    public int removeContracts(int group) throws SQLException, BGException {
        return this.removeContracts(Utils.enumToMask((String)String.valueOf(group)));
    }

    @Deprecated
    public int removeContracts(long groups) throws SQLException, BGException {
        return this.removeContracts(groups, null);
    }

    @Deprecated
    public int removeContracts(long groups, String exceptIds) throws SQLException, BGException {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            int n = su.removeContracts(groups, exceptIds);
            return n;
        }
    }

    public void removeCerberCryptGarbage(int mid_cc) throws SQLException, BGException {
        String query = "SELECT uc.id, contract.id FROM user_card_" + mid_cc + " AS uc LEFT JOIN contract ON uc.cid = contract.id WHERE contract.id IS NULL";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        ArrayList<Integer> ucids = new ArrayList<Integer>();
        while (rs.next()) {
            ucids.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        query = "SELECT cp.id, contract.id FROM card_packet_" + mid_cc + " AS cp LEFT JOIN contract ON cp.cid = contract.id WHERE contract.id IS NULL";
        ps = this.con.prepareStatement(query);
        rs = ps.executeQuery();
        ArrayList<Integer> cpids = new ArrayList<Integer>();
        while (rs.next()) {
            cpids.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        if (ucids.size() > 0) {
            System.out.println("remove " + ucids.size() + " garbage user_card_" + mid_cc + "...");
            query = "DELETE FROM user_card_" + mid_cc + " WHERE id IN (" + Utils.toString(ucids) + ")";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        if (cpids.size() > 0) {
            System.out.println("remove " + cpids.size() + " garbage card_packet_" + mid_cc + "...");
            query = "DELETE FROM card_packet_" + mid_cc + " WHERE id IN (" + Utils.toString(cpids) + ")";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
    }

    @Deprecated
    public Map<String, Integer> getBillingTariffMap() throws Exception {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            Map<String, Integer> map = su.getBillingTariffMap();
            return map;
        }
    }

    public Map<Integer, Map<String, Map<String, Object>>> getBillingStreetMap() throws SQLException {
        HashMap<Integer, Map<String, Map<String, Object>>> result = new HashMap<Integer, Map<String, Map<String, Object>>>();
        String query = "SELECT id, title, cityid FROM address_street";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            HashMap<String, Object> map;
            int cityId = rs.getInt("cityid");
            String title = rs.getString("title");
            int streetId = rs.getInt("id");
            HashMap streets = (HashMap)result.get(cityId);
            if (streets == null) {
                streets = new HashMap();
                result.put(cityId, streets);
            }
            if ((map = (HashMap<String, Object>)streets.get(title.toLowerCase())) != null) continue;
            map = new HashMap<String, Object>();
            map.put("id", streetId);
            map.put("origin_title", title);
            streets.put(title.toLowerCase(), map);
        }
        rs.close();
        ps.close();
        return result;
    }

    @Deprecated
    public int addNewTariff(String title) throws Exception {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            int n = su.addNewTariff(title);
            return n;
        }
    }

    public static List<Map<String, String>> loadTxtDB(String filePath, String charsetName, String splitRegexp, String ... fields) throws UnsupportedEncodingException, IOException {
        String[] lines;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        StringBuffer strBuffer = new StringBuffer();
        try (FileInputStream stream = new FileInputStream(filePath);){
            int count = 0;
            byte[] buff = new byte[1024];
            while ((count = ((InputStream)stream).read(buff, 0, 1024)) > 0) {
                strBuffer.append(new String(buff, 0, count, charsetName));
            }
        }
        for (String line : lines = strBuffer.toString().split("\n")) {
            line = line.trim();
            HashMap<String, String> map = new HashMap<String, String>();
            String[] words = line.split(splitRegexp, -1);
            int idx = 0;
            for (String fieldName : fields) {
                map.put(fieldName, idx < words.length ? words[idx++].trim() : null);
            }
            result.add(map);
        }
        return result;
    }

    public Map<Integer, Map<String, Integer>> getBillingHouseMap(String delim) throws SQLException {
        HashMap<Integer, Map<String, Integer>> result = new HashMap<Integer, Map<String, Integer>>();
        String query = "SELECT streetid, house, id, frac FROM address_house";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int steetId = rs.getInt(1);
            int house = rs.getInt(2);
            int houseId = rs.getInt(3);
            String frac = rs.getString(4);
            HashMap<String, Integer> houses = (HashMap<String, Integer>)result.get(steetId);
            if (houses == null) {
                houses = new HashMap<String, Integer>();
                result.put(steetId, houses);
            }
            String key = ConvertUtil.getHouseKey(house, frac, delim);
            houses.put(key, houseId);
        }
        rs.close();
        ps.close();
        return result;
    }

    private static String getHouseKey(int house, String frac, String delim) {
        Object result = String.valueOf(house);
        if (frac != null) {
            frac = frac.trim();
        }
        if (!Utils.isEmptyString((String)frac)) {
            result = (String)result + delim + frac.toLowerCase();
        }
        return result;
    }

    public void setBalance(int cid, Date date) throws BGException {
        this.balanceUtils.updateBalance(date, cid);
    }

    public BigDecimal getBalance(Date time, int cid) throws BGException {
        return this.balanceUtils.getBalance(time, cid);
    }

    public Map<String, Map<String, Object>> getBillingCityMap() throws SQLException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        String query = "SELECT id, title FROM address_city";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String title = rs.getString("title");
            int cityId = rs.getInt("id");
            HashMap<String, Object> map = (HashMap<String, Object>)result.get(title.toLowerCase());
            if (map == null) {
                map = new HashMap<String, Object>();
                map.put("id", cityId);
                map.put("origin_title", title);
                result.put(title.toLowerCase(), map);
                continue;
            }
            System.err.println("dublicate city " + title);
        }
        rs.close();
        ps.close();
        return result;
    }

    public Map<String, Map<String, Object>> getBillingCountryMap() throws SQLException {
        HashMap<String, Map<String, Object>> tarifMap = new HashMap<String, Map<String, Object>>();
        String query = "SELECT id, title FROM address_country";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int id = rs.getInt(1);
            String title = rs.getString(2);
            map.put("id", id);
            map.put("origin_title", title);
            tarifMap.put(title.toLowerCase(), map);
        }
        rs.close();
        ps.close();
        return tarifMap;
    }

    @Deprecated
    public void addContractGroup(int cid, int group) throws BGException {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            su.addContractGroup(cid, group);
        }
    }

    @Deprecated
    public void addContractTariff(int cid, int tariffId, Date date1, String comment) throws BGException {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            su.addContractTariff(cid, tariffId, date1, comment);
        }
    }

    public void addContractModule(int cid, int mid) throws BGException {
        this.contractModuleManager.addContractModule(cid, mid);
    }

    @Deprecated
    public void addContractParameter(int cid, int pid, String value) throws BGException {
        this.addContractParameter(cid, pid, value, null);
    }

    @Deprecated
    public void addContractParameter(int cid, int pid, String value, String comment) throws BGException {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            su.addContractParameter(cid, pid, value, comment);
        }
    }

    @Deprecated
    public void addContractAddressParameter(int cid, int pid, int countryId, int cityId, int streetId, int houseId, String flat, String streetUserValue, String houseUserValue) throws Exception {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            su.addContractAddressParameter(cid, pid, countryId, cityId, streetId, houseId, flat, streetUserValue, houseUserValue);
        }
    }

    @Deprecated
    public String getContractParameter(int cid, int pid) throws BGException {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            String string = su.getContractParameter(cid, pid);
            return string;
        }
    }

    void updateNote(int cid, String title, String text) throws BGException {
        if (text == null) {
            return;
        }
        ContractNote note = new ContractNote();
        note.setTitle(title);
        note.setComment(text);
        note.setContractId(cid);
        note.setUserId(0);
        note.setVisible(false);
        note.setDateTime(LocalDateTime.now());
        try (ContractNoteDao noteDao = new ContractNoteDao(this.con);){
            noteDao.update((Object)note);
        }
    }

    public Contract createContract(int pattern_id, String title, String comment, Date date1) throws Exception {
        String passwd = PswdGen.generatePassword((ParameterMap)this.setup);
        ContractCreateData data = ContractCreateData.builder().setPatternId(pattern_id).setTitle(title).setDateFrom(date1).setPassword(passwd).build();
        Contract contract = this.contractDao.createFromPattern(data, true);
        if (contract != null && comment != null) {
            contract.setComment(comment);
            this.contractDao.update(contract);
        }
        return contract;
    }

    public void addContractPayment(int cid, int paymentTypeId, Date date, BigDecimal sum, String comment) throws BGException {
        this.paymentDao.update(Payment.builder().setDate(date).setContractId(cid).setTypeId(paymentTypeId).setUserId(0).setSum(sum).setComment(comment).build());
    }

    public void addContractCharge(int cid, int chargeTypeId, Date date, BigDecimal sum, String comment) throws BGException {
        Charge charge = new Charge();
        charge.setDate(date);
        charge.setContractId(cid);
        charge.setTypeId(chargeTypeId);
        charge.setUserId(0);
        charge.setSum(sum);
        charge.setComment(comment);
        this.chargeDao.update(charge);
    }

    public void closeContract(int contractId, Date date, boolean fast) throws SQLException, BGException {
        if (fast) {
            Contract contract = (Contract)this.contractDao.get(contractId);
            contract.setDateTo(date);
            this.contractDao.update(contract);
        } else {
            this.contractDao.closeContract(contractId, 0, 0, date);
        }
    }

    public void setStatus(int cid, int status, Date dateFrom, String comment) throws BGException {
        this.setStatus(cid, status, dateFrom, comment, false);
    }

    public void setStatus(int cid, int status, Date dateFrom, String comment, boolean processEvent) throws BGException {
        ContractStatus newStatus = new ContractStatus();
        newStatus.setContractId(cid);
        newStatus.setStatus(status);
        newStatus.setDateFrom(dateFrom);
        newStatus.setComment(comment);
        this.contractStatusManager.changeStatus(newStatus, 0, processEvent);
    }

    public Contract findContract(int pid, int houseId, String flat) throws SQLException, BGException {
        int contractId;
        Contract contract = null;
        String query = "SELECT cid FROM contract_parameter_type_2 WHERE pid=? AND hid=? AND flat=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setInt(2, houseId);
        ps.setString(3, flat);
        ResultSet rs = ps.executeQuery();
        if (rs.next() && (contract = (Contract)this.contractDao.get(contractId = rs.getInt(1))) == null) {
            System.err.println("error contract on contract_parameter_type_2.cid=" + contractId);
        }
        rs.close();
        ps.close();
        return contract;
    }

    public List<Contract> getContracts(long groupMask) throws BGException {
        ContractFilters contractFilters = ContractFilters.builder().setTitle(null).setComment(null).setFc(-2).setGroupMask(groupMask).setSubContracts(true).setClosed(false).setHidden(false).build();
        return this.contractDao.list(contractFilters, null, "title", null);
    }

    @Deprecated
    public static void removeContractsMultiThread(Connection con, Setup setup, int group, String exceptIds, int theadCount) throws SQLException, BGException {
        try (ScriptUtils su = new ScriptUtils(setup, con);){
            su.removeContractsMultiThread(group, exceptIds, theadCount);
        }
    }

    @Deprecated
    public void setGroup(int cid, int group) throws BGException {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            su.addContractGroup(cid, group);
        }
    }

    @Deprecated
    public void unsetGroup(int contractId, int group) throws BGException {
        try (ScriptUtils su = new ScriptUtils(this.setup, this.con);){
            su.deleteContractGroup(contractId, group);
        }
    }

    public void sendMail(String email, String subject, String body) {
        try {
            MailConvertUtil mailData = new MailConvertUtil();
            mailData.setRecipients(email);
            mailData.setSubject(subject);
            mailData.addTextPart("text", body);
            this.mailmsg.sendMessage(mailData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

