/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.directory.api.common.service.DirectoryService;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterDao;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.directory.api.common.service.DirectoryService")
public class DirectoryServiceImpl
extends AbstractService
implements DirectoryService {
    @Override
    public long getVersion(Class<? extends Id> directoryItemClass, int moduleId) throws BGException {
        return ServerDirectoryFactory.getVersion(directoryItemClass, moduleId);
    }

    @Override
    public void addressCountryDelete(int id, String flag) throws BGException, BGMessageException {
        PreparedStatement ps;
        Connection con = this.getConnection();
        try {
            ps = con.prepareStatement("SELECT * FROM address_city WHERE country_id=?");
            try {
                ps.setInt(1, id);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        if (flag != null && flag.equals("new")) {
            new ParameterDao(con).deleteAddressParams("address_country", id);
        }
        try {
            ps = con.prepareStatement("DELETE FROM address_country WHERE id=?");
            try {
                ps.setInt(1, id);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @Override
    public void addressHouseDelete(int id) throws BGException, BGMessageException {
        if (id >= 0) {
            PreparedStatement ps;
            Connection con = this.getConnection();
            String query = "SELECT count(*) FROM " + ContractParameterPrefType.TYPE_ADDRESS.getTableName() + " WHERE hid=?";
            try {
                ps = con.prepareStatement(query);
                try {
                    ps.setInt(1, id);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next() && rs.getInt(1) > 0) {
                            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0442\u0430\u043a\u043e\u0439 \u0430\u0434\u0440\u0435\u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            try {
                ps = con.prepareStatement("DELETE FROM address_house WHERE id=?");
                try {
                    ps.setInt(1, id);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    @Override
    public void addressDirectoryDelete(int id, int mode, String flag) throws BGException, BGMessageException {
        block14: {
            String table = this.getTable(mode);
            if (table == null) {
                return;
            }
            boolean fl = false;
            Connection con = this.getConnection();
            StringBuilder query = new StringBuilder();
            try {
                if (mode == 6 || mode == 8 || mode == 7) {
                    query.append("SELECT count(*) FROM address_house WHERE ");
                    if (mode == 6) {
                        query.append("areaid");
                    } else if (mode == 8) {
                        query.append("quarterid");
                    } else if (mode == 7) {
                        query.append("streetid");
                    }
                    query.append("=");
                    query.append(id);
                    fl = this.check(con, query.toString());
                } else if (mode == 5) {
                    fl = !fl & this.cityCheck(con, id, "area");
                    fl = !fl & this.cityCheck(con, id, "quarter");
                    fl = !fl & this.cityCheck(con, id, "street");
                }
                if (fl) {
                    if (flag != null && flag.equals("new")) {
                        new ParameterDao(con).deleteAddressParams(table, id);
                    }
                    query = new StringBuilder();
                    query.append("DELETE FROM ");
                    query.append(table);
                    query.append(" WHERE id=?");
                    this.delete(con, query.toString(), id);
                    if (mode == 5) {
                        this.delete(con, "DELETE FROM address_area WHERE cityid=?", id);
                        this.delete(con, "DELETE FROM address_street WHERE cityid=?", id);
                        this.delete(con, "DELETE FROM address_quarter WHERE cityid=?", id);
                    }
                    break block14;
                }
                throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0434\u043e\u043c\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    private boolean cityCheck(Connection con, int id, String name) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT count(*) FROM address_house AS h LEFT JOIN address_");
        query.append(name);
        query.append(" AS c ON c.id=h.");
        query.append(name);
        query.append("id WHERE c.cityid=");
        query.append(id);
        return this.check(con, query.toString());
    }

    private boolean check(Connection con, String query) throws SQLException {
        boolean fl = false;
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            fl = rs.getInt(1) == 0;
        }
        rs.close();
        st.close();
        return fl;
    }

    private void delete(Connection con, String query, int id) throws SQLException {
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    private String getTable(int mode) {
        String table = null;
        switch (mode) {
            case 0: {
                table = "contract_charge_types";
                break;
            }
            case 1: 
            case 9: {
                table = "contract_payment_types";
                break;
            }
            case 5: {
                table = "address_city";
                break;
            }
            case 6: {
                table = "address_area";
                break;
            }
            case 7: {
                table = "address_street";
                break;
            }
            case 8: {
                table = "address_quarter";
                break;
            }
            case 20: {
                table = "address_country";
                break;
            }
            case 11: {
                table = "contract_parameter_type_4_directory";
                break;
            }
            case 17: {
                table = "contract_comment_patterns";
                break;
            }
            case 15: {
                table = "script";
                break;
            }
            default: {
                table = null;
            }
        }
        return table;
    }

    @Override
    public void addressImport(int mode, int id, String data) throws BGException, BGMessageException {
        if (id < 1) {
            return;
        }
        String table = this.getTable(mode);
        Connection con = this.getConnection();
        switch (mode) {
            case 20: {
                break;
            }
            case 5: {
                this.importData(con, table, "country_id", id, data);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.importData(con, table, "cityid", id, data);
                break;
            }
            case 9: {
                this.importHouseData(con, "address_house", id, data);
            }
        }
    }

    private void importHouseData(Connection con, String table, int id, String data) throws BGException, BGMessageException {
        try (PreparedStatement psSelect = con.prepareStatement("SELECT COUNT(*) FROM " + table + " WHERE streetid=? AND house=? AND frac=?");
             PreparedStatement psInsert = con.prepareStatement("INSERT INTO " + table + " SET streetid=?, house=?, frac=?");){
            psSelect.setInt(1, id);
            psInsert.setInt(1, id);
            for (String a : data.split("\n")) {
                Object house = "";
                Object frac = "";
                boolean digit = true;
                for (char ch : a.toCharArray()) {
                    if (digit && Character.isDigit(ch)) {
                        house = (String)house + ch;
                        continue;
                    }
                    digit = false;
                    frac = (String)frac + ch;
                }
                psSelect.setString(2, (String)house);
                psSelect.setString(3, (String)frac);
                boolean insert = false;
                try (ResultSet resultSet = psSelect.executeQuery();){
                    while (resultSet.next()) {
                        insert = resultSet.getInt(1) == 0;
                    }
                }
                if (!insert) continue;
                psInsert.setString(2, (String)house);
                psInsert.setString(3, (String)frac);
                psInsert.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void importData(Connection con, String table, String parentName, int id, String data) throws BGException, BGMessageException {
        try (PreparedStatement psSelect = con.prepareStatement("SELECT COUNT(*) FROM " + table + " WHERE title=?");
             PreparedStatement psInsert = con.prepareStatement("INSERT INTO " + table + " SET title=?, " + parentName + "=?");){
            psInsert.setInt(2, id);
            for (String a : data.split("\n")) {
                psSelect.setString(1, a);
                boolean insert = false;
                ResultSet resultSet = psSelect.executeQuery();
                while (resultSet.next()) {
                    insert = resultSet.getInt(1) == 0;
                }
                resultSet.close();
                if (!insert) continue;
                psInsert.setString(1, a);
                psInsert.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

