/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import bitel.billing.module.common.ModTreeNode;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeTree;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.common.Utils;

public class CodeTreeKeyListener
extends KeyAdapter
implements KeyListener {
    private DynamicCodeTree dynamicCodeTree;
    private JTree tree;
    private String pattern;
    private Popup popup = null;
    private List<DynamicClass> classes;

    protected CodeTreeKeyListener(DynamicCodeTree dynamicCodeTree, JTree tree, List<DynamicClass> classes) {
        this.dynamicCodeTree = dynamicCodeTree;
        this.tree = tree;
        this.classes = classes;
        this.tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CodeTreeKeyListener.this.showSearchField();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CodeTreeKeyListener.this.hideSearchField();
            }
        });
    }

    private void hideSearchField() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.dynamicCodeTree.fireActionPerformed(new ActionEvent(e.getSource(), 1, "foobar"));
            List<String> selectedClasses = this.dynamicCodeTree.getSelectedClass();
            if (selectedClasses.size() > 0) {
                this.pattern = null;
                this.dynamicCodeTree.recreateTree(this.classes);
                this.dynamicCodeTree.setSelectedClass(selectedClasses.get(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\u001b') {
            this.pattern = null;
        } else {
            if (!Character.isDefined(ch) || ch == '\n') {
                return;
            }
            if (ch == '\b') {
                if (this.pattern == null || this.pattern.length() == 1) {
                    this.dynamicCodeTree.recreateTree(this.classes);
                }
                if (this.pattern != null && this.pattern.length() > 1) {
                    this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                } else {
                    if (this.pattern == null || this.pattern.length() != 1) return;
                    this.pattern = null;
                }
            } else {
                this.pattern = this.pattern == null ? ("" + ch).toLowerCase() : (this.pattern + ch).toLowerCase();
            }
        }
        this.showSearchField();
        this.filtred();
    }

    private void showSearchField() {
        this.hideSearchField();
        if (Utils.notBlankString((String)this.pattern)) {
            Point p = this.tree.getParent().getLocationOnScreen();
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(this.pattern);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.popup = popupFactory.getPopup(this.tree, toolTip, p.x, p.y - toolTip.getPreferredSize().height);
            this.popup.show();
        }
    }

    private void filtred() {
        if (this.pattern != null && this.pattern.length() > 2) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            List<ModTreeNode> finded = this.findNode(root, this.pattern.toLowerCase().trim());
            ModTreeNode rootNode = new ModTreeNode("/", "packet");
            rootNode.setAttribute("name", (Object)".");
            rootNode.setAttribute("type", (Object)1);
            rootNode.setText("\u041d\u0430\u0439\u0434\u0435\u043d\u043e:");
            for (ModTreeNode node : finded) {
                Object packageWasAdded = node.getAttribute("packageWasAdded");
                if (packageWasAdded == null || !((Boolean)packageWasAdded).booleanValue()) {
                    Object filePackage = node.getAttribute("clazz");
                    node.setText(node.getText() + " (" + filePackage + ")");
                    node.setAttribute("packageWasAdded", (Object)true);
                }
                rootNode.add((MutableTreeNode)node);
            }
            this.tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
            this.tree.revalidate();
            this.tree.repaint();
        }
    }

    public List<ModTreeNode> findNode(DefaultMutableTreeNode node, String search) {
        ArrayList<ModTreeNode> finded = new ArrayList<ModTreeNode>();
        for (int x = 0; x < node.getChildCount(); ++x) {
            ModTreeNode treeNode = (ModTreeNode)node.getChildAt(x);
            if (treeNode.getChildCount() > 0) {
                finded.addAll(this.findNode((DefaultMutableTreeNode)treeNode, search));
                continue;
            }
            if (!treeNode.getText().toLowerCase().contains(search)) continue;
            finded.add(treeNode);
        }
        return finded;
    }

    public String getPattern() {
        return this.pattern;
    }
}

